/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.loader.fresco;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.memory.PooledByteBufferInputStream;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.github.piasy.biv.utils.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ImageDownloadSubscriber
extends BaseDataSubscriber<CloseableReference<PooledByteBuffer>> {
    private static int sCounter = 0;
    private final File mTempFile;
    private volatile boolean mFinished;

    public ImageDownloadSubscriber(Context context) {
        this.mTempFile = new File(context.getCacheDir(), System.currentTimeMillis() + "_" + ImageDownloadSubscriber.nextCounter());
    }

    private static synchronized int nextCounter() {
        return ++sCounter;
    }

    public void onProgressUpdate(DataSource<CloseableReference<PooledByteBuffer>> dataSource) {
        if (!this.mFinished) {
            this.onProgress((int)(dataSource.getProgress() * 100.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNewResultImpl(DataSource<CloseableReference<PooledByteBuffer>> dataSource) {
        FileOutputStream outputStream;
        PooledByteBufferInputStream inputStream;
        CloseableReference closeableRef;
        block5: {
            if (!dataSource.isFinished()) {
                return;
            }
            closeableRef = (CloseableReference)dataSource.getResult();
            inputStream = null;
            outputStream = null;
            try {
                if (closeableRef == null) break block5;
                inputStream = new PooledByteBufferInputStream((PooledByteBuffer)closeableRef.get());
                outputStream = new FileOutputStream(this.mTempFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                this.mFinished = true;
                this.onSuccess(this.mTempFile);
            }
            catch (IOException e) {
                try {
                    this.onFail(e);
                }
                catch (Throwable throwable) {
                    CloseableReference.closeSafely((CloseableReference)closeableRef);
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
                CloseableReference.closeSafely((CloseableReference)closeableRef);
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(outputStream);
            }
        }
        CloseableReference.closeSafely((CloseableReference)closeableRef);
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(outputStream);
    }

    protected void onFailureImpl(DataSource<CloseableReference<PooledByteBuffer>> dataSource) {
        this.mFinished = true;
        this.onFail(new RuntimeException("onFailureImpl"));
    }

    @WorkerThread
    protected abstract void onProgress(int var1);

    @WorkerThread
    protected abstract void onSuccess(File var1);

    @WorkerThread
    protected abstract void onFail(Throwable var1);
}

