/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.loader.fresco;

import android.content.Context;
import android.support.annotation.WorkerThread;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.memory.PooledByteBufferInputStream;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public abstract class ImageDownloadSubscriber
extends BaseDataSubscriber<CloseableReference<PooledByteBuffer>> {
    private final File mTempFile;
    private volatile boolean mFinished;

    public ImageDownloadSubscriber(Context context) {
        this.mTempFile = new File(context.getCacheDir(), "" + System.currentTimeMillis() + ".png");
    }

    public void onProgressUpdate(DataSource<CloseableReference<PooledByteBuffer>> dataSource) {
        if (!this.mFinished) {
            this.onProgress((int)(dataSource.getProgress() * 100.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNewResultImpl(DataSource<CloseableReference<PooledByteBuffer>> dataSource) {
        block6: {
            if (!dataSource.isFinished() || dataSource.getResult() == null) {
                return;
            }
            PooledByteBufferInputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = new PooledByteBufferInputStream((PooledByteBuffer)((CloseableReference)dataSource.getResult()).get());
                outputStream = new FileOutputStream(this.mTempFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                this.mFinished = true;
                this.onSuccess(this.mTempFile);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (IOException e) {
                this.onFail(e);
                break block6;
            }
            finally {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    protected void onFailureImpl(DataSource<CloseableReference<PooledByteBuffer>> dataSource) {
        this.mFinished = true;
        this.onFail(new RuntimeException("onFailureImpl"));
    }

    @WorkerThread
    protected abstract void onProgress(int var1);

    @WorkerThread
    protected abstract void onSuccess(File var1);

    @WorkerThread
    protected abstract void onFail(Throwable var1);
}

