/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.loader.fresco;

import android.content.Context;
import android.net.Uri;
import com.facebook.binaryresource.FileBinaryResource;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.disk.FileCache;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.DraweeConfig;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.cache.DefaultCacheKeyFactory;
import com.facebook.imagepipeline.core.DefaultExecutorSupplier;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.imagepipeline.request.ImageRequest;
import com.github.piasy.biv.loader.ImageLoader;
import com.github.piasy.biv.loader.fresco.ImageDownloadSubscriber;
import com.github.piasy.biv.metadata.ImageInfoExtractor;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;

public final class FrescoImageLoader
implements ImageLoader {
    private final Context mAppContext;
    private final DefaultExecutorSupplier mExecutorSupplier;
    private final ConcurrentHashMap<Integer, DataSource> mRequestSourceMap = new ConcurrentHashMap();

    private FrescoImageLoader(Context appContext) {
        this.mAppContext = appContext;
        this.mExecutorSupplier = new DefaultExecutorSupplier(Runtime.getRuntime().availableProcessors());
    }

    public static FrescoImageLoader with(Context appContext) {
        return FrescoImageLoader.with(appContext, null, null);
    }

    public static FrescoImageLoader with(Context appContext, ImagePipelineConfig imagePipelineConfig) {
        return FrescoImageLoader.with(appContext, imagePipelineConfig, null);
    }

    public static FrescoImageLoader with(Context appContext, ImagePipelineConfig imagePipelineConfig, DraweeConfig draweeConfig) {
        Fresco.initialize((Context)appContext, (ImagePipelineConfig)imagePipelineConfig, (DraweeConfig)draweeConfig);
        return new FrescoImageLoader(appContext);
    }

    public void loadImage(int requestId, Uri uri, final ImageLoader.Callback callback) {
        ImageRequest request = ImageRequest.fromUri((Uri)uri);
        final File localCache = this.getCacheFile(request);
        if (localCache.exists()) {
            this.mExecutorSupplier.forLocalStorageRead().execute(new Runnable(){

                @Override
                public void run() {
                    callback.onCacheHit(ImageInfoExtractor.getImageType((File)localCache), localCache);
                    callback.onSuccess(localCache);
                }
            });
        } else {
            callback.onStart();
            callback.onProgress(0);
            ImagePipeline pipeline = Fresco.getImagePipeline();
            DataSource source = pipeline.fetchEncodedImage(request, (Object)true);
            source.subscribe((DataSubscriber)new ImageDownloadSubscriber(this.mAppContext){

                @Override
                protected void onProgress(int progress) {
                    callback.onProgress(progress);
                }

                @Override
                protected void onSuccess(File image) {
                    callback.onFinish();
                    callback.onCacheMiss(ImageInfoExtractor.getImageType((File)image), image);
                    callback.onSuccess(image);
                }

                @Override
                protected void onFail(Throwable t) {
                    t.printStackTrace();
                    callback.onFail((Exception)t);
                }
            }, this.mExecutorSupplier.forBackgroundTasks());
            this.closeSource(requestId);
            this.saveSource(requestId, source);
        }
    }

    public void prefetch(Uri uri) {
        ImagePipeline pipeline = Fresco.getImagePipeline();
        pipeline.prefetchToDiskCache(ImageRequest.fromUri((Uri)uri), (Object)false);
    }

    public void cancel(int requestId) {
        this.closeSource(requestId);
    }

    private void saveSource(int requestId, DataSource target) {
        this.mRequestSourceMap.put(requestId, target);
    }

    private void closeSource(int requestId) {
        DataSource source = this.mRequestSourceMap.remove(requestId);
        if (source != null) {
            source.close();
        }
    }

    private File getCacheFile(ImageRequest request) {
        FileCache mainFileCache = ImagePipelineFactory.getInstance().getMainFileCache();
        CacheKey cacheKey = DefaultCacheKeyFactory.getInstance().getEncodedCacheKey(request, (Object)false);
        File cacheFile = request.getSourceFile();
        if (mainFileCache.hasKey(cacheKey) && mainFileCache.getResource(cacheKey) != null) {
            cacheFile = ((FileBinaryResource)mainFileCache.getResource(cacheKey)).getFile();
        }
        return cacheFile;
    }
}

