/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.view;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.Keep;
import androidx.annotation.RequiresPermission;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.github.piasy.biv.BigImageViewer;
import com.github.piasy.biv.R;
import com.github.piasy.biv.indicator.ProgressIndicator;
import com.github.piasy.biv.loader.ImageLoader;
import com.github.piasy.biv.metadata.ImageInfoExtractor;
import com.github.piasy.biv.utils.DisplayOptimizeListener;
import com.github.piasy.biv.utils.IOUtils;
import com.github.piasy.biv.utils.ThreadedCallbacks;
import com.github.piasy.biv.view.ImageSaveCallback;
import com.github.piasy.biv.view.ImageShownCallback;
import com.github.piasy.biv.view.ImageViewFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

@Keep
public class BigImageView
extends FrameLayout
implements ImageLoader.Callback {
    public static final int INIT_SCALE_TYPE_CENTER = 0;
    public static final int INIT_SCALE_TYPE_CENTER_CROP = 1;
    public static final int INIT_SCALE_TYPE_CENTER_INSIDE = 2;
    public static final int INIT_SCALE_TYPE_FIT_CENTER = 3;
    public static final int INIT_SCALE_TYPE_FIT_END = 4;
    public static final int INIT_SCALE_TYPE_FIT_START = 5;
    public static final int INIT_SCALE_TYPE_FIT_XY = 6;
    public static final int INIT_SCALE_TYPE_CUSTOM = 7;
    public static final int INIT_SCALE_TYPE_START = 8;
    public static final int DEFAULT_IMAGE_SCALE_TYPE = 3;
    public static final ImageView.ScaleType[] IMAGE_SCALE_TYPES = new ImageView.ScaleType[]{ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_XY};
    private final ImageLoader mImageLoader;
    private final ImageLoader.Callback mInternalCallback;
    private final Handler mUiHandler = new Handler(Looper.getMainLooper());
    private ImageViewFactory mViewFactory;
    private View mMainView;
    private View mThumbnailView;
    private SubsamplingScaleImageView mSSIV;
    private View mProgressIndicatorView;
    private ImageView mFailureImageView;
    private boolean mDelayMainImageForTransition = false;
    private ImageSaveCallback mImageSaveCallback;
    private ImageShownCallback mImageShownCallback;
    private ImageLoader.Callback mUserCallback;
    private File mCurrentImageFile;
    private Uri mUri;
    private Uri mThumbnail;
    private View.OnClickListener mOnClickListener;
    private View.OnLongClickListener mOnLongClickListener;
    private ProgressIndicator mProgressIndicator;
    private DisplayOptimizeListener mDisplayOptimizeListener;
    private int mInitScaleType;
    private ImageView.ScaleType mThumbnailScaleType;
    private ImageView.ScaleType mFailureImageScaleType;
    private boolean mOptimizeDisplay;
    private boolean mTapToRetry;
    private final View.OnClickListener mFailureImageClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (BigImageView.this.mTapToRetry) {
                BigImageView.this.showImage(BigImageView.this.mThumbnail, BigImageView.this.mUri);
            } else if (BigImageView.this.mOnClickListener != null) {
                BigImageView.this.mOnClickListener.onClick(v);
            }
        }
    };

    public BigImageView(Context context) {
        this(context, null);
    }

    public BigImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BigImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int scaleTypeIndex;
        TypedArray array = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BigImageView, defStyleAttr, 0);
        this.mInitScaleType = array.getInteger(R.styleable.BigImageView_initScaleType, 3);
        if (array.hasValue(R.styleable.BigImageView_failureImage)) {
            scaleTypeIndex = array.getInteger(R.styleable.BigImageView_failureImageInitScaleType, 3);
            this.mFailureImageScaleType = BigImageView.scaleType(scaleTypeIndex);
            Drawable mFailureImageDrawable = array.getDrawable(R.styleable.BigImageView_failureImage);
            this.setFailureImage(mFailureImageDrawable);
        }
        if (array.hasValue(R.styleable.BigImageView_thumbnailScaleType)) {
            scaleTypeIndex = array.getInteger(R.styleable.BigImageView_thumbnailScaleType, 3);
            this.mThumbnailScaleType = BigImageView.scaleType(scaleTypeIndex);
        }
        this.mOptimizeDisplay = array.getBoolean(R.styleable.BigImageView_optimizeDisplay, true);
        this.mTapToRetry = array.getBoolean(R.styleable.BigImageView_tapToRetry, true);
        array.recycle();
        this.mImageLoader = this.isInEditMode() ? null : BigImageViewer.imageLoader();
        this.mInternalCallback = ThreadedCallbacks.create(ImageLoader.Callback.class, this);
        this.mViewFactory = new ImageViewFactory();
    }

    public static ImageView.ScaleType scaleType(int value) {
        if (0 <= value && value < IMAGE_SCALE_TYPES.length) {
            return IMAGE_SCALE_TYPES[value];
        }
        return IMAGE_SCALE_TYPES[3];
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mOnClickListener = listener;
        if (this.mMainView != null) {
            this.mMainView.setOnClickListener(listener);
        }
    }

    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.mOnLongClickListener = listener;
        if (this.mMainView != null) {
            this.mMainView.setOnLongClickListener(listener);
        }
    }

    public void setImageViewFactory(ImageViewFactory viewFactory) {
        if (viewFactory == null) {
            return;
        }
        this.mViewFactory = viewFactory;
    }

    public void setFailureImageInitScaleType(ImageView.ScaleType scaleType) {
        this.mFailureImageScaleType = scaleType;
    }

    public void setFailureImage(Drawable failureImage) {
        if (failureImage == null) {
            return;
        }
        if (this.mFailureImageView == null) {
            this.mFailureImageView = new ImageView(this.getContext());
            this.mFailureImageView.setVisibility(8);
            this.mFailureImageView.setOnClickListener(this.mFailureImageClickListener);
            if (this.mFailureImageScaleType != null) {
                this.mFailureImageView.setScaleType(this.mFailureImageScaleType);
            }
            this.addView((View)this.mFailureImageView);
        }
        this.mFailureImageView.setImageDrawable(failureImage);
    }

    public void setInitScaleType(int initScaleType) {
        if (this.mSSIV == null) {
            return;
        }
        this.mInitScaleType = initScaleType;
        switch (initScaleType) {
            case 1: {
                this.mSSIV.setMinimumScaleType(2);
                break;
            }
            case 7: {
                this.mSSIV.setMinimumScaleType(3);
                break;
            }
            case 8: {
                this.mSSIV.setMinimumScaleType(4);
                break;
            }
            default: {
                this.mSSIV.setMinimumScaleType(1);
            }
        }
        if (this.mDisplayOptimizeListener != null) {
            this.mDisplayOptimizeListener.setInitScaleType(initScaleType);
        }
    }

    public void setThumbnailScaleType(ImageView.ScaleType scaleType) {
        this.mThumbnailScaleType = scaleType;
    }

    public void setOptimizeDisplay(boolean optimizeDisplay) {
        if (this.mSSIV == null) {
            return;
        }
        this.mOptimizeDisplay = optimizeDisplay;
        if (this.mOptimizeDisplay) {
            this.mDisplayOptimizeListener = new DisplayOptimizeListener(this.mSSIV);
            this.mSSIV.setOnImageEventListener((SubsamplingScaleImageView.OnImageEventListener)this.mDisplayOptimizeListener);
        } else {
            this.mDisplayOptimizeListener = null;
            this.mSSIV.setOnImageEventListener(null);
        }
    }

    public void setTapToRetry(boolean tapToRetry) {
        this.mTapToRetry = tapToRetry;
    }

    public void setImageSaveCallback(ImageSaveCallback imageSaveCallback) {
        this.mImageSaveCallback = imageSaveCallback;
    }

    public void setImageShownCallback(ImageShownCallback imageCycleCallback) {
        this.mImageShownCallback = imageCycleCallback;
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        this.mProgressIndicator = progressIndicator;
    }

    public void setImageLoaderCallback(ImageLoader.Callback imageLoaderCallback) {
        this.mUserCallback = imageLoaderCallback;
    }

    public File getCurrentImageFile() {
        return this.mCurrentImageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public void saveImageIntoGallery() {
        block13: {
            block12: {
                boolean saved;
                Uri imageUri;
                block11: {
                    if (this.mCurrentImageFile == null) {
                        this.fireSaveImageCallback(null, new IllegalStateException("image not downloaded yet"));
                        return;
                    }
                    if (Build.VERSION.SDK_INT < 29) break block12;
                    OutputStream outputStream = null;
                    FileInputStream inputStream = null;
                    imageUri = null;
                    saved = false;
                    try {
                        ContentResolver resolver = this.getContext().getContentResolver();
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("_display_name", this.mCurrentImageFile.getName());
                        contentValues.put("mime_type", "image/jpg");
                        contentValues.put("relative_path", Environment.DIRECTORY_PICTURES);
                        imageUri = resolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
                        if (imageUri != null) {
                            outputStream = resolver.openOutputStream(imageUri);
                            inputStream = new FileInputStream(this.mCurrentImageFile);
                            IOUtils.copy(inputStream, outputStream);
                            saved = true;
                        } else {
                            this.fireSaveImageCallback(null, new RuntimeException("saveImageIntoGallery fail: insert to MediaStore error"));
                        }
                        IOUtils.closeQuietly(inputStream);
                    }
                    catch (IOException e) {
                        this.fireSaveImageCallback(null, e);
                        break block11;
                    }
                    finally {
                        IOUtils.closeQuietly(inputStream);
                        IOUtils.closeQuietly(outputStream);
                    }
                    IOUtils.closeQuietly(outputStream);
                }
                if (saved) {
                    this.fireSaveImageCallback(imageUri.toString(), null);
                }
                break block13;
            }
            try {
                String result = MediaStore.Images.Media.insertImage((ContentResolver)this.getContext().getContentResolver(), (String)this.mCurrentImageFile.getAbsolutePath(), (String)this.mCurrentImageFile.getName(), (String)"");
                this.fireSaveImageCallback(result, null);
            }
            catch (IOException e) {
                this.fireSaveImageCallback(null, e);
            }
        }
    }

    @WorkerThread
    private void fireSaveImageCallback(final String uri, final Throwable error) {
        final ImageSaveCallback imageSaveCallback = this.mImageSaveCallback;
        if (imageSaveCallback != null) {
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (error != null) {
                        imageSaveCallback.onFail(error);
                    } else {
                        imageSaveCallback.onSuccess(uri);
                    }
                }
            });
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancel();
    }

    public void showImage(Uri uri) {
        this.showImage(Uri.EMPTY, uri);
    }

    public void showImage(Uri thumbnail, Uri uri) {
        this.showImage(thumbnail, uri, false);
    }

    public void showImage(Uri thumbnail, Uri uri, boolean delayMainImageForTransition) {
        this.mThumbnail = thumbnail;
        this.mUri = uri;
        this.clearThumbnailAndProgressIndicator();
        this.mDelayMainImageForTransition = delayMainImageForTransition;
        if (this.mDelayMainImageForTransition) {
            BigImageViewer.prefetch(uri);
            this.mImageLoader.loadImage(this.hashCode(), thumbnail, this.mInternalCallback);
        } else {
            this.mImageLoader.loadImage(this.hashCode(), uri, this.mInternalCallback);
        }
        if (this.mFailureImageView != null) {
            this.mFailureImageView.setVisibility(8);
        }
    }

    public void loadMainImageNow() {
        this.mDelayMainImageForTransition = false;
        this.mImageLoader.loadImage(this.hashCode(), this.mUri, this.mInternalCallback);
    }

    public void cancel() {
        this.mImageLoader.cancel(this.hashCode());
    }

    public SubsamplingScaleImageView getSSIV() {
        return this.mSSIV;
    }

    public View getMainView() {
        return this.mMainView;
    }

    @Override
    public void onCacheHit(int imageType, File image) {
        this.mCurrentImageFile = image;
        this.doShowImage(imageType, image, this.mDelayMainImageForTransition);
        if (this.mUserCallback != null) {
            this.mUserCallback.onCacheHit(imageType, image);
        }
    }

    @Override
    public void onCacheMiss(int imageType, File image) {
        this.mCurrentImageFile = image;
        this.doShowImage(imageType, image, this.mDelayMainImageForTransition);
        if (this.mUserCallback != null) {
            this.mUserCallback.onCacheMiss(imageType, image);
        }
    }

    @Override
    public void onStart() {
        if (this.mThumbnail != Uri.EMPTY) {
            this.mThumbnailView = this.mViewFactory.createThumbnailView(this.getContext(), this.mThumbnailScaleType, true);
            this.mViewFactory.loadThumbnailContent(this.mThumbnailView, this.mThumbnail);
            if (this.mThumbnailView != null) {
                this.addView(this.mThumbnailView, -1, -1);
            }
        }
        if (this.mProgressIndicator != null) {
            this.mProgressIndicatorView = this.mProgressIndicator.getView(this);
            this.mProgressIndicator.onStart();
            if (this.mProgressIndicatorView != null) {
                this.addView(this.mProgressIndicatorView);
            }
        }
        if (this.mUserCallback != null) {
            this.mUserCallback.onStart();
        }
    }

    @Override
    public void onProgress(int progress) {
        if (this.mProgressIndicator != null) {
            this.mProgressIndicator.onProgress(progress);
        }
        if (this.mUserCallback != null) {
            this.mUserCallback.onProgress(progress);
        }
    }

    @Override
    public void onFinish() {
        this.doOnFinish();
        if (this.mUserCallback != null) {
            this.mUserCallback.onFinish();
        }
    }

    @Override
    public void onSuccess(File image) {
        if (this.mUserCallback != null) {
            this.mUserCallback.onSuccess(image);
        }
    }

    @Override
    public void onFail(Exception error) {
        this.showFailImage();
        if (this.mUserCallback != null) {
            this.mUserCallback.onFail(error);
        }
    }

    @UiThread
    private void doOnFinish() {
        if (this.mOptimizeDisplay) {
            AnimationSet set = new AnimationSet(true);
            AlphaAnimation animation = new AlphaAnimation(1.0f, 0.0f);
            animation.setDuration(500L);
            animation.setFillAfter(true);
            set.addAnimation((Animation)animation);
            if (this.mThumbnailView != null) {
                this.mThumbnailView.setAnimation((Animation)set);
            }
            if (this.mProgressIndicatorView != null) {
                this.mProgressIndicatorView.setAnimation((Animation)set);
            }
            if (this.mProgressIndicator != null) {
                this.mProgressIndicator.onFinish();
            }
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (BigImageView.this.mThumbnailView != null) {
                        BigImageView.this.mThumbnailView.setVisibility(8);
                    }
                    if (BigImageView.this.mProgressIndicatorView != null) {
                        BigImageView.this.mProgressIndicatorView.setVisibility(8);
                    }
                    if (BigImageView.this.mThumbnailView != null || BigImageView.this.mProgressIndicatorView != null) {
                        BigImageView.this.post(new Runnable(){

                            @Override
                            public void run() {
                                BigImageView.this.clearThumbnailAndProgressIndicator();
                            }
                        });
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        } else {
            if (this.mProgressIndicator != null) {
                this.mProgressIndicator.onFinish();
            }
            this.clearThumbnailAndProgressIndicator();
        }
    }

    @UiThread
    private void doShowImage(int imageType, File image, boolean useThumbnailView) {
        if (useThumbnailView) {
            if (this.mThumbnailView != null) {
                this.removeView(this.mThumbnailView);
            }
            this.mThumbnailView = this.mViewFactory.createThumbnailView(this.getContext(), this.mThumbnailScaleType, false);
            if (this.mThumbnailView != null) {
                this.addView(this.mThumbnailView, -1, -1);
                this.mThumbnailView.setOnClickListener(this.mOnClickListener);
                this.mThumbnailView.setOnLongClickListener(this.mOnLongClickListener);
                if (this.mThumbnailView instanceof ImageView) {
                    this.mViewFactory.loadThumbnailContent(this.mThumbnailView, image);
                    if (this.mImageShownCallback != null) {
                        this.mImageShownCallback.onThumbnailShown();
                    }
                }
            }
        } else {
            if (this.mMainView != null) {
                this.removeView(this.mMainView);
            }
            this.mMainView = this.mViewFactory.createMainView(this.getContext(), imageType, this.mInitScaleType);
            if (this.mMainView == null) {
                this.onFail(new RuntimeException("Image type not supported: " + ImageInfoExtractor.typeName(imageType)));
                return;
            }
            this.addView(this.mMainView, -1, -1);
            this.mMainView.setOnClickListener(this.mOnClickListener);
            this.mMainView.setOnLongClickListener(this.mOnLongClickListener);
            if (this.mMainView instanceof SubsamplingScaleImageView) {
                this.mSSIV = (SubsamplingScaleImageView)this.mMainView;
                this.mSSIV.setMinimumTileDpi(160);
                this.setOptimizeDisplay(this.mOptimizeDisplay);
                this.setInitScaleType(this.mInitScaleType);
            }
            if (this.mViewFactory.isAnimatedContent(imageType)) {
                this.mViewFactory.loadAnimatedContent(this.mMainView, imageType, image);
            } else {
                this.mViewFactory.loadSillContent(this.mMainView, Uri.fromFile((File)image));
            }
            if (this.mImageShownCallback != null) {
                this.mImageShownCallback.onMainImageShown();
            }
        }
        if (this.mFailureImageView != null) {
            this.mFailureImageView.setVisibility(8);
        }
    }

    @UiThread
    private void showFailImage() {
        if (this.mFailureImageView == null) {
            return;
        }
        if (this.mMainView != null) {
            this.removeView(this.mMainView);
        }
        this.mFailureImageView.setVisibility(0);
        this.clearThumbnailAndProgressIndicator();
    }

    private void clearThumbnailAndProgressIndicator() {
        if (this.mThumbnailView != null) {
            this.removeView(this.mThumbnailView);
            this.mThumbnailView = null;
        }
        if (this.mProgressIndicatorView != null) {
            this.removeView(this.mProgressIndicatorView);
            this.mProgressIndicatorView = null;
        }
    }
}

