/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public final class ImageInfoExtractor {
    public static final int TYPE_STILL_IMAGE = 0;
    public static final int TYPE_GIF = 1;
    public static final int TYPE_ANIMATED_WEBP = 2;
    public static final int TYPE_STILL_WEBP = 3;
    private static final int ANIMATED_WEBP_MASK = 2;

    private ImageInfoExtractor() {
    }

    public static int getImageType(File file) {
        int type = 0;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            byte[] header = new byte[21];
            int read = inputStream.read(header);
            if (read >= 3 && ImageInfoExtractor.isGifHeader(header)) {
                type = 1;
            } else if (read >= 12 && ImageInfoExtractor.isWebpHeader(header)) {
                type = read >= 17 && ImageInfoExtractor.isExtendedWebp(header) && (header[20] & 2) != 0 ? 2 : 3;
            }
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return type;
    }

    public static String typeName(int type) {
        switch (type) {
            case 1: {
                return "GIF";
            }
            case 3: {
                return "STILL_WEBP";
            }
            case 2: {
                return "ANIMATED_WEBP";
            }
        }
        return "STILL_IMAGE";
    }

    private static boolean isGifHeader(byte[] header) {
        return header[0] == 71 && header[1] == 73 && header[2] == 70;
    }

    private static boolean isWebpHeader(byte[] header) {
        return header[0] == 82 && header[1] == 73 && header[2] == 70 && header[3] == 70 && header[8] == 87 && header[9] == 69 && header[10] == 66 && header[11] == 80;
    }

    private static boolean isExtendedWebp(byte[] header) {
        return header[12] == 86 && header[13] == 80 && header[14] == 56 && header[15] == 88;
    }
}

