/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.profiling.startup;

import com.github.phillipkruger.profiling.UserEvent;
import com.github.phillipkruger.profiling.UserEventConverter;
import com.github.phillipkruger.profiling.repository.ClientNotAvailableException;
import com.github.phillipkruger.profiling.startup.BootstrapData;
import com.github.phillipkruger.profiling.startup.BootstrapService;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;

@ApplicationScoped
public class BootstrapService {
    private static final Logger log = Logger.getLogger(BootstrapService.class.getName());
    private static boolean isRunning = false;
    @Inject
    private UserEventConverter userEventConverter;
    @Inject
    @ConfigProperty(name="java.io.tmpdir", defaultValue="/tmp")
    private String tempDir;
    @Inject
    @ConfigProperty(name="elasticsearch.cluster.name", defaultValue="the-red-cluster")
    private String clusterName;
    @Resource(lookup="java:app/AppName")
    private String appName;
    private Node node = null;
    private static final String SLASH = "/";

    public void init(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        this.startElastic();
        this.logEvent(this.createGymEvent(1));
        this.logEvent(this.createDeviceEvent(1));
        this.logEvent(this.createGymEvent(2));
        this.logEvent(this.createDeviceEvent(2));
        this.logEvent(this.createGymEvent(3));
        this.logEvent(this.createDeviceEvent(3));
        this.logEvent(this.createGymEvent(4));
        this.logEvent(this.createDeviceEvent(4));
    }

    private void startElastic() {
        if (!isRunning) {
            String homePath = this.tempDir + SLASH + this.appName + SLASH;
            log.log(Level.INFO, "====== Starting Elasticsearch server ====== ");
            log.log(Level.INFO, "====== path.home [{0}] ====== ", homePath);
            log.log(Level.INFO, "====== cluster.name [{0}] ====== ", this.clusterName);
            Settings.Builder settingsBuilder = Settings.builder().put("path.home", homePath).put("cluster.name", this.clusterName).put("node.name", "internal").put("client.transport.sniff", true).put("node.max_local_storage_nodes", 3);
            Settings settings = settingsBuilder.build();
            this.node = new PluginNode(settings);
            try {
                this.node = this.node.start();
            }
            catch (NodeValidationException ex) {
                throw new RuntimeException(ex);
            }
            log.log(Level.INFO, "====== Elasticsearch is running ====== ");
            isRunning = true;
        }
    }

    private void logEvent(UserEvent event) {
        try {
            this.getClient().prepareIndex("profiling", "event").setSource(this.userEventConverter.toJsonString(event), XContentType.JSON).get();
        }
        catch (NoNodeAvailableException nnae) {
            log.warning(nnae.getMessage());
        }
    }

    @Produces
    public Client getClient() throws ClientNotAvailableException {
        return this.node.client();
    }

    private UserEvent createGymEvent(int userId) {
        UserEvent e = new UserEvent();
        e.setUserId(userId);
        e.setTimeOccured(new Date());
        e.setEventName("Gym");
        e.setDurationInMinutes((int)Duration.ofMinutes(this.getRandomDuration()).toMinutes());
        e.setLocation(this.getRandomElement(BootstrapData.townOptions));
        e.setPartnerName(this.getRandomElement(BootstrapData.gymPartners));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("className", this.getRandomElement(BootstrapData.gymClassOptions));
        e.setMetadata(metadata);
        return e;
    }

    private UserEvent createDeviceEvent(int userId) {
        UserEvent e = new UserEvent();
        e.setUserId(userId);
        e.setTimeOccured(new Date());
        e.setEventName(this.getRandomElement(BootstrapData.sportType));
        e.setDurationInMinutes((int)Duration.ofMinutes(this.getRandomDuration()).toMinutes());
        e.setLocation(this.getRandomElement(BootstrapData.townOptions));
        e.setPartnerName(this.getRandomElement(BootstrapData.deviceOptions));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("calories", String.valueOf(this.getRandomCalories()));
        e.setMetadata(metadata);
        return e;
    }

    private String getRandomElement(String[] options) {
        int i = this.getRandomInt(0, options.length - 1);
        return options[i];
    }

    private int getRandomDuration() {
        return this.getRandomInt(30, 91);
    }

    private int getRandomCalories() {
        return this.getRandomInt(295, 750);
    }

    private int getRandomInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }
}

