/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.profiling.repository;

import com.github.phillipkruger.profiling.UserEvent;
import com.github.phillipkruger.profiling.UserEventConverter;
import com.github.phillipkruger.profiling.eventstatus.Successful;
import com.github.phillipkruger.profiling.membership.Membership;
import com.github.phillipkruger.profiling.membership.MembershipProxy;
import com.github.phillipkruger.profiling.repository.EventLoggerFallbackHandler;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.json.JsonObject;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;

@RequestScoped
public class EventLogger {
    private static final Logger log = Logger.getLogger(EventLogger.class.getName());
    @Inject
    private Client client;
    @Inject
    private UserEventConverter converter;
    @Inject
    @Successful
    private Event<UserEvent> successfulBroadcaster;
    @Inject
    @RestClient
    private MembershipProxy membershipProxy;

    @Counted(name="Events logged", absolute=true, monotonic=true)
    @Asynchronous
    @Retry(delay=10L, delayUnit=ChronoUnit.SECONDS, maxRetries=5)
    @Fallback(value=EventLoggerFallbackHandler.class)
    public Future<Void> logEvent(String token, @NotNull UserEvent event) {
        log.log(Level.SEVERE, ">>> Now (trying to )log event [{0}] ...", event);
        JsonObject json = this.converter.toJsonObject(event);
        int membershipId = json.getInt("userId");
        this.validateMembership(token, membershipId);
        IndexResponse response = (IndexResponse)this.client.prepareIndex("profiling", "event").setSource(json.toString(), XContentType.JSON).get();
        RestStatus status = response.status();
        if (status.getStatus() == 201) {
            this.successfulBroadcaster.fire((Object)event);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void handleSuccessfulEvents(@Observes @Successful UserEvent userEvent) {
        log.log(Level.INFO, ">>>>>>>>> Received event [{0}]", userEvent);
    }

    private void validateMembership(String token, int membershipId) {
        Membership membership = this.membershipProxy.getMembership("Bearer " + token, membershipId);
        log.log(Level.FINEST, "Validate membership = [{0}]", membership);
    }
}

