/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.profiling;

import com.github.phillipkruger.profiling.UserEvent;
import com.github.phillipkruger.profiling.membership.Membership;
import com.github.phillipkruger.profiling.membership.MembershipProxy;
import com.github.phillipkruger.profiling.repository.EventLogger;
import com.github.phillipkruger.profiling.repository.EventSearcher;
import java.time.temporal.ChronoUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.headers.Header;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.elasticsearch.client.transport.NoNodeAvailableException;

@RequestScoped
@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="Profile service", description="Build up a profile of the user")
public class ProfileService {
    private static final Logger log = Logger.getLogger(ProfileService.class.getName());
    @Inject
    private EventSearcher eventSearcher;
    @Inject
    private EventLogger eventLogger;
    @Inject
    @RestClient
    private MembershipProxy membershipProxy;
    @Inject
    private JsonWebToken callerPrincipal;
    private static final String SIZE_DESC = "Limit the events to return";
    private static final String REASON = "reason";

    @POST
    @Operation(description="Getting all the events for a certain user")
    @APIResponses(value={@APIResponse(responseCode="202", description="Accepted the event, queued to be stored"), @APIResponse(responseCode="401", description="User not authorized")})
    @SecurityRequirement(name="Authorization")
    @RolesAllowed(value={"admin", "user"})
    @Counted(name="User events created", absolute=true, monotonic=true)
    public Response logEvent(@NotNull @RequestBody(description="Log a new event.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserEvent.class))}) UserEvent event) {
        this.eventLogger.logEvent(this.callerPrincipal.getRawToken(), event);
        return Response.accepted((Object)event).build();
    }

    @GET
    @Path(value="user/{userId}")
    @Operation(description="Getting all the events for a certain user")
    @APIResponses(value={@APIResponse(responseCode="200", description="Successfull, returning events", content={@Content(schema=@Schema(implementation=UserEvent.class))}), @APIResponse(responseCode="401", description="User not authorized"), @APIResponse(responseCode="412", description="Membership not found, invalid userId", headers={@Header(name="reason")}), @APIResponse(responseCode="503", description="Proplem with a connection to a downstream service", headers={@Header(name="reason")})})
    @SecurityRequirement(name="Authorization")
    @RolesAllowed(value={"admin", "user"})
    @Traced(operationName="GetUserEvents", value=true)
    @CircuitBreaker(failOn={NoNodeAvailableException.class}, requestVolumeThreshold=1, failureRatio=1.0, delay=10L, delayUnit=ChronoUnit.SECONDS)
    @Counted(name="User events requests", absolute=true, monotonic=true)
    public Response getUserEvents(@Parameter(name="userId", description="The User Id of the member", required=true, allowEmptyValue=false, example="1") @PathParam(value="userId") int userId, @Parameter(name="size", description="Limit the events to return", required=false, allowEmptyValue=true, example="10") @DefaultValue(value="-1") @QueryParam(value="size") int size) {
        try {
            this.validateMembership(userId);
        }
        catch (NotFoundException nfe) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).header(REASON, (Object)("Membership [" + userId + "] does not exist")).build();
        }
        return this.eventSearcher.search("userId", (Object)userId, size);
    }

    @GET
    @Path(value="event/{eventName}")
    public Response searchEvents(@Parameter(name="eventName", description="The name of the event", required=true, allowEmptyValue=false, example="Gym") @PathParam(value="eventName") String eventName, @Parameter(name="size", description="Limit the events to return", required=false, allowEmptyValue=true, example="10") @DefaultValue(value="-1") @QueryParam(value="size") int size) {
        return this.eventSearcher.search("eventName", (Object)eventName, size);
    }

    @GET
    @Path(value="location/{location}")
    public Response searchLocations(@Parameter(name="location", description="The location of the event", required=true, allowEmptyValue=false, example="Johannesburg") @PathParam(value="location") String location, @Parameter(name="size", description="Limit the events to return", required=false, allowEmptyValue=true, example="10") @DefaultValue(value="-1") @QueryParam(value="size") int size) {
        return this.eventSearcher.search("location", (Object)location, size);
    }

    @GET
    @Path(value="partner/{partner}")
    public Response searchPartners(@Parameter(name="partner", description="The partner at the event", required=true, allowEmptyValue=false, example="Virgin Active") @PathParam(value="partner") String partner, @Parameter(name="size", description="Limit the events to return", required=false, allowEmptyValue=true, example="10") @DefaultValue(value="-1") @QueryParam(value="size") int size) {
        return this.eventSearcher.search("partnerName", (Object)partner, size);
    }

    private void validateMembership(int membershipId) {
        Membership membership = this.membershipProxy.getMembership("Bearer " + this.callerPrincipal.getRawToken(), membershipId);
        log.log(Level.FINEST, "Validate membership = [{0}]", membership);
    }
}

