/*
 * Decompiled with CFR 0.152.
 */
package name.pgollangi.gradle.sonarlinter.http;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import name.pgollangi.gradle.sonarlinter.http.ApacheHttpResponse;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.serverapi.HttpClient;

public class ApacheHttpClient
implements HttpClient {
    private static final Logger LOG = Loggers.get(ApacheHttpClient.class);
    public static final Timeout CONNECTION_TIMEOUT = Timeout.ofSeconds((long)30L);
    private static final Timeout RESPONSE_TIMEOUT = Timeout.ofMinutes((long)10L);
    private static final String USER_AGENT = "SonarLint VSCode";
    private final CloseableHttpClient client;
    @CheckForNull
    private final String login;
    @CheckForNull
    private final String password;

    private ApacheHttpClient(CloseableHttpClient client, @Nullable String login, @Nullable String password) {
        this.client = client;
        this.login = login;
        this.password = password;
    }

    public ApacheHttpClient withToken(String token) {
        return new ApacheHttpClient(this.client, token, null);
    }

    public HttpClient.Response get(String s) {
        return this.execute((HttpUriRequestBase)new HttpGet(s));
    }

    public HttpClient.Response post(String url, String contentType, String body) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.parse((CharSequence)contentType)));
        return this.execute((HttpUriRequestBase)httpPost);
    }

    public HttpClient.Response delete(String url, String contentType, String body) {
        HttpDelete httpDelete = new HttpDelete(url);
        httpDelete.setEntity((HttpEntity)new StringEntity(body, ContentType.parse((CharSequence)contentType)));
        return this.execute((HttpUriRequestBase)httpDelete);
    }

    private HttpClient.Response execute(HttpUriRequestBase httpRequest) {
        try {
            if (this.login != null) {
                httpRequest.setHeader("Authorization", (Object)ApacheHttpClient.basic(this.login, this.password == null ? "" : this.password));
            }
            CloseableHttpResponse httpResponse = this.client.execute((ClassicHttpRequest)httpRequest);
            return new ApacheHttpResponse(httpRequest.getRequestUri(), (ClassicHttpResponse)httpResponse);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error processing HTTP request", e);
        }
    }

    private static String basic(String username, String password) {
        String usernameAndPassword = username + ":" + password;
        String encoded = Base64.getEncoder().encodeToString(usernameAndPassword.getBytes(StandardCharsets.ISO_8859_1));
        return "Basic " + encoded;
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            LOG.error("Unable to close http client: ", (Object)e.getMessage());
        }
    }

    public static ApacheHttpClient create() {
        CloseableHttpClient httpClient = HttpClients.custom().useSystemProperties().setUserAgent(USER_AGENT).setDefaultRequestConfig(RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setConnectionRequestTimeout(CONNECTION_TIMEOUT).setResponseTimeout(RESPONSE_TIMEOUT).build()).build();
        return new ApacheHttpClient(httpClient, null, null);
    }
}

