/*
 * Decompiled with CFR 0.152.
 */
package name.pgollangi.gradle.sonarlinter;

import java.io.File;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import name.pgollangi.gradle.sonarlinter.EnginesFactory;
import name.pgollangi.gradle.sonarlinter.GradleIssueListener;
import name.pgollangi.gradle.sonarlinter.GradleLogOutput;
import name.pgollangi.gradle.sonarlinter.GradleModulesProvider;
import name.pgollangi.gradle.sonarlinter.GradleProgressMonitor;
import name.pgollangi.gradle.sonarlinter.LinterConfiguration;
import name.pgollangi.gradle.sonarlinter.SonarSourceFile;
import name.pgollangi.gradle.sonarlinter.http.ApacheHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.sonarlint.core.ConnectedSonarLintEngineImpl;
import org.sonarsource.sonarlint.core.client.api.common.Language;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.client.api.common.ProgressMonitor;
import org.sonarsource.sonarlint.core.client.api.common.Version;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedSonarLintEngine;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;
import org.sonarsource.sonarlint.core.serverapi.HttpClient;

public class SonarLinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarLinter.class);
    private LinterConfiguration config;
    private GradleLogOutput logOutput;
    private GradleProgressMonitor progressMonitor;
    private GradleIssueListener issueListener;

    public SonarLinter(LinterConfiguration config) {
        this.config = config;
    }

    public void lint() throws MalformedURLException {
        this.logOutput = new GradleLogOutput(LOGGER);
        this.progressMonitor = new GradleProgressMonitor(LOGGER, null);
        this.issueListener = new GradleIssueListener(this.logOutput);
        GradleModulesProvider modulesProvider = new GradleModulesProvider(this.config.getProjectDir());
        EnginesFactory factory = new EnginesFactory(this.config, this.logOutput, modulesProvider);
        switch (this.config.getMode()) {
            case STANDALONE: {
                this.analyzeStandalone(factory);
            }
            case CONNECTED: {
                this.analyzeConnected(factory);
                break;
            }
            default: {
                LOGGER.warn("Unsupported linter mode: " + (Object)((Object)this.config.getMode()));
            }
        }
        File projectDir = new File("C:\\dev\\ot2\\corecm\\ui");
        StandaloneGlobalConfiguration engineConfig = ((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)StandaloneGlobalConfiguration.builder().addEnabledLanguages(Language.values())).setLogOutput((LogOutput)this.logOutput)).setNodeJs(Paths.get("C:\\Program Files\\nodejs\\node.exe", new String[0]), Version.create((String)"14.17.0"))).build();
        ConnectedGlobalConfiguration connectedGlobalConfiguration = ((ConnectedGlobalConfiguration.Builder)((ConnectedGlobalConfiguration.Builder)ConnectedGlobalConfiguration.builder().addEnabledLanguages(new Language[]{Language.JS, Language.JAVA})).setConnectionId("https://sonarqube.otxlab.net").setStorageRoot(Paths.get("C:\\dev\\poc\\gradle-sonarlint\\sstorage", new String[0])).setNodeJs(Paths.get("C:\\Program Files\\nodejs\\node.exe", new String[0]), Version.create((String)"14.17.0"))).build();
        EndpointParams endpointParams = new EndpointParams("https://sonarqube.otxlab.net", false, null);
        ApacheHttpClient httpClient = ApacheHttpClient.create().withToken("a751bb74069e32f892cbc21384683f7fedd70c52");
        ConnectedSonarLintEngineImpl engine = new ConnectedSonarLintEngineImpl(connectedGlobalConfiguration);
        if (engine.getState() == ConnectedSonarLintEngine.State.NEVER_UPDATED) {
            System.out.println("ENGINE STATE " + engine.getState());
            engine.update(endpointParams, (HttpClient)httpClient, (ProgressMonitor)this.progressMonitor);
            System.out.println("ENGINE STATE " + engine.getState());
            engine.updateProject(endpointParams, (HttpClient)httpClient, "OT2_CORECM_Dev:refs_heads_Dev", false, (ProgressMonitor)this.progressMonitor);
        }
        engine.start();
        SonarSourceFile file = new SonarSourceFile(new File("C:\\dev\\ot2\\corecm\\src\\main\\java\\com\\opentext\\core\\cm\\api\\hateoas\\model\\PageModel.java"), "C:\\dev\\ot2\\corecm\\src\\main\\java\\com\\opentext\\core\\cm\\api\\hateoas\\model\\PageModel.java", false, Charset.defaultCharset(), "java");
        ConnectedAnalysisConfiguration analysisConfig = ((ConnectedAnalysisConfiguration.Builder)((ConnectedAnalysisConfiguration.Builder)ConnectedAnalysisConfiguration.builder().setProjectKey("OT2_CORECM_Dev:refs_heads_Dev").setBaseDir(projectDir.toPath())).addInputFiles(new ClientInputFile[]{file})).build();
        engine.analyze(analysisConfig, (IssueListener)this.issueListener, (LogOutput)this.logOutput, (ProgressMonitor)this.progressMonitor);
    }

    private void analyzeStandalone(EnginesFactory factory) {
        StandaloneAnalysisConfiguration analysisConfig = ((StandaloneAnalysisConfiguration.Builder)((StandaloneAnalysisConfiguration.Builder)StandaloneAnalysisConfiguration.builder().setBaseDir(this.config.getProjectDir())).setModuleKey((Object)this.config.getProjectDir().toUri())).build();
        StandaloneSonarLintEngine engine = factory.createStandaloneEngine();
        engine.analyze(analysisConfig, (IssueListener)this.issueListener, (LogOutput)this.logOutput, (ProgressMonitor)this.progressMonitor);
    }

    private void analyzeConnected(EnginesFactory factory) {
        ConnectedAnalysisConfiguration analysisConfig = ((ConnectedAnalysisConfiguration.Builder)ConnectedAnalysisConfiguration.builder().setProjectKey("OT2_CORECM_Dev:refs_heads_Dev").setBaseDir(this.config.getProjectDir())).build();
        ConnectedSonarLintEngine engine = factory.createConnectedEngine("");
        engine.analyze(analysisConfig, (IssueListener)this.issueListener, (LogOutput)this.logOutput, (ProgressMonitor)this.progressMonitor);
    }
}

