/*
 * Decompiled with CFR 0.152.
 */
package name.pgollangi.gradle.sonarlinter;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import name.pgollangi.gradle.sonarlinter.LinterConfiguration;
import org.apache.commons.lang.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.sonar.api.Plugin;
import org.sonarsource.sonarlint.core.ConnectedSonarLintEngineImpl;
import org.sonarsource.sonarlint.core.NodeJsHelper;
import org.sonarsource.sonarlint.core.StandaloneSonarLintEngineImpl;
import org.sonarsource.sonarlint.core.client.api.common.Language;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.client.api.common.ModulesProvider;
import org.sonarsource.sonarlint.core.client.api.common.Version;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedSonarLintEngine;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;

public class EnginesFactory {
    private Path nodeJsPath = null;
    private Version nodeJsVersion = null;
    private ModulesProvider modulesProvider;
    private final LogOutput logOutput;
    private LinterConfiguration configuration;

    public EnginesFactory(LinterConfiguration configuration, LogOutput logOutput, ModulesProvider modulesProvider) {
        this.configuration = configuration;
        this.logOutput = logOutput;
        this.modulesProvider = modulesProvider;
        this.init();
    }

    private void init() {
        NodeJsHelper helper = new NodeJsHelper();
        helper.detect((Path)Optional.ofNullable(this.configuration.getPathToNodeExecutable()).filter(StringUtils::isNotEmpty).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null));
        this.nodeJsPath = helper.getNodeJsPath();
        this.nodeJsVersion = helper.getNodeJsVersion();
    }

    public StandaloneSonarLintEngine createStandaloneEngine() {
        StandaloneGlobalConfiguration configuration = ((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)StandaloneGlobalConfiguration.builder().setExtraProperties(this.prepareExtraProps())).addEnabledLanguages(this.getLanguages())).setNodeJs(this.nodeJsPath, this.nodeJsVersion)).addPlugins(this.getStandaloneAnalyzers()).setModulesProvider(this.modulesProvider)).setLogOutput(this.logOutput)).build();
        StandaloneSonarLintEngineImpl engine = new StandaloneSonarLintEngineImpl(configuration);
        return engine;
    }

    private URL[] getStandaloneAnalyzers() {
        Reflections reflections = new Reflections("org.sonar.plugins", new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(Plugin.class);
        URL[] analyzers = (URL[])subTypes.stream().map(c -> {
            try {
                return c.getProtectionDomain().getCodeSource().getLocation().toURI();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
        return analyzers;
    }

    public ConnectedSonarLintEngine createConnectedEngine(String connectionId) {
        ConnectedGlobalConfiguration configuration = ((ConnectedGlobalConfiguration.Builder)((ConnectedGlobalConfiguration.Builder)((ConnectedGlobalConfiguration.Builder)((ConnectedGlobalConfiguration.Builder)((ConnectedGlobalConfiguration.Builder)ConnectedGlobalConfiguration.builder().setConnectionId(connectionId).setExtraProperties(this.prepareExtraProps())).addEnabledLanguages(this.getLanguages())).setNodeJs(this.nodeJsPath, this.nodeJsVersion)).setModulesProvider(this.modulesProvider)).setLogOutput(this.logOutput)).build();
        ConnectedSonarLintEngineImpl engine = new ConnectedSonarLintEngineImpl(configuration);
        return engine;
    }

    private Language[] getLanguages() {
        return null;
    }

    private Map<String, String> prepareExtraProps() {
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        return extraProperties;
    }
}

