/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.twilio.whatsapp.model;

import com.liferay.portal.kernel.model.Phone;
import com.liferay.twilio.whatsapp.constants.TwilioWhatsAppConstants;
import com.liferay.twilio.whatsapp.model.Notification;
import com.liferay.twilio.whatsapp.util.StringUtil;

public class NotificationCreator {
    private String defaultCountryCode;
    private String sender;
    private String recipient;
    private String message;

    public NotificationCreator() {
        this.defaultCountryCode = null;
    }

    public NotificationCreator(String defaultCountryCode) {
        this.defaultCountryCode = this.normaliseCountryCode(defaultCountryCode);
    }

    public NotificationCreator withDefaultCountryCode(String defaultCountryCode) {
        this.defaultCountryCode = this.normaliseCountryCode(defaultCountryCode);
        return this;
    }

    private String normaliseCountryCode(String countryCode) {
        if (StringUtil.isBlank(countryCode)) {
            return null;
        }
        if (!TwilioWhatsAppConstants.PHONE_NUMBER_REGEX_PATTERN.matcher(countryCode).matches()) {
            throw new IllegalArgumentException("The country code must be a valid number with or without a plus prefix");
        }
        return countryCode.startsWith("+") ? countryCode : "+" + countryCode;
    }

    public NotificationCreator withSender(String phoneNumber) {
        this.sender = this.normalisePhoneNumber("sender", phoneNumber);
        return this;
    }

    public NotificationCreator withSender(Phone phoneNumber) {
        this.sender = this.normalisePhoneNumber("sender", phoneNumber.getNumber());
        return this;
    }

    public NotificationCreator withRecipient(String phoneNumber) {
        this.recipient = this.normalisePhoneNumber("recipient", phoneNumber);
        return this;
    }

    public NotificationCreator withRecipient(Phone phoneNumber) {
        this.recipient = this.normalisePhoneNumber("recipient", phoneNumber.getNumber());
        return this;
    }

    public NotificationCreator withMessage(String message) {
        this.message = message;
        return this;
    }

    private String normalisePhoneNumber(String type, String phoneNumber) {
        if (StringUtil.isBlank(phoneNumber)) {
            throw new IllegalArgumentException(String.format("The %s's phone number must have a value. It can be a local or international format", type));
        }
        if (!TwilioWhatsAppConstants.PHONE_NUMBER_REGEX_PATTERN.matcher(phoneNumber).matches()) {
            throw new IllegalArgumentException(String.format("The %s's phone number must be a valid a local or international format number", type));
        }
        if (phoneNumber.startsWith("0") && this.defaultCountryCode == null) {
            throw new IllegalArgumentException(String.format("The %s's phone number is in local format but the default country code has not been set", type));
        }
        String internationalNumber = phoneNumber.startsWith("0") ? phoneNumber.replaceFirst("0", this.defaultCountryCode) : phoneNumber;
        return internationalNumber.startsWith("+") ? internationalNumber : "+" + internationalNumber;
    }

    public Notification create() {
        return new Notification(this.sender, this.recipient, this.message);
    }
}

