/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FastInteger
implements Comparable<FastInteger> {
    private int smallValue;
    private MutableNumber mnum;
    private EInteger largeValue;
    private int integerMode;
    private static final EInteger ValueInt32MinValue = EInteger.FromInt64(Integer.MIN_VALUE);
    private static final EInteger ValueInt32MaxValue = EInteger.FromInt64(Integer.MAX_VALUE);
    private static final EInteger ValueNegativeInt32MinValue = ValueInt32MinValue.Negate();
    private static final String HexAlphabet = "0123456789ABCDEF";

    FastInteger(int value) {
        this.smallValue = value;
    }

    static FastInteger Copy(FastInteger value) {
        FastInteger fi = new FastInteger(value.smallValue);
        fi.integerMode = value.integerMode;
        fi.largeValue = value.largeValue;
        fi.mnum = value.mnum == null || value.integerMode != 1 ? null : value.mnum.Copy();
        return fi;
    }

    static FastInteger FromBig(EInteger bigintVal) {
        if (bigintVal.CanFitInInt32()) {
            return new FastInteger(bigintVal.AsInt32Unchecked());
        }
        if (bigintVal.signum() > 0) {
            FastInteger fi = new FastInteger(0);
            fi.integerMode = 1;
            fi.mnum = MutableNumber.FromEInteger(bigintVal);
            return fi;
        }
        FastInteger fi = new FastInteger(0);
        fi.integerMode = 2;
        fi.largeValue = bigintVal;
        return fi;
    }

    int AsInt32() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue;
            }
            case 1: {
                return this.mnum.ToInt32();
            }
            case 2: {
                return this.largeValue.AsInt32Checked();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int compareTo(FastInteger val) {
        switch (this.integerMode << 2 | val.integerMode) {
            case 0: {
                int vsv = val.smallValue;
                return this.smallValue == vsv ? 0 : (this.smallValue < vsv ? -1 : 1);
            }
            case 1: {
                return -val.mnum.CompareToInt(this.smallValue);
            }
            case 2: {
                return this.AsBigInteger().compareTo(val.largeValue);
            }
            case 4: {
                return this.mnum.CompareToInt(val.smallValue);
            }
            case 5: {
                return this.mnum.compareTo(val.mnum);
            }
            case 6: {
                return this.AsBigInteger().compareTo(val.largeValue);
            }
            case 8: 
            case 9: 
            case 10: {
                return this.largeValue.compareTo(val.AsBigInteger());
            }
        }
        throw new IllegalStateException();
    }

    FastInteger Abs() {
        switch (this.integerMode) {
            case 0: {
                if (this.smallValue == Integer.MIN_VALUE) {
                    return this.Negate();
                }
                this.smallValue = Math.abs(this.smallValue);
                return this;
            }
        }
        return this.signum() < 0 ? this.Negate() : this;
    }

    static EInteger WordsToEInteger(int[] words) {
        int wordCount = words.length;
        if (wordCount == 1 && words[0] >> 31 == 0) {
            return EInteger.FromInt64(words[0]);
        }
        byte[] bytes = new byte[wordCount * 4 + 1];
        for (int i = 0; i < wordCount; ++i) {
            bytes[i * 4 + 0] = (byte)(words[i] & 0xFF);
            bytes[i * 4 + 1] = (byte)(words[i] >> 8 & 0xFF);
            bytes[i * 4 + 2] = (byte)(words[i] >> 16 & 0xFF);
            bytes[i * 4 + 3] = (byte)(words[i] >> 24 & 0xFF);
        }
        bytes[bytes.length - 1] = 0;
        return EInteger.FromBytes(bytes, true);
    }

    static int[] GetLastWords(EInteger bigint, int numWords32Bit) {
        return MutableNumber.FromEInteger(bigint).GetLastWordsInternal(numWords32Bit);
    }

    FastInteger SetInt(int val) {
        this.smallValue = val;
        this.integerMode = 0;
        return this;
    }

    int RepeatedSubtract(FastInteger divisor) {
        if (this.integerMode == 1) {
            int count = 0;
            if (divisor.integerMode == 1) {
                while (this.mnum.compareTo(divisor.mnum) >= 0) {
                    this.mnum.Subtract(divisor.mnum);
                    ++count;
                }
                return count;
            }
            if (divisor.integerMode == 0 && divisor.smallValue >= 0) {
                if (this.mnum.CanFitInInt32()) {
                    int small = this.mnum.ToInt32();
                    count = small / divisor.smallValue;
                    this.mnum.SetInt(small % divisor.smallValue);
                } else {
                    MutableNumber dmnum = new MutableNumber(divisor.smallValue);
                    while (this.mnum.compareTo(dmnum) >= 0) {
                        this.mnum.Subtract(dmnum);
                        ++count;
                    }
                }
                return count;
            }
            EInteger[] divrem = this.AsBigInteger().DivRem(divisor.AsBigInteger());
            EInteger bigquo = divrem[0];
            EInteger bigrem = divrem[1];
            int smallquo = bigquo.AsInt32Checked();
            this.integerMode = 2;
            this.largeValue = bigrem;
            return smallquo;
        }
        EInteger[] divrem = this.AsBigInteger().DivRem(divisor.AsBigInteger());
        EInteger bigquo = divrem[0];
        EInteger bigrem = divrem[1];
        int smallquo = bigquo.AsInt32Checked();
        this.integerMode = 2;
        this.largeValue = bigrem;
        return smallquo;
    }

    FastInteger Multiply(int val) {
        if (val == 0) {
            this.smallValue = 0;
            this.integerMode = 0;
        } else {
            switch (this.integerMode) {
                case 0: {
                    boolean bpos;
                    boolean apos = (long)this.smallValue > 0L;
                    boolean bl = bpos = (long)val > 0L;
                    if (apos && (!bpos && Integer.MIN_VALUE / this.smallValue > val || bpos && this.smallValue > Integer.MAX_VALUE / val) || !apos && (!bpos && (long)this.smallValue != 0L && Integer.MAX_VALUE / this.smallValue > val || bpos && this.smallValue < Integer.MIN_VALUE / val)) {
                        if (apos && bpos) {
                            this.integerMode = 1;
                            this.mnum = new MutableNumber(this.smallValue);
                            this.mnum.Multiply(val);
                            break;
                        }
                        this.integerMode = 2;
                        this.largeValue = EInteger.FromInt64(this.smallValue);
                        this.largeValue = this.largeValue.Multiply(EInteger.FromInt64(val));
                        break;
                    }
                    this.smallValue *= val;
                    break;
                }
                case 1: {
                    if (val < 0) {
                        this.integerMode = 2;
                        this.largeValue = this.mnum.ToEInteger();
                        this.largeValue = this.largeValue.Multiply(EInteger.FromInt64(val));
                        break;
                    }
                    this.mnum.Multiply(val);
                    break;
                }
                case 2: {
                    this.largeValue = this.largeValue.Multiply(EInteger.FromInt64(val));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this;
    }

    FastInteger Negate() {
        switch (this.integerMode) {
            case 0: {
                if (this.smallValue == Integer.MIN_VALUE) {
                    this.integerMode = 1;
                    this.mnum = MutableNumber.FromEInteger(ValueNegativeInt32MinValue);
                    break;
                }
                this.smallValue = -this.smallValue;
                break;
            }
            case 1: {
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                this.largeValue = this.largeValue.Negate();
                break;
            }
            case 2: {
                this.largeValue = this.largeValue.Negate();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger Subtract(FastInteger val) {
        switch (this.integerMode) {
            case 0: {
                if (val.integerMode == 0) {
                    int vsv = val.smallValue;
                    if (vsv < 0 && Integer.MAX_VALUE + vsv < this.smallValue || vsv > 0 && Integer.MIN_VALUE + vsv > this.smallValue) {
                        this.integerMode = 2;
                        this.largeValue = EInteger.FromInt64(this.smallValue);
                        this.largeValue = this.largeValue.Subtract(EInteger.FromInt64(vsv));
                        break;
                    }
                    this.smallValue -= vsv;
                    break;
                }
                this.integerMode = 2;
                this.largeValue = EInteger.FromInt64(this.smallValue);
                EInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.Subtract(valValue);
                break;
            }
            case 1: {
                if (val.integerMode == 1) {
                    this.mnum.Subtract(val.mnum);
                    break;
                }
                if (val.integerMode == 0 && val.smallValue >= 0) {
                    this.mnum.SubtractInt(val.smallValue);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                EInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.Subtract(valValue);
                break;
            }
            case 2: {
                EInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.Subtract(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger SubtractInt(int val) {
        if (val == Integer.MIN_VALUE) {
            return this.AddBig(ValueNegativeInt32MinValue);
        }
        if (this.integerMode == 0) {
            if (val < 0 && Integer.MAX_VALUE + val < this.smallValue || val > 0 && Integer.MIN_VALUE + val > this.smallValue) {
                this.integerMode = 2;
                this.largeValue = EInteger.FromInt64(this.smallValue);
                this.largeValue = this.largeValue.Subtract(EInteger.FromInt64(val));
            } else {
                this.smallValue -= val;
            }
            return this;
        }
        return this.AddInt(-val);
    }

    FastInteger AddBig(EInteger bigintVal) {
        switch (this.integerMode) {
            case 0: {
                return bigintVal.CanFitInInt32() ? this.AddInt(bigintVal.AsInt32Checked()) : this.Add(FastInteger.FromBig(bigintVal));
            }
            case 1: {
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                this.largeValue = this.largeValue.Add(bigintVal);
                break;
            }
            case 2: {
                this.largeValue = this.largeValue.Add(bigintVal);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger SubtractBig(EInteger bigintVal) {
        if (this.integerMode == 2) {
            this.largeValue = this.largeValue.Subtract(bigintVal);
            return this;
        }
        int sign = bigintVal.signum();
        if (sign == 0) {
            return this;
        }
        if (sign < 0 && bigintVal.compareTo(ValueInt32MinValue) > 0) {
            return this.AddInt(-bigintVal.AsInt32Checked());
        }
        if (sign > 0 && bigintVal.compareTo(ValueInt32MaxValue) <= 0) {
            return this.SubtractInt(bigintVal.AsInt32Checked());
        }
        bigintVal = bigintVal.Negate();
        return this.AddBig(bigintVal);
    }

    FastInteger Add(FastInteger val) {
        switch (this.integerMode) {
            case 0: {
                if (val.integerMode == 0) {
                    if (this.smallValue < 0 && val.smallValue < Integer.MIN_VALUE - this.smallValue || this.smallValue > 0 && val.smallValue > Integer.MAX_VALUE - this.smallValue) {
                        if (val.smallValue >= 0) {
                            this.integerMode = 1;
                            this.mnum = new MutableNumber(this.smallValue);
                            this.mnum.Add(val.smallValue);
                            break;
                        }
                        this.integerMode = 2;
                        this.largeValue = EInteger.FromInt64(this.smallValue);
                        this.largeValue = this.largeValue.Add(EInteger.FromInt64(val.smallValue));
                        break;
                    }
                    this.smallValue += val.smallValue;
                    break;
                }
                this.integerMode = 2;
                this.largeValue = EInteger.FromInt64(this.smallValue);
                EInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            case 1: {
                if (val.integerMode == 0 && val.smallValue >= 0) {
                    this.mnum.Add(val.smallValue);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                EInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            case 2: {
                EInteger valValue = val.AsBigInteger();
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger Remainder(int divisor) {
        block6: {
            block5: {
                if (divisor == 0) break block5;
                switch (this.integerMode) {
                    case 0: {
                        this.smallValue %= divisor;
                        break block6;
                    }
                    case 1: {
                        this.largeValue = this.mnum.ToEInteger();
                        this.largeValue = this.largeValue.Remainder(EInteger.FromInt64(divisor));
                        this.smallValue = this.largeValue.AsInt32Checked();
                        this.integerMode = 0;
                        break block6;
                    }
                    case 2: {
                        this.largeValue = this.largeValue.Remainder(EInteger.FromInt64(divisor));
                        this.smallValue = this.largeValue.AsInt32Checked();
                        this.integerMode = 0;
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            throw new ArithmeticException();
        }
        return this;
    }

    FastInteger Increment() {
        if (this.integerMode == 0) {
            if (this.smallValue != Integer.MAX_VALUE) {
                ++this.smallValue;
            } else {
                this.integerMode = 1;
                this.mnum = MutableNumber.FromEInteger(ValueNegativeInt32MinValue);
            }
            return this;
        }
        return this.AddInt(1);
    }

    FastInteger Decrement() {
        if (this.integerMode == 0) {
            if (this.smallValue != Integer.MIN_VALUE) {
                --this.smallValue;
            } else {
                this.integerMode = 1;
                this.mnum = MutableNumber.FromEInteger(ValueInt32MinValue);
                this.mnum.SubtractInt(1);
            }
            return this;
        }
        return this.SubtractInt(1);
    }

    FastInteger Divide(int divisor) {
        block10: {
            block9: {
                if (divisor == 0) break block9;
                switch (this.integerMode) {
                    case 0: {
                        if (divisor == -1 && this.smallValue == Integer.MIN_VALUE) {
                            this.integerMode = 1;
                            this.mnum = MutableNumber.FromEInteger(ValueNegativeInt32MinValue);
                        } else {
                            this.smallValue /= divisor;
                        }
                        break block10;
                    }
                    case 1: {
                        this.integerMode = 2;
                        this.largeValue = this.mnum.ToEInteger();
                        this.largeValue = this.largeValue.Divide(EInteger.FromInt64(divisor));
                        if (this.largeValue.isZero()) {
                            this.integerMode = 0;
                            this.smallValue = 0;
                        }
                        break block10;
                    }
                    case 2: {
                        this.largeValue = this.largeValue.Divide(EInteger.FromInt64(divisor));
                        if (this.largeValue.isZero()) {
                            this.integerMode = 0;
                            this.smallValue = 0;
                        }
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            throw new ArithmeticException();
        }
        return this;
    }

    final boolean isEvenNumber() {
        switch (this.integerMode) {
            case 0: {
                return (this.smallValue & 1) == 0;
            }
            case 1: {
                return this.mnum.isEvenNumber();
            }
            case 2: {
                return this.largeValue.isEven();
            }
        }
        throw new IllegalStateException();
    }

    FastInteger AddInt(int val) {
        switch (this.integerMode) {
            case 0: {
                if (this.smallValue < 0 && val < Integer.MIN_VALUE - this.smallValue || this.smallValue > 0 && val > Integer.MAX_VALUE - this.smallValue) {
                    if (val >= 0) {
                        this.integerMode = 1;
                        this.mnum = new MutableNumber(this.smallValue);
                        this.mnum.Add(val);
                        break;
                    }
                    this.integerMode = 2;
                    this.largeValue = EInteger.FromInt64(this.smallValue);
                    this.largeValue = this.largeValue.Add(EInteger.FromInt64(val));
                    break;
                }
                this.smallValue += val;
                break;
            }
            case 1: {
                if (val >= 0) {
                    this.mnum.Add(val);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                EInteger valValue = EInteger.FromInt64(val);
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            case 2: {
                EInteger valValue = EInteger.FromInt64(val);
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    boolean CanFitInInt32() {
        switch (this.integerMode) {
            case 0: {
                return true;
            }
            case 1: {
                return this.mnum.CanFitInInt32();
            }
            case 2: {
                return this.largeValue.CanFitInInt32();
            }
        }
        throw new IllegalStateException();
    }

    private static void ReverseChars(char[] chars, int offset, int length) {
        int half = length >> 1;
        int right = offset + length - 1;
        int i = 0;
        while (i < half) {
            char value = chars[offset + i];
            chars[offset + i] = chars[right];
            chars[right] = value;
            ++i;
            --right;
        }
    }

    private static String IntToString(int value) {
        if (value == Integer.MIN_VALUE) {
            return "-2147483648";
        }
        if (value == 0) {
            return "0";
        }
        boolean neg = value < 0;
        char[] chars = new char[24];
        int count = 0;
        if (neg) {
            chars[0] = 45;
            ++count;
            value = -value;
        }
        while (value != 0) {
            char digit = HexAlphabet.charAt(value % 10);
            chars[count++] = digit;
            value /= 10;
        }
        if (neg) {
            FastInteger.ReverseChars(chars, 1, count - 1);
        } else {
            FastInteger.ReverseChars(chars, 0, count);
        }
        return new String(chars, 0, count);
    }

    public String toString() {
        switch (this.integerMode) {
            case 0: {
                return FastInteger.IntToString(this.smallValue);
            }
            case 1: {
                return this.mnum.ToEInteger().toString();
            }
            case 2: {
                return this.largeValue.toString();
            }
        }
        return "";
    }

    final int signum() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue == 0 ? 0 : (this.smallValue < 0 ? -1 : 1);
            }
            case 1: {
                return this.mnum.signum();
            }
            case 2: {
                return this.largeValue.signum();
            }
        }
        return 0;
    }

    final boolean isValueZero() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue == 0;
            }
            case 1: {
                return this.mnum.signum() == 0;
            }
            case 2: {
                return this.largeValue.isZero();
            }
        }
        return false;
    }

    int CompareToInt(int val) {
        switch (this.integerMode) {
            case 0: {
                return val == this.smallValue ? 0 : (this.smallValue < val ? -1 : 1);
            }
            case 1: {
                return this.mnum.ToEInteger().compareTo(EInteger.FromInt64(val));
            }
            case 2: {
                return this.largeValue.compareTo(EInteger.FromInt64(val));
            }
        }
        return 0;
    }

    EInteger AsBigInteger() {
        switch (this.integerMode) {
            case 0: {
                return EInteger.FromInt64(this.smallValue);
            }
            case 1: {
                return this.mnum.ToEInteger();
            }
            case 2: {
                return this.largeValue;
            }
        }
        throw new IllegalStateException();
    }

    private static final class MutableNumber {
        private int[] data;
        private int wordCount;

        static MutableNumber FromEInteger(EInteger bigintVal) {
            MutableNumber mnum = new MutableNumber(0);
            if (bigintVal.signum() < 0) {
                throw new IllegalArgumentException("bigintVal's sign (" + bigintVal.signum() + ") is less than " + "0 ");
            }
            byte[] bytes = bigintVal.ToBytes(true);
            int len = bytes.length;
            int newWordCount = Math.max(4, len / 4 + 1);
            if (newWordCount > mnum.data.length) {
                mnum.data = new int[newWordCount];
            }
            mnum.wordCount = newWordCount;
            for (int i = 0; i < len; i += 4) {
                int x = bytes[i] & 0xFF;
                if (i + 1 < len) {
                    x |= (bytes[i + 1] & 0xFF) << 8;
                }
                if (i + 2 < len) {
                    x |= (bytes[i + 2] & 0xFF) << 16;
                }
                if (i + 3 < len) {
                    x |= (bytes[i + 3] & 0xFF) << 24;
                }
                mnum.data[i >> 2] = x;
            }
            while (mnum.wordCount != 0 && mnum.data[mnum.wordCount - 1] == 0) {
                --mnum.wordCount;
            }
            return mnum;
        }

        MutableNumber(int val) {
            if (val < 0) {
                throw new IllegalArgumentException("val (" + val + ") is less than " + "0 ");
            }
            this.data = new int[4];
            this.wordCount = val == 0 ? 0 : 1;
            this.data[0] = val;
        }

        MutableNumber SetInt(int val) {
            if (val < 0) {
                throw new IllegalArgumentException("val (" + val + ") is less than " + "0 ");
            }
            this.wordCount = val == 0 ? 0 : 1;
            this.data[0] = val;
            return this;
        }

        EInteger ToEInteger() {
            if (this.wordCount == 1 && this.data[0] >> 31 == 0) {
                return EInteger.FromInt64(this.data[0]);
            }
            byte[] bytes = new byte[this.wordCount * 4 + 1];
            for (int i = 0; i < this.wordCount; ++i) {
                bytes[i * 4] = (byte)(this.data[i] & 0xFF);
                bytes[i * 4 + 1] = (byte)(this.data[i] >> 8 & 0xFF);
                bytes[i * 4 + 2] = (byte)(this.data[i] >> 16 & 0xFF);
                bytes[i * 4 + 3] = (byte)(this.data[i] >> 24 & 0xFF);
            }
            bytes[bytes.length - 1] = 0;
            return EInteger.FromBytes(bytes, true);
        }

        int[] GetLastWordsInternal(int numWords32Bit) {
            int[] ret = new int[numWords32Bit];
            System.arraycopy(this.data, 0, ret, 0, Math.min(numWords32Bit, this.wordCount));
            return ret;
        }

        boolean CanFitInInt32() {
            return this.wordCount == 0 || this.wordCount == 1 && this.data[0] >> 31 == 0;
        }

        int ToInt32() {
            return this.wordCount == 0 ? 0 : this.data[0];
        }

        MutableNumber Copy() {
            MutableNumber mbi = new MutableNumber(0);
            if (this.wordCount > mbi.data.length) {
                mbi.data = new int[this.wordCount];
            }
            System.arraycopy(this.data, 0, mbi.data, 0, this.wordCount);
            mbi.wordCount = this.wordCount;
            return mbi;
        }

        MutableNumber Multiply(int multiplicand) {
            if (multiplicand < 0) {
                throw new IllegalArgumentException("multiplicand (" + multiplicand + ") is less than " + "0 ");
            }
            if (multiplicand != 0) {
                int result3;
                int result2;
                int result0;
                int result1;
                int y0;
                int x1;
                int x0;
                int i;
                int carry = 0;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                if (multiplicand < 65536) {
                    for (i = 0; i < this.wordCount; ++i) {
                        x1 = x0 = this.data[i];
                        y0 = multiplicand;
                        x1 = x1 >> 16 & 0xFFFF;
                        int temp = (x0 &= 0xFFFF) * y0;
                        result1 = temp >> 16 & 0xFFFF;
                        result0 = temp & 0xFFFF;
                        result2 = 0;
                        temp = x1 * y0;
                        result2 += temp >> 16 & 0xFFFF;
                        result3 = (result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF) >> 16 & 0xFFFF;
                        x0 = result0 | (result1 &= 0xFFFF) << 16;
                        x1 = (result2 &= 0xFFFF) | result3 << 16;
                        int x2 = x0 + carry;
                        if (x2 >> 31 == x0 >> 31 ? (x2 & Integer.MAX_VALUE) < (x0 & Integer.MAX_VALUE) : x2 >> 31 == 0) {
                            // empty if block
                        }
                        this.data[i] = x2;
                        carry = ++x1;
                    }
                } else {
                    for (i = 0; i < this.wordCount; ++i) {
                        x1 = x0 = this.data[i];
                        int y1 = y0 = multiplicand;
                        x1 = x1 >> 16 & 0xFFFF;
                        y1 = y1 >> 16 & 0xFFFF;
                        int temp = (x0 &= 0xFFFF) * (y0 &= 0xFFFF);
                        result1 = temp >> 16 & 0xFFFF;
                        result0 = temp & 0xFFFF;
                        temp = x0 * y1;
                        result2 = temp >> 16 & 0xFFFF;
                        result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF;
                        result1 &= 0xFFFF;
                        temp = x1 * y0;
                        result2 += temp >> 16 & 0xFFFF;
                        result3 = (result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF) >> 16 & 0xFFFF;
                        result2 &= 0xFFFF;
                        temp = x1 * y1;
                        result3 += temp >> 16 & 0xFFFF;
                        x0 = result0 | (result1 &= 0xFFFF) << 16;
                        x1 = (result2 &= 0xFFFF) | (result3 += (result2 += temp & 0xFFFF) >> 16 & 0xFFFF) << 16;
                        int x2 = x0 + carry;
                        if (x2 >> 31 == x0 >> 31 ? (x2 & Integer.MAX_VALUE) < (x0 & Integer.MAX_VALUE) : x2 >> 31 == 0) {
                            // empty if block
                        }
                        this.data[i] = x2;
                        carry = ++x1;
                    }
                }
                if (carry != 0) {
                    if (this.wordCount >= this.data.length) {
                        int[] newdata = new int[this.wordCount + 20];
                        System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                        this.data = newdata;
                    }
                    this.data[this.wordCount] = carry;
                    ++this.wordCount;
                }
                while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                    --this.wordCount;
                }
            } else {
                if (this.data.length > 0) {
                    this.data[0] = 0;
                }
                this.wordCount = 0;
            }
            return this;
        }

        final int signum() {
            return this.wordCount == 0 ? 0 : 1;
        }

        final boolean isEvenNumber() {
            return this.wordCount == 0 || (this.data[0] & 1) == 0;
        }

        int CompareToInt(int val) {
            if (val < 0 || this.wordCount > 1) {
                return 1;
            }
            if (this.wordCount == 0) {
                return val == 0 ? 0 : -1;
            }
            if (this.data[0] == val) {
                return 0;
            }
            return (this.data[0] >> 31 == val >> 31 ? (this.data[0] & Integer.MAX_VALUE) < (val & Integer.MAX_VALUE) : this.data[0] >> 31 == 0) ? -1 : 1;
        }

        /*
         * Unable to fully structure code
         */
        MutableNumber SubtractInt(int other) {
            block8: {
                if (other < 0) {
                    throw new IllegalArgumentException("other (" + other + ") is less than " + "0 ");
                }
                if (other == 0) break block8;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                if ((a = this.data[0]) >> 31 != (u = a - other) >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                if (a == u && other != 0) lbl-1000:
                // 2 sources

                {
                    v0 = 1;
                } else {
                    v0 = 0;
                }
                borrow = v0;
                this.data[0] = u;
                if (borrow != 0) {
                    for (i = 1; i < this.wordCount; ++i) {
                        u = this.data[i] - borrow;
                        borrow = (this.data[i] >> 31 == u >> 31 ? (this.data[i] & 0x7FFFFFFF) < (u & 0x7FFFFFFF) : this.data[i] >> 31 == 0) ? 1 : 0;
                        this.data[i] = u;
                    }
                }
                while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                    --this.wordCount;
                }
            }
            return this;
        }

        /*
         * Unable to fully structure code
         */
        MutableNumber Subtract(MutableNumber other) {
            block8: {
                v0 = neededSize = this.wordCount > other.wordCount ? this.wordCount : other.wordCount;
                if (this.data.length < neededSize) {
                    newdata = new int[neededSize + 20];
                    System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                    this.data = newdata;
                }
                neededSize = this.wordCount < other.wordCount ? this.wordCount : other.wordCount;
                u = 0;
                borrow = 0;
                for (i = 0; i < neededSize; ++i) {
                    a = this.data[i];
                    u = a - other.data[i] - borrow;
                    if (a >> 31 != u >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (a == u && other.data[i] != 0) lbl-1000:
                    // 2 sources

                    {
                        v1 = 1;
                    } else {
                        v1 = 0;
                    }
                    borrow = v1;
                    this.data[i] = u;
                }
                if (borrow == 0) break block8;
                for (i = neededSize; i < this.wordCount; ++i) {
                    a = this.data[i];
                    u = a - other.data[i] - borrow;
                    if (a >> 31 != u >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (a == u && other.data[i] != 0) lbl-1000:
                    // 2 sources

                    {
                        v2 = 1;
                    } else {
                        v2 = 0;
                    }
                    borrow = v2;
                    this.data[i] = u;
                }
            }
            while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                --this.wordCount;
            }
            return this;
        }

        public int compareTo(MutableNumber other) {
            if (this.wordCount != other.wordCount) {
                return this.wordCount < other.wordCount ? -1 : 1;
            }
            int valueN = this.wordCount;
            while (valueN-- != 0) {
                int an = this.data[valueN];
                int bn = other.data[valueN];
                if (an >> 31 == bn >> 31 ? (an & Integer.MAX_VALUE) < (bn & Integer.MAX_VALUE) : an >> 31 == 0) {
                    return -1;
                }
                if (an == bn) continue;
                return 1;
            }
            return 0;
        }

        /*
         * Unable to fully structure code
         */
        MutableNumber Add(int augend) {
            block10: {
                if (augend < 0) {
                    throw new IllegalArgumentException("augend (" + augend + ") is less than " + "0 ");
                }
                if (augend == 0) break block10;
                carry = 0;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                for (i = 0; i < this.wordCount; ++i) {
                    a = this.data[i];
                    u = a + augend + carry;
                    if (u >> 31 != a >> 31 ? u >> 31 == 0 : (u & 0x7FFFFFFF) < (a & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (u == a && augend != 0) lbl-1000:
                    // 2 sources

                    {
                        v0 = 1;
                    } else {
                        v0 = 0;
                    }
                    carry = v0;
                    this.data[i] = u;
                    if (carry == 0) {
                        return this;
                    }
                    augend = 0;
                }
                if (carry != 0) {
                    if (this.wordCount >= this.data.length) {
                        newdata = new int[this.wordCount + 20];
                        System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                        this.data = newdata;
                    }
                    this.data[this.wordCount] = carry;
                    ++this.wordCount;
                }
            }
            while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                --this.wordCount;
            }
            return this;
        }
    }
}

