/*
 * Decompiled with CFR 0.152.
 */
package com.github.windpapi4j;

import com.github.windpapi4j.HResultException;
import com.github.windpapi4j.InitializationFailedException;
import com.github.windpapi4j.WinAPICallFailedException;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class WinDPAPI {
    private final Crypt32 cryptoApi = Crypt32.INSTANCE;
    private final Kernel32 kernelApi = Kernel32.INSTANCE;
    private static final short FACILITY_WIN32 = 7;
    private static final boolean IS_WINDOWS_OPERATING_SYSTEM;
    private final int flags;

    private WinDPAPI(int flagValue) {
        this.flags = flagValue;
    }

    public static WinDPAPI newInstance(CryptProtectFlag ... cryptProtectFlags) throws InitializationFailedException {
        try {
            if (!WinDPAPI.isPlatformSupported()) {
                throw new IllegalStateException("This library only works on Windows operating systems.");
            }
            int flagValue = 0;
            for (CryptProtectFlag cryptProtectFlag : cryptProtectFlags) {
                flagValue |= cryptProtectFlag.value;
            }
            return new WinDPAPI(flagValue);
        }
        catch (Throwable t) {
            throw new InitializationFailedException("Initialization failed", t);
        }
    }

    public static boolean isPlatformSupported() {
        return IS_WINDOWS_OPERATING_SYSTEM;
    }

    public byte[] protectData(byte[] data) throws WinAPICallFailedException {
        return this.protectData(data, null);
    }

    public byte[] protectData(byte[] data, byte[] entropy) throws WinAPICallFailedException {
        return this.protectData(data, entropy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] protectData(byte[] data, byte[] entropy, String description) throws WinAPICallFailedException {
        byte[] byArray;
        block7: {
            this.checkNotNull(data, "Argument data cannot be null");
            Crypt32.DATA_BLOB pDataIn = new Crypt32.DATA_BLOB(data);
            Crypt32.DATA_BLOB pDataProtected = new Crypt32.DATA_BLOB();
            Crypt32.DATA_BLOB pEntropy = entropy == null ? null : new Crypt32.DATA_BLOB(entropy);
            try {
                boolean apiCallSuccessful = this.cryptoApi.CryptProtectData(pDataIn, description, pEntropy, null, null, this.flags, pDataProtected);
                if (!apiCallSuccessful) {
                    this.raiseHResultExceptionForLastError("CryptProtectData");
                }
                byArray = pDataProtected.getData();
                if (pDataProtected.pbData == null) break block7;
                this.kernelApi.LocalFree(pDataProtected.pbData);
            }
            catch (Throwable throwable) {
                try {
                    if (pDataProtected.pbData != null) {
                        this.kernelApi.LocalFree(pDataProtected.pbData);
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new WinAPICallFailedException("Invocation of CryptProtectData failed", t);
                }
            }
        }
        return byArray;
    }

    public byte[] unprotectData(byte[] data) throws WinAPICallFailedException {
        return this.unprotectData(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] unprotectData(byte[] data, byte[] entropy) throws WinAPICallFailedException {
        byte[] byArray;
        PointerByReference pDescription;
        block9: {
            this.checkNotNull(data, "Argument data cannot be null");
            Crypt32.DATA_BLOB pDataIn = new Crypt32.DATA_BLOB(data);
            Crypt32.DATA_BLOB pDataUnprotected = new Crypt32.DATA_BLOB();
            Crypt32.DATA_BLOB pEntropy = entropy == null ? null : new Crypt32.DATA_BLOB(entropy);
            pDescription = new PointerByReference();
            try {
                boolean apiCallSuccessful = this.cryptoApi.CryptUnprotectData(pDataIn, pDescription, pEntropy, null, null, this.flags, pDataUnprotected);
                if (!apiCallSuccessful) {
                    this.raiseHResultExceptionForLastError("CryptUnprotectData");
                }
                byArray = pDataUnprotected.getData();
                if (pDataUnprotected.pbData == null) break block9;
                this.kernelApi.LocalFree(pDataUnprotected.pbData);
            }
            catch (Throwable throwable) {
                try {
                    if (pDataUnprotected.pbData != null) {
                        this.kernelApi.LocalFree(pDataUnprotected.pbData);
                    }
                    if (pDescription.getValue() != null) {
                        this.kernelApi.LocalFree(pDescription.getValue());
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new WinAPICallFailedException("Invocation of CryptUnprotectData failed", t);
                }
            }
        }
        if (pDescription.getValue() != null) {
            this.kernelApi.LocalFree(pDescription.getValue());
        }
        return byArray;
    }

    private void checkNotNull(Object object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
    }

    private void raiseHResultExceptionForLastError(String methodName) {
        int winApiErrorCode = this.kernelApi.GetLastError();
        int hResult = winApiErrorCode <= 0 ? winApiErrorCode : winApiErrorCode & 0xFFFF | 0x70000 | Integer.MIN_VALUE;
        throw new HResultException(String.format("%s call signalled an error.", methodName), hResult);
    }

    private static <T> T loadNativeLibraryJNAFacade(String name, Class<T> clazz) {
        return (T)Native.loadLibrary((String)name, clazz, (Map)W32APIOptions.UNICODE_OPTIONS);
    }

    static /* synthetic */ Object access$100(String x0, Class x1) {
        return WinDPAPI.loadNativeLibraryJNAFacade(x0, x1);
    }

    static {
        String operatingSystemName = System.getProperty("os.name");
        IS_WINDOWS_OPERATING_SYSTEM = operatingSystemName != null && operatingSystemName.startsWith("Windows");
    }

    static interface Crypt32
    extends StdCallLibrary {
        public static final Crypt32 INSTANCE = (Crypt32)WinDPAPI.access$100("Crypt32", Crypt32.class);

        public boolean CryptProtectData(DATA_BLOB var1, String var2, DATA_BLOB var3, Pointer var4, Pointer var5, int var6, DATA_BLOB var7);

        public boolean CryptUnprotectData(DATA_BLOB var1, PointerByReference var2, DATA_BLOB var3, Pointer var4, Pointer var5, int var6, DATA_BLOB var7);

        public static class DATA_BLOB
        extends Structure {
            public int cbData;
            public Pointer pbData;

            DATA_BLOB() {
            }

            DATA_BLOB(byte[] data) {
                this.pbData = new Memory((long)data.length);
                this.pbData.write(0L, data, 0, data.length);
                this.cbData = data.length;
                this.allocateMemory();
            }

            protected List<String> getFieldOrder() {
                return Arrays.asList("cbData", "pbData");
            }

            public byte[] getData() {
                return this.pbData == null ? null : this.pbData.getByteArray(0L, this.cbData);
            }
        }
    }

    static interface Kernel32
    extends StdCallLibrary {
        public static final Kernel32 INSTANCE = (Kernel32)WinDPAPI.access$100("Kernel32", Kernel32.class);

        public Pointer LocalFree(Pointer var1);

        public int GetLastError();
    }

    public static enum CryptProtectFlag {
        CRYPTPROTECT_UI_FORBIDDEN(1),
        CRYPTPROTECT_LOCAL_MACHINE(4),
        CRYPTPROTECT_CRED_SYNC(8),
        CRYPTPROTECT_AUDIT(16),
        CRYPTPROTECT_NO_RECOVERY(32),
        CRYPTPROTECT_VERIFY_PROTECTION(64),
        CRYPTPROTECT_CRED_REGENERATE(128);

        private final int value;

        private CryptProtectFlag(int flagValue) {
            this.value = flagValue;
        }
    }
}

