/*
 * Decompiled with CFR 0.152.
 */
package com.longdo.mjpegviewer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import java.io.BufferedInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MjpegView
extends View {
    public static final int MODE_ORIGINAL = 0;
    public static final int MODE_FIT_WIDTH = 1;
    public static final int MODE_FIT_HEIGHT = 2;
    public static final int MODE_BEST_FIT = 3;
    public static final int MODE_STRETCH = 4;
    private static final int WAIT_AFTER_READ_IMAGE_ERROR_MSEC = 5000;
    private static final int CHUNK_SIZE = 4096;
    private final String tag = ((Object)((Object)this)).getClass().getSimpleName();
    private Context context;
    private String url;
    private Bitmap lastBitmap;
    private MjpegDownloader downloader;
    private final Object lockBitmap = new Object();
    private Paint paint;
    private Rect dst;
    private Rect noScaleDst;
    private int mode = 0;
    private int drawX;
    private int drawY;
    private int vWidth = -1;
    private int vHeight = -1;
    private int lastImgWidth;
    private int lastImgHeight;
    private boolean adjustWidth;
    private boolean adjustHeight;
    private int msecWaitAfterReadImageError = 5000;
    private boolean isRecycleBitmap;
    private boolean isUserForceConfigRecycle;
    private ScaleGestureDetector.OnScaleGestureListener scaleGestureListener = new ScaleGestureDetector.OnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = detector.getScaleFactor();
            ((MjpegView)MjpegView.this).dst.bottom = Math.max(((MjpegView)MjpegView.this).noScaleDst.bottom, (int)((float)((MjpegView)MjpegView.this).dst.bottom * scale));
            ((MjpegView)MjpegView.this).dst.right = Math.max(((MjpegView)MjpegView.this).noScaleDst.right, (int)((float)((MjpegView)MjpegView.this).dst.right * scale));
            ((MjpegView)MjpegView.this).dst.left = ((MjpegView)MjpegView.this).noScaleDst.left - (((MjpegView)MjpegView.this).dst.right - ((MjpegView)MjpegView.this).noScaleDst.right) / 2;
            ((MjpegView)MjpegView.this).dst.top = ((MjpegView)MjpegView.this).noScaleDst.top - (((MjpegView)MjpegView.this).dst.bottom - ((MjpegView)MjpegView.this).noScaleDst.bottom) / 2;
            MjpegView.this.invalidate();
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    };
    private ScaleGestureDetector scaleGestureDetector = new ScaleGestureDetector(this.getContext(), this.scaleGestureListener);
    private boolean isTouchDown;
    private PointF touchStart = new PointF();
    private Rect stateStart = new Rect();

    public MjpegView(Context context) {
        super(context);
        this.context = context;
        this.init();
    }

    public MjpegView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init();
    }

    private void init() {
        this.paint = new Paint(1);
        this.dst = new Rect(0, 0, 0, 0);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void startStream() {
        if (this.downloader != null && this.downloader.isRunning()) {
            Log.w((String)this.tag, (String)"Already started, stop by calling stopStream() first.");
            return;
        }
        this.downloader = new MjpegDownloader();
        this.downloader.start();
    }

    public void stopStream() {
        this.downloader.cancel();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBitmap(Bitmap bm) {
        Log.v((String)this.tag, (String)"New frame");
        Object object = this.lockBitmap;
        synchronized (object) {
            if (this.lastBitmap != null && (this.isUserForceConfigRecycle && this.isRecycleBitmap || !this.isUserForceConfigRecycle && Build.VERSION.SDK_INT < 11)) {
                Log.v((String)this.tag, (String)"Manually recycle bitmap");
                this.lastBitmap.recycle();
            }
            this.lastBitmap = bm;
        }
        if (this.context instanceof Activity) {
            ((Activity)this.context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MjpegView.this.invalidate();
                    MjpegView.this.requestLayout();
                }
            });
        } else {
            Log.e((String)this.tag, (String)"Can not request Canvas's redraw. Context is not an instance of Activity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean shouldRecalculateSize;
        Object object = this.lockBitmap;
        synchronized (object) {
            boolean bl = shouldRecalculateSize = this.lastBitmap != null && (this.lastImgWidth != this.lastBitmap.getWidth() || this.lastImgHeight != this.lastBitmap.getHeight());
            if (shouldRecalculateSize) {
                this.lastImgWidth = this.lastBitmap.getWidth();
                this.lastImgHeight = this.lastBitmap.getHeight();
            }
        }
        if (shouldRecalculateSize) {
            Log.d((String)this.tag, (String)"Recalculate view/image size");
            this.vWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            this.vHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (this.mode == 0) {
                this.drawX = (this.vWidth - this.lastImgWidth) / 2;
                this.drawY = (this.vHeight - this.lastImgHeight) / 2;
                if (this.adjustWidth) {
                    this.vWidth = this.lastImgWidth;
                    this.drawX = 0;
                }
                if (this.adjustHeight) {
                    this.vHeight = this.lastImgHeight;
                    this.drawY = 0;
                }
            } else if (this.mode == 1) {
                int newHeight = (int)((float)this.lastImgHeight / (float)this.lastImgWidth * (float)this.vWidth);
                this.drawX = 0;
                if (this.adjustHeight) {
                    this.vHeight = newHeight;
                    this.drawY = 0;
                } else {
                    this.drawY = (this.vHeight - newHeight) / 2;
                }
                this.dst.set(this.drawX, this.drawY, this.vWidth, this.drawY + newHeight);
            } else if (this.mode == 2) {
                int newWidth = (int)((float)this.lastImgWidth / (float)this.lastImgHeight * (float)this.vHeight);
                this.drawY = 0;
                if (this.adjustWidth) {
                    this.vWidth = newWidth;
                    this.drawX = 0;
                } else {
                    this.drawX = (this.vWidth - newWidth) / 2;
                }
                this.dst.set(this.drawX, this.drawY, this.drawX + newWidth, this.vHeight);
            } else if (this.mode == 3) {
                if ((float)this.lastImgWidth / (float)this.vWidth > (float)this.lastImgHeight / (float)this.vHeight) {
                    int newHeight = (int)((float)this.lastImgHeight / (float)this.lastImgWidth * (float)this.vWidth);
                    this.drawX = 0;
                    if (this.adjustHeight) {
                        this.vHeight = newHeight;
                        this.drawY = 0;
                    } else {
                        this.drawY = (this.vHeight - newHeight) / 2;
                    }
                    this.dst.set(this.drawX, this.drawY, this.vWidth, this.drawY + newHeight);
                } else {
                    int newWidth = (int)((float)this.lastImgWidth / (float)this.lastImgHeight * (float)this.vHeight);
                    this.drawY = 0;
                    if (this.adjustWidth) {
                        this.vWidth = newWidth;
                        this.drawX = 0;
                    } else {
                        this.drawX = (this.vWidth - newWidth) / 2;
                    }
                    this.dst.set(this.drawX, this.drawY, this.drawX + newWidth, this.vHeight);
                }
            } else if (this.mode == 4) {
                this.dst.set(0, 0, this.vWidth, this.vHeight);
            }
            this.noScaleDst = new Rect(this.dst);
            this.setMeasuredDimension(this.vWidth, this.vHeight);
        } else {
            if (this.vWidth == -1 || this.vHeight == -1) {
                this.vWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
                this.vHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            }
            this.setMeasuredDimension(this.vWidth, this.vHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas c) {
        Object object = this.lockBitmap;
        synchronized (object) {
            if (c != null && this.lastBitmap != null && !this.lastBitmap.isRecycled()) {
                if (!this.isInEditMode()) {
                    if (this.mode != 0) {
                        c.drawBitmap(this.lastBitmap, null, this.dst, this.paint);
                    } else {
                        c.drawBitmap(this.lastBitmap, (float)this.drawX, (float)this.drawY, this.paint);
                    }
                }
            } else {
                Log.d((String)this.tag, (String)"Skip drawing, canvas is null or bitmap is not ready yet");
            }
        }
    }

    public boolean isAdjustWidth() {
        return this.adjustWidth;
    }

    public void setAdjustWidth(boolean adjustWidth) {
        this.adjustWidth = adjustWidth;
    }

    public boolean isAdjustHeight() {
        return this.adjustHeight;
    }

    public void setAdjustHeight(boolean adjustHeight) {
        this.adjustHeight = adjustHeight;
    }

    public int getMsecWaitAfterReadImageError() {
        return this.msecWaitAfterReadImageError;
    }

    public void setMsecWaitAfterReadImageError(int msecWaitAfterReadImageError) {
        this.msecWaitAfterReadImageError = msecWaitAfterReadImageError;
    }

    public boolean isRecycleBitmap() {
        return this.isRecycleBitmap;
    }

    public void setRecycleBitmap(boolean recycleBitmap) {
        this.isUserForceConfigRecycle = true;
        this.isRecycleBitmap = recycleBitmap;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.scaleGestureDetector.onTouchEvent(event);
        if (event.getPointerCount() == 1) {
            Log.e((String)"touch", (String)event.toString());
            int id = event.getAction();
            if (id == 0) {
                this.touchStart.set(event.getX(), event.getY());
                this.stateStart.set(this.dst);
                this.isTouchDown = true;
            } else if (id == 1 || id == 3) {
                this.isTouchDown = false;
            } else if (id == 2 && this.isTouchDown) {
                int offsetLeft = (int)((float)this.stateStart.left + event.getX() - this.touchStart.x);
                int offsetTop = (int)((float)this.stateStart.top + event.getY() - this.touchStart.y);
                offsetLeft = Math.min(0, offsetLeft);
                offsetTop = Math.min(0, offsetTop);
                this.dst.left = offsetLeft;
                this.dst.top = offsetTop;
                this.invalidate();
            }
        }
        return true;
    }

    class MjpegDownloader
    extends Thread {
        private boolean run = true;

        MjpegDownloader() {
        }

        public void cancel() {
            this.run = false;
        }

        public boolean isRunning() {
            return this.run;
        }

        @Override
        public void run() {
            while (this.run) {
                block23: {
                    BufferedInputStream bis;
                    HttpURLConnection connection;
                    block22: {
                        connection = null;
                        bis = null;
                        URL serverUrl = null;
                        try {
                            serverUrl = new URL(MjpegView.this.url);
                            connection = (HttpURLConnection)serverUrl.openConnection();
                            connection.setDoInput(true);
                            connection.connect();
                            String headerBoundary = "[_a-zA-Z0-9]*boundary";
                            try {
                                String contentType = connection.getHeaderField("Content-Type");
                                if (contentType == null) {
                                    throw new Exception("Unable to get content type");
                                }
                                String[] types = contentType.split(";");
                                if (types.length == 0) {
                                    throw new Exception("Content type was empty");
                                }
                                String extractedBoundary = null;
                                for (String ct : types) {
                                    String trimmedCt = ct.trim();
                                    if (!trimmedCt.startsWith("boundary=")) continue;
                                    extractedBoundary = trimmedCt.substring(9);
                                }
                                if (extractedBoundary == null) {
                                    throw new Exception("Unable to find mjpeg boundary");
                                }
                                headerBoundary = extractedBoundary;
                            }
                            catch (Exception e) {
                                Log.w((String)MjpegView.this.tag, (String)("Cannot extract a boundary string from HTTP header with message: " + e.getMessage() + ". Use a default value instead."));
                            }
                            Pattern pattern = Pattern.compile("--" + headerBoundary + "\\s+(.*)\\r\\n\\r\\n", 32);
                            bis = new BufferedInputStream(connection.getInputStream());
                            byte[] image = new byte[]{};
                            byte[] read = new byte[4096];
                            while (this.run) {
                                try {
                                    int readByte = bis.read(read);
                                    if (readByte != -1) {
                                        byte[] tmpCheckBoundry = this.addByte(image, read, 0, readByte);
                                        String checkHeaderStr = new String(tmpCheckBoundry, "ASCII");
                                        Matcher matcher = pattern.matcher(checkHeaderStr);
                                        if (matcher.find()) {
                                            Bitmap outputImg;
                                            String boundary = matcher.group(0);
                                            int boundaryIndex = checkHeaderStr.indexOf(boundary);
                                            if ((outputImg = BitmapFactory.decodeByteArray((byte[])(image = (boundaryIndex -= image.length) > 0 ? this.addByte(image, read, 0, boundaryIndex) : this.delByte(image, -boundaryIndex)), (int)0, (int)image.length)) != null) {
                                                if (this.run) {
                                                    this.newFrame(outputImg);
                                                }
                                            } else {
                                                Log.e((String)MjpegView.this.tag, (String)"Read image error");
                                            }
                                            int headerIndex = boundaryIndex + boundary.length();
                                            image = this.addByte(new byte[0], read, headerIndex, readByte - headerIndex);
                                            continue;
                                        }
                                        image = this.addByte(image, read, 0, readByte);
                                        continue;
                                    }
                                    break;
                                }
                                catch (Exception e) {
                                    if (e != null && e.getMessage() != null) {
                                        Log.e((String)MjpegView.this.tag, (String)e.getMessage());
                                    }
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            if (e == null || e.getMessage() == null) break block22;
                            Log.e((String)MjpegView.this.tag, (String)e.getMessage());
                        }
                    }
                    try {
                        bis.close();
                        connection.disconnect();
                        Log.i((String)MjpegView.this.tag, (String)("disconnected with " + MjpegView.this.url));
                    }
                    catch (Exception e) {
                        if (e == null || e.getMessage() == null) break block23;
                        Log.e((String)MjpegView.this.tag, (String)e.getMessage());
                    }
                }
                if (MjpegView.this.msecWaitAfterReadImageError <= 0) continue;
                try {
                    Thread.sleep(MjpegView.this.msecWaitAfterReadImageError);
                }
                catch (InterruptedException e) {
                    if (e == null || e.getMessage() == null) continue;
                    Log.e((String)MjpegView.this.tag, (String)e.getMessage());
                }
            }
        }

        private byte[] addByte(byte[] base, byte[] add, int addIndex, int length) {
            byte[] tmp = new byte[base.length + length];
            System.arraycopy(base, 0, tmp, 0, base.length);
            System.arraycopy(add, addIndex, tmp, base.length, length);
            return tmp;
        }

        private byte[] delByte(byte[] base, int del) {
            byte[] tmp = new byte[base.length - del];
            System.arraycopy(base, 0, tmp, 0, tmp.length);
            return tmp;
        }

        private void newFrame(Bitmap bitmap) {
            MjpegView.this.setBitmap(bitmap);
        }
    }
}

