/*
 * Decompiled with CFR 0.152.
 */
package com.pepperonas.materialdialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.text.SpannableString;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.pepperonas.materialdialog.DialogButtonCountDown;
import com.pepperonas.materialdialog.R;
import com.pepperonas.materialdialog.adapter.CustomArrayAdapter;
import com.pepperonas.materialdialog.adapter.CustomMultipleSelectionArrayAdapter;
import com.pepperonas.materialdialog.adapter.CustomSingleSelectionArrayAdapter;
import com.pepperonas.materialdialog.adapter.FileChooserArrayAdapter;
import com.pepperonas.materialdialog.adapter.ShareAdapter;
import com.pepperonas.materialdialog.model.Changelog;
import com.pepperonas.materialdialog.model.LicenseInfo;
import com.pepperonas.materialdialog.model.ReleaseInfo;
import com.pepperonas.materialdialog.utils.TypefaceSpan;
import com.pepperonas.materialdialog.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MaterialDialog
extends AlertDialog {
    private static final String TAG = "MaterialDialog";

    public MaterialDialog(@NonNull Builder builder) {
        super(builder.context);
        this.invoke(builder);
    }

    public MaterialDialog(@NonNull Builder builder, @StyleRes int style) {
        super(builder.context, style);
        this.invoke(builder);
    }

    private void invoke(final @NonNull Builder builder) {
        LayoutInflater inflater;
        ListView lv;
        boolean isListDialog = false;
        if (Build.VERSION.SDK_INT >= 14 && builder.dimPercent != -1) {
            float value = (float)builder.dimPercent / 100.0f;
            if (value < 0.0f) {
                value = 0.0f;
            }
            if (value > 1.0f) {
                value = 1.0f;
            }
            this.getWindow().setDimAmount(value);
        }
        if (builder.customView != null) {
            this.getWindow().requestFeature(1);
            if (builder.viewSpacingLeft == -1 && builder.viewSpacingTop == -1 && builder.viewSpacingRight == -1 && builder.viewSpacingBottom == -1) {
                builder.viewSpacingLeft = Utils.dp2px(builder.context, 8);
                builder.viewSpacingTop = Utils.dp2px(builder.context, 0);
                builder.viewSpacingRight = Utils.dp2px(builder.context, 12);
                builder.viewSpacingBottom = Utils.dp2px(builder.context, 0);
            }
            this.setView(builder.customView, builder.viewSpacingLeft, builder.viewSpacingTop, builder.viewSpacingRight, builder.viewSpacingBottom);
        }
        if (builder.items != null && builder.items.length > 0 || builder.shareAppDialog || builder.adapter != null) {
            isListDialog = true;
            if (builder.customView != null) {
                Log.w((String)TAG, (String)"ListView will override the custom view.");
            }
            LayoutInflater layoutInflater = (LayoutInflater)builder.context.getSystemService("layout_inflater");
            LinearLayout llListDialog = (LinearLayout)layoutInflater.inflate(R.layout.dialog_list, null);
            this.setView((View)llListDialog, builder.viewSpacingLeft, builder.viewSpacingTop, builder.viewSpacingRight, builder.viewSpacingBottom);
            lv = (ListView)llListDialog.findViewById(R.id.list_dialog_listview);
            TextView tv = (TextView)llListDialog.findViewById(R.id.list_dialog_tv_message);
            if (builder.message != null) {
                tv.setText((CharSequence)this.getSpannable(builder, builder.message));
            } else {
                llListDialog.removeView((View)tv);
                lv.setPadding(0, Utils.dp2px(builder.context, 16), 0, 0);
            }
            if (builder.title == null) {
                lv.setPadding(0, Utils.dp2px(builder.context, 8), 0, Utils.dp2px(builder.context, 8));
            }
            if (!(builder.multiChoice || builder.blankListing || builder.shareAppDialog || builder.adapter != null)) {
                int preselectedIndex = 0;
                if (builder.preSelectedIndices.length > 0 && (preselectedIndex = builder.preSelectedIndices[0].intValue()) >= builder.items.length) {
                    Log.w((String)TAG, (String)"Selected item greater than item count. Will select first item.");
                    preselectedIndex = 0;
                }
                if (builder.preSelectedIndices.length != 1) {
                    Log.w((String)TAG, (String)("Can't select multiple items in single selection. Will only select \"" + builder.items[builder.preSelectedIndices[builder.preSelectedIndices.length - 1]] + "\"."));
                }
                CustomSingleSelectionArrayAdapter cssaa = new CustomSingleSelectionArrayAdapter(builder.context, builder.items, preselectedIndex, builder.itemClickListener, builder.itemLongClickListener, builder.typeface);
                lv.setDivider(null);
                lv.setAdapter((ListAdapter)cssaa);
            } else if (!builder.multiChoice && builder.adapter == null && !builder.shareAppDialog) {
                CustomArrayAdapter caa = new CustomArrayAdapter(this, builder.context, builder.items, builder.itemClickListener, builder.itemLongClickListener, builder.dismissOnSelection, builder.typeface);
                lv.setDivider(null);
                lv.setAdapter((ListAdapter)caa);
            } else if (builder.adapter == null && !builder.shareAppDialog) {
                CustomMultipleSelectionArrayAdapter cmsaa = new CustomMultipleSelectionArrayAdapter(builder.context, builder.items, builder.preSelectedIndices, builder.itemClickListener, builder.itemLongClickListener, builder.typeface);
                lv.setChoiceMode(2);
                lv.setDivider(null);
                lv.setAdapter((ListAdapter)cmsaa);
            }
            if (builder.adapter != null) {
                lv.setDivider(null);
                lv.setAdapter((ListAdapter)builder.adapter);
                if (builder.adapterItemClickListener != null) {
                    lv.setOnItemClickListener(builder.adapterItemClickListener);
                }
            }
            if (builder.shareAppDialog) {
                ShareAdapter sa = new ShareAdapter(builder.context, builder.typeface);
                lv.setDivider(null);
                lv.setAdapter((ListAdapter)sa);
                lv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                        ResolveInfo info = (ResolveInfo)lv.getAdapter().getItem(position);
                        Intent intent = new Intent("android.intent.action.SEND");
                        intent.setClassName(info.activityInfo.packageName, info.activityInfo.name);
                        intent.setType("text/plain");
                        intent.putExtra("android.intent.extra.SUBJECT", "");
                        intent.putExtra("android.intent.extra.TEXT", (builder.shareAppMessage != null ? builder.shareAppMessage : "") + "\nhttps://play.google.com/store/apps/details?id=" + builder.context.getPackageName());
                        builder.context.startActivity(intent);
                    }
                });
            }
        }
        if (builder.licenseDialog) {
            if (builder.libNames.length == builder.libDevelopers.length && builder.libDevelopers.length == builder.libLicenses.length && builder.libNames.length != 0) {
                LinearLayout llLibContainer = (LinearLayout)builder.customView.findViewById(R.id.ll_dialog_license_container);
                for (int i = 0; i < builder.libNames.length; ++i) {
                    inflater = LayoutInflater.from((Context)builder.context);
                    LinearLayout llLicenseInfo = (LinearLayout)inflater.inflate(R.layout.item_license, null);
                    ((TextView)llLicenseInfo.findViewById(R.id.tv_lib_name)).setText((CharSequence)builder.libNames[i]);
                    ((TextView)llLicenseInfo.findViewById(R.id.tv_lib_developer)).setText((CharSequence)builder.libDevelopers[i]);
                    ((TextView)llLicenseInfo.findViewById(R.id.tv_lib_licence)).setText((CharSequence)builder.libLicenses[i]);
                    if (builder.typeface != null) {
                        ((TextView)llLicenseInfo.findViewById(R.id.tv_lib_name)).setTypeface(builder.typeface);
                        ((TextView)llLicenseInfo.findViewById(R.id.tv_lib_developer)).setTypeface(builder.typeface);
                        ((TextView)llLicenseInfo.findViewById(R.id.tv_lib_licence)).setTypeface(builder.typeface);
                    }
                    llLibContainer.addView((View)llLicenseInfo);
                }
            } else {
                Log.e((String)TAG, (String)"Invalid license information. Check the size of the arrays.");
            }
        }
        if (builder.changelogDialog) {
            if (builder.clVersionNames.length == builder.clDates.length && builder.clDates.length == builder.clReleaseInfos.length && builder.clVersionNames.length != 0) {
                LinearLayout llClContainer = (LinearLayout)builder.customView.findViewById(R.id.ll_dialog_changelog_container);
                for (int i = 0; i < builder.clVersionNames.length; ++i) {
                    inflater = LayoutInflater.from((Context)builder.context);
                    LinearLayout llChangelog = (LinearLayout)inflater.inflate(R.layout.item_changelog, null);
                    ((TextView)llChangelog.findViewById(R.id.tv_cl_version)).setText((CharSequence)builder.clVersionNames[i]);
                    ((TextView)llChangelog.findViewById(R.id.tv_cl_date)).setText((CharSequence)builder.clDates[i]);
                    if (builder.typeface != null) {
                        ((TextView)llChangelog.findViewById(R.id.tv_cl_version)).setTypeface(builder.typeface);
                        ((TextView)llChangelog.findViewById(R.id.tv_cl_date)).setTypeface(builder.typeface);
                    }
                    ReleaseInfo ri = builder.clReleaseInfos[i];
                    for (int j = 0; j < ri.getReleaseInfo().size(); ++j) {
                        LayoutInflater _inflater = LayoutInflater.from((Context)builder.context);
                        LinearLayout llReleaseInfo = (LinearLayout)_inflater.inflate(R.layout.item_changelog_release_info, null);
                        ((TextView)llReleaseInfo.findViewById(R.id.tv_release_info)).setText((CharSequence)ri.getReleaseInfo().get(j));
                        if (builder.typeface != null) {
                            ((TextView)llReleaseInfo.findViewById(R.id.tv_release_info)).setTypeface(builder.typeface);
                        }
                        if (builder.clBullet != null) {
                            ((TextView)llReleaseInfo.findViewById(R.id.tv_release_info_bullet)).setText((CharSequence)builder.clBullet);
                        } else {
                            llReleaseInfo.findViewById(R.id.tv_release_info_bullet).setVisibility(8);
                        }
                        ((LinearLayout)llChangelog.findViewById(R.id.ll_dialog_changelog_release_info_container)).addView((View)llReleaseInfo);
                    }
                    llClContainer.addView((View)llChangelog);
                }
            } else {
                Log.e((String)TAG, (String)"Invalid changelog information. Check the size of the arrays.");
            }
        }
        if (builder.title != null) {
            this.setTitle((CharSequence)this.getSpannable(builder, builder.title));
        }
        if (builder.message != null && !isListDialog) {
            this.setMessage((CharSequence)this.getSpannable(builder, builder.message));
        }
        if (builder.icon != -1) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.setIcon(builder.context.getDrawable(builder.icon));
            } else {
                this.setIcon(builder.context.getResources().getDrawable(builder.icon));
            }
        }
        if (builder.drawable != null) {
            this.setIcon(builder.drawable);
        }
        if (builder.positiveText != null) {
            this.setButton(-1, builder.positiveText, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (builder.buttonCallback != null) {
                        builder.buttonCallback.onAny(MaterialDialog.this);
                        builder.buttonCallback.onPositive(MaterialDialog.this);
                    }
                }
            });
        }
        if (builder.neutralText != null) {
            this.setButton(-3, builder.neutralText, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (builder.buttonCallback != null) {
                        builder.buttonCallback.onAny(MaterialDialog.this);
                        builder.buttonCallback.onNeutral(MaterialDialog.this);
                    }
                }
            });
        }
        if (builder.negativeText != null) {
            this.setButton(-2, builder.negativeText, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (builder.buttonCallback != null) {
                        builder.buttonCallback.onAny(MaterialDialog.this);
                        builder.buttonCallback.onNegative(MaterialDialog.this);
                    }
                }
            });
        }
        this.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface d) {
                AlertDialog dialog = (AlertDialog)d;
                if (builder.fullscreen) {
                    MaterialDialog.this.getWindow().setLayout(-1, -1);
                }
                if (builder.showListener != null) {
                    builder.showListener.onShow(dialog);
                }
                if (builder.typeface != null) {
                    dialog.getButton(-1).setTypeface(builder.typeface);
                }
                if (builder.typeface != null) {
                    dialog.getButton(-3).setTypeface(builder.typeface);
                }
                if (builder.typeface != null) {
                    dialog.getButton(-2).setTypeface(builder.typeface);
                }
                if (builder.positiveText != null && builder.positiveColor != -1) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        dialog.getButton(-1).setTextColor(builder.context.getColor(builder.positiveColor));
                    } else {
                        dialog.getButton(-1).setTextColor(builder.context.getResources().getColor(builder.positiveColor));
                    }
                    if (builder.positiveDelayed && builder.finishedText != null) {
                        DialogButtonCountDown countDown = new DialogButtonCountDown(builder.millisInFuture, builder.countDownInterval, builder.finishedText, dialog.getButton(-1));
                        countDown.start();
                    }
                }
                if (builder.neutralText != null && builder.neutralColor != -1) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        dialog.getButton(-3).setTextColor(builder.context.getColor(builder.neutralColor));
                    } else {
                        dialog.getButton(-3).setTextColor(builder.context.getResources().getColor(builder.neutralColor));
                    }
                }
                if (builder.negativeText != null && builder.negativeColor != -1) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        dialog.getButton(-2).setTextColor(builder.context.getColor(builder.negativeColor));
                    } else {
                        dialog.getButton(-2).setTextColor(builder.context.getResources().getColor(builder.negativeColor));
                    }
                }
                Log.i((String)MaterialDialog.TAG, (String)("MaterialDialog " + MaterialDialog.this.getWindow().getDecorView().getHeight()));
                if (builder.scaleX != -1 || builder.scaleY != -1) {
                    float fScaleX = builder.scaleX != -1 ? (float)builder.scaleX / 100.0f : 1.0f;
                    float fScaleY = builder.scaleY != -1 ? (float)builder.scaleY / 100.0f : 1.0f;
                    Rect displayRectangle = new Rect();
                    Window window = MaterialDialog.this.getWindow();
                    window.getDecorView().getWindowVisibleDisplayFrame(displayRectangle);
                    dialog.getWindow().setLayout((int)((float)displayRectangle.width() * fScaleX), (int)((float)displayRectangle.height() * fScaleY));
                }
            }
        });
        if (builder.fileChooser) {
            LayoutInflater layoutInflater = (LayoutInflater)builder.context.getSystemService("layout_inflater");
            LinearLayout llFileChooserDialog = (LinearLayout)layoutInflater.inflate(R.layout.dialog_file_chooser, null);
            this.setView((View)llFileChooserDialog, builder.viewSpacingLeft, builder.viewSpacingTop, builder.viewSpacingRight, builder.viewSpacingBottom);
            this.setMessage(null);
            builder.dismissOnSelection = false;
            if (builder.message != null) {
                this.setTitle((CharSequence)this.getSpannable(builder, builder.message));
            }
            this.setTitle((CharSequence)this.getSpannable(builder, builder.startPath.getAbsolutePath()));
            lv = (ListView)llFileChooserDialog.findViewById(R.id.file_chooser_dialog_listview);
            ArrayList<File> chooserItems = new ArrayList<File>();
            Log.i((String)TAG, (String)("invoke: startpath=" + builder.startPath.getPath()));
            Log.i((String)TAG, (String)("invoke: ext__path=" + Environment.getExternalStorageDirectory().getPath()));
            if (builder.startPath.getPath().contains("/..")) {
                builder.startPath = new File(builder.startPath.getPath().replace("/..", ""));
            }
            try {
                if (builder.startPath.getPath().equals(Environment.getExternalStorageDirectory().getPath())) {
                    Log.i((String)TAG, (String)"FS: in home");
                } else {
                    Log.i((String)TAG, (String)"FS: not in home");
                    chooserItems.add(new File("/.."));
                }
                for (String s : builder.startPath.list()) {
                    chooserItems.add(new File(builder.startPath + "/" + s));
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error while reading FS");
            }
            builder.files = Utils.sortFiles(chooserItems);
            FileChooserArrayAdapter fcaa = new FileChooserArrayAdapter(this, builder.context, builder.files, builder.startPath, new ItemClickListener(){

                @Override
                public void onClick(View v, int position, long id2) {
                    super.onClick(v, position, id2);
                    File f = new File(((File)builder.files.get(position)).getPath());
                    if (!f.isDirectory()) {
                        if (builder.fileChooserListener != null) {
                            builder.fileChooserListener.onFileSelected(MaterialDialog.this, v, position, id2, f);
                        }
                        Log.d((String)MaterialDialog.TAG, (String)("onClick: " + f.getName() + " is a file."));
                    } else {
                        if (f.getPath().endsWith("/..")) {
                            Log.i((String)MaterialDialog.TAG, (String)"onClick: UP");
                            builder.fileChooserDialog(builder.activity, builder.requestCode, builder.allowDirectorySelection, builder.startPath.getParent(), builder.fileChooserListener);
                        } else {
                            Log.d((String)MaterialDialog.TAG, (String)"onClick: DOWN");
                            builder.fileChooserDialog(builder.activity, builder.requestCode, builder.allowDirectorySelection, builder.startPath + "/" + ((File)builder.files.get(position)).getName(), builder.fileChooserListener);
                        }
                        builder.show();
                        Handler handler = new Handler();
                        handler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                MaterialDialog.this.cancel();
                                MaterialDialog.this.dismiss();
                            }
                        }, 100L);
                    }
                }
            }, builder.itemLongClickListener, builder.dismissOnSelection, builder.typeface);
            lv.setDivider(null);
            lv.setAdapter((ListAdapter)fcaa);
            if (!builder.allowDirectorySelection && builder.startPath.isDirectory()) {
                builder.showListener(new ShowListener(){

                    @Override
                    public void onShow(AlertDialog dialog) {
                        super.onShow(dialog);
                        dialog.getButton(-1).setEnabled(false);
                    }
                });
            }
            builder.buttonCallback(new ButtonCallback(){

                @Override
                public void onPositive(MaterialDialog dialog) {
                    super.onPositive(dialog);
                    builder.fileChooserListener.onFileSet(MaterialDialog.this, builder.startPath);
                }
            });
        }
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (builder.dismissListener != null) {
                    builder.dismissListener.onDismiss();
                }
            }
        });
    }

    private SpannableString getSpannable(@NonNull Builder builder, CharSequence charSequence) {
        if (builder.typeface != null) {
            SpannableString s = new SpannableString(charSequence);
            s.setSpan((Object)new TypefaceSpan(builder.typeface), 0, s.length(), 33);
            return s;
        }
        return SpannableString.valueOf((CharSequence)charSequence);
    }

    public static class Version {
        public static String getVersionName() {
            return "0.3.4";
        }

        public static String getVersionInfo() {
            return "materialdialog-0.3.4";
        }

        public static String getLicense() {
            return "Copyright (c) 2016 Martin Pfeffer\n \nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n \n     http://www.apache.org/licenses/LICENSE-2.0\n \nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.";
        }
    }

    public static abstract class FileChooserListener {
        public void onFileSelected(MaterialDialog dialog, View view, int position, long id2, File file) {
            Log.d((String)MaterialDialog.TAG, (String)("onSelected " + position));
        }

        public void onFileSet(MaterialDialog dialog, File file) {
            Log.d((String)MaterialDialog.TAG, (String)("onFileSet: " + file.getAbsolutePath()));
        }

        public void onNothingSelected(AdapterView<?> parent) {
        }

        protected final Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public final boolean equals(Object o) {
            return super.equals(o);
        }

        protected final void finalize() throws Throwable {
            super.finalize();
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return super.toString();
        }
    }

    public static abstract class ItemSelectedListener {
        public void onSelected(View view, int position, long id2) {
            Log.d((String)MaterialDialog.TAG, (String)("onSelected " + position));
        }

        public void onNothingSelected(AdapterView<?> parent) {
        }

        protected final Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public final boolean equals(Object o) {
            return super.equals(o);
        }

        protected final void finalize() throws Throwable {
            super.finalize();
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return super.toString();
        }
    }

    public static abstract class ItemLongClickListener {
        public void onLongClick(View view, int position, long id2) {
            Log.d((String)MaterialDialog.TAG, (String)("onLongClick " + position));
        }

        protected final Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public final boolean equals(Object o) {
            return super.equals(o);
        }

        protected final void finalize() throws Throwable {
            super.finalize();
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return super.toString();
        }
    }

    public static abstract class ItemClickListener {
        public void onClick(View v, int position, long id2) {
            Log.d((String)MaterialDialog.TAG, (String)("onClick " + position));
        }

        protected final Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public final boolean equals(Object o) {
            return super.equals(o);
        }

        protected final void finalize() throws Throwable {
            super.finalize();
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return super.toString();
        }
    }

    public static abstract class ShowListener {
        public void onShow(AlertDialog dialog) {
            Log.d((String)MaterialDialog.TAG, (String)"onShow ");
        }

        protected final Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public final boolean equals(Object o) {
            return super.equals(o);
        }

        protected final void finalize() throws Throwable {
            super.finalize();
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return super.toString();
        }
    }

    public static abstract class DismissListener {
        public void onDismiss() {
            Log.d((String)MaterialDialog.TAG, (String)"onDismiss ");
        }

        protected final Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public final boolean equals(Object o) {
            return super.equals(o);
        }

        protected final void finalize() throws Throwable {
            super.finalize();
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return super.toString();
        }
    }

    public static abstract class ButtonCallback {
        public void onAny(MaterialDialog dialog) {
            Log.d((String)MaterialDialog.TAG, (String)"onAny ");
        }

        public void onPositive(MaterialDialog dialog) {
            Log.d((String)MaterialDialog.TAG, (String)"onPositive ");
        }

        public void onNeutral(MaterialDialog dialog) {
            Log.d((String)MaterialDialog.TAG, (String)"onNeutral ");
        }

        public void onNegative(MaterialDialog dialog) {
            Log.d((String)MaterialDialog.TAG, (String)"onNegative ");
        }

        protected final Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public final boolean equals(Object o) {
            return super.equals(o);
        }

        protected final void finalize() throws Throwable {
            super.finalize();
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return super.toString();
        }
    }

    public static class Builder {
        private final Context context;
        private int style = -1;
        private CharSequence title;
        private CharSequence message;
        private Typeface typeface;
        private int dimPercent = -1;
        private CharSequence positiveText;
        private CharSequence neutralText;
        private CharSequence negativeText;
        private int positiveColor = -1;
        private int neutralColor = -1;
        private int negativeColor = -1;
        private ButtonCallback buttonCallback;
        private ShowListener showListener;
        private DismissListener dismissListener;
        private int icon = -1;
        private Drawable drawable;
        private boolean canceledOnTouchOutside = true;
        private boolean cancelable = true;
        private View customView;
        private int viewSpacingLeft = -1;
        private int viewSpacingTop = -1;
        private int viewSpacingRight = -1;
        private int viewSpacingBottom = -1;
        private int scaleX = -1;
        private int scaleY = -1;
        private boolean fullscreen = false;
        private boolean blankListing;
        private boolean multiChoice;
        private boolean dismissOnSelection = false;
        private String[] items;
        private BaseAdapter adapter;
        private Integer[] preSelectedIndices;
        private ItemClickListener itemClickListener;
        private ItemLongClickListener itemLongClickListener;
        private ItemSelectedListener itemSelectedListener;
        private AdapterView.OnItemClickListener adapterItemClickListener;
        private boolean itemLongClickable = false;
        private boolean positiveDelayed;
        private long millisInFuture;
        private long countDownInterval;
        private String finishedText;
        private boolean shareAppDialog = false;
        private String shareAppMessage = "";
        private boolean licenseDialog = false;
        private String[] libNames;
        private String[] libDevelopers;
        private String[] libLicenses;
        private boolean changelogDialog = false;
        private String[] clVersionNames;
        private String[] clDates;
        private ReleaseInfo[] clReleaseInfos;
        private String clBullet;
        private Activity activity;
        private int requestCode;
        private List<File> files;
        private boolean fileChooser = false;
        private boolean allowDirectorySelection = false;
        private File startPath;
        private FileChooserListener fileChooserListener;

        public Builder(@NonNull Context context) {
            this.context = context;
        }

        public Builder(@NonNull Context context, @StyleRes int style) {
            this.context = context;
            this.style = style;
        }

        public Builder title(@Nullable CharSequence title) {
            this.title = title;
            return this;
        }

        public Builder title(@StringRes int title) {
            this.title = this.context.getString(title);
            return this;
        }

        public Builder message(@Nullable CharSequence message) {
            this.message = message;
            return this;
        }

        public Builder message(@StringRes int message) {
            this.message = this.context.getString(message);
            return this;
        }

        public Builder font(Typeface typeface) {
            this.typeface = typeface;
            return this;
        }

        public Builder dim(int percent) {
            this.dimPercent = percent;
            return this;
        }

        public Builder scale(int percentX, int percentY) {
            this.scaleX = percentX;
            this.scaleY = percentY;
            return this;
        }

        public Builder fullscreen(boolean fullscreen) {
            this.fullscreen = fullscreen;
            return this;
        }

        public Builder positiveText(@NonNull CharSequence positiveText) {
            this.positiveText = positiveText;
            return this;
        }

        public Builder positiveText(@StringRes int positiveText) {
            this.positiveText = this.context.getString(positiveText);
            return this;
        }

        public Builder neutralText(@NonNull CharSequence neutralText) {
            this.neutralText = neutralText;
            return this;
        }

        public Builder neutralText(@StringRes int neutralText) {
            this.neutralText = this.context.getString(neutralText);
            return this;
        }

        public Builder negativeText(@NonNull CharSequence negativeText) {
            this.negativeText = negativeText;
            return this;
        }

        public Builder negativeText(@StringRes int negativeText) {
            this.negativeText = this.context.getString(negativeText);
            return this;
        }

        public Builder positiveColor(@ColorRes int colorId) {
            this.positiveColor = colorId;
            return this;
        }

        public Builder neutralColor(@ColorRes int colorId) {
            this.neutralColor = colorId;
            return this;
        }

        public Builder negativeColor(@ColorRes int colorId) {
            this.negativeColor = colorId;
            return this;
        }

        public Builder icon(@DrawableRes int drawableId) {
            this.icon = drawableId;
            return this;
        }

        public Builder icon(@NonNull Drawable drawable) {
            this.drawable = drawable;
            return this;
        }

        public Builder buttonCallback(@NonNull ButtonCallback buttonCallback) {
            this.buttonCallback = buttonCallback;
            return this;
        }

        public Builder showListener(@NonNull ShowListener showListener) {
            this.showListener = showListener;
            return this;
        }

        public Builder dismissListener(@NonNull DismissListener dismissListener) {
            this.dismissListener = dismissListener;
            return this;
        }

        public Builder canceledOnTouchOutside(boolean canceledOnTouchOutside) {
            this.canceledOnTouchOutside = canceledOnTouchOutside;
            return this;
        }

        public Builder cancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder customView(@NonNull View customView) {
            this.customView = customView;
            return this;
        }

        public Builder customView(@LayoutRes int layoutId) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.context);
            this.customView = inflater.inflate(layoutId, null);
            return this;
        }

        public Builder viewSpacingDp(int viewSpacingLeftDp, int viewSpacingTopDp, int viewSpacingRightDp, int viewSpacingBottomDp) {
            this.viewSpacingLeft = Utils.dp2px(this.context, viewSpacingLeftDp);
            this.viewSpacingTop = Utils.dp2px(this.context, viewSpacingTopDp);
            this.viewSpacingRight = Utils.dp2px(this.context, viewSpacingRightDp);
            this.viewSpacingBottom = Utils.dp2px(this.context, viewSpacingBottomDp);
            return this;
        }

        public Builder adapter(boolean dismissOnSelection, @NonNull BaseAdapter adapter, @Nullable AdapterView.OnItemClickListener adapterItemClickListener) {
            this.blankListing = true;
            this.dismissOnSelection = dismissOnSelection;
            this.adapter = adapter;
            this.adapterItemClickListener = adapterItemClickListener;
            return this;
        }

        public Builder listItems(boolean dismissOnSelection, String ... items) {
            this.blankListing = true;
            this.dismissOnSelection = dismissOnSelection;
            this.multiChoice = false;
            this.items = items;
            return this;
        }

        public Builder listItemsSingleSelection(boolean dismissOnSelection, String ... items) {
            this.blankListing = false;
            this.dismissOnSelection = dismissOnSelection;
            this.multiChoice = false;
            this.items = items;
            return this;
        }

        public Builder listItemsMultiChoice(String ... items) {
            this.blankListing = false;
            this.multiChoice = true;
            this.items = items;
            return this;
        }

        public Builder selection(Integer ... preSelected) {
            this.preSelectedIndices = preSelected;
            return this;
        }

        public Builder itemLongClickable(boolean itemLongClickable) {
            this.itemLongClickable = itemLongClickable;
            return this;
        }

        public Builder itemClickListener(@NonNull ItemClickListener itemClickListener) {
            this.itemClickListener = itemClickListener;
            return this;
        }

        public Builder itemLongClickListener(@NonNull ItemLongClickListener itemLongClickListener) {
            this.itemLongClickable = true;
            this.itemLongClickListener = itemLongClickListener;
            return this;
        }

        public Builder itemSelectedListener(@NonNull ItemSelectedListener itemSelectedListener) {
            this.itemSelectedListener = itemSelectedListener;
            return this;
        }

        public Builder positiveDelayed(long millisInFuture, long countDownInterval, @NonNull String finishedText) {
            this.positiveDelayed = true;
            this.millisInFuture = millisInFuture;
            this.countDownInterval = countDownInterval;
            this.finishedText = finishedText;
            return this;
        }

        public Builder fileChooserDialog(Activity activity, int requestCode, boolean directorySelection, @Nullable String startPath, @Nullable FileChooserListener fileChooserListener) {
            this.activity = activity;
            this.requestCode = requestCode;
            if (Build.VERSION.SDK_INT >= 23 && this.context.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0) {
                activity.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, requestCode);
                Toast.makeText((Context)activity, (int)R.string.missing_permission_read_file, (int)0).show();
            }
            this.fileChooser = true;
            this.allowDirectorySelection = directorySelection;
            this.startPath = startPath == null ? Environment.getExternalStorageDirectory() : new File(startPath);
            this.fileChooserListener = fileChooserListener;
            return this;
        }

        public Builder fileChooserDialog(Activity activity, boolean directorySelection, @Nullable String startPath, @Nullable FileChooserListener fileChooserListener) {
            this.activity = activity;
            this.fileChooser = true;
            this.allowDirectorySelection = directorySelection;
            this.startPath = startPath == null ? Environment.getExternalStorageDirectory() : new File(startPath);
            this.fileChooserListener = fileChooserListener;
            return this;
        }

        public Builder shareAppDialog(boolean shareAppDialog, @Nullable String shareAppMessage) {
            this.shareAppDialog = shareAppDialog;
            this.shareAppMessage = shareAppMessage;
            this.message = null;
            return this;
        }

        public Builder licenseDialog(@NonNull String[] libraryNames, @NonNull String[] libraryDevelopers, @NonNull String[] libraryLicenses) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.context);
            this.customView = inflater.inflate(R.layout.dialog_license, null);
            this.licenseDialog = true;
            this.message = null;
            this.libNames = libraryNames;
            this.libDevelopers = libraryDevelopers;
            this.libLicenses = libraryLicenses;
            this.setViewSpacing(0);
            return this;
        }

        public Builder licenseDialog(@NonNull List<LicenseInfo> licenseInfos) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.context);
            this.customView = inflater.inflate(R.layout.dialog_license, null);
            this.licenseDialog = true;
            this.message = null;
            this.libNames = new String[licenseInfos.size()];
            this.libDevelopers = new String[licenseInfos.size()];
            this.libLicenses = new String[licenseInfos.size()];
            this.setViewSpacing(0);
            int i = 0;
            for (LicenseInfo li : licenseInfos) {
                this.libNames[i] = li.getName();
                this.libDevelopers[i] = li.getDeveloper();
                this.libLicenses[i] = li.getLicenseText();
                ++i;
            }
            return this;
        }

        public Builder changelogDialog(@NonNull String[] versionNames, @NonNull String[] dates, @NonNull ReleaseInfo[] releaseInfos) {
            return this.changelogDialog(versionNames, dates, releaseInfos, "");
        }

        public Builder changelogDialog(@NonNull String[] versionNames, @NonNull String[] dates, @NonNull ReleaseInfo[] releaseInfos, @Nullable String bullet) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.context);
            this.customView = inflater.inflate(R.layout.dialog_changelog, null);
            this.changelogDialog = true;
            this.message = null;
            this.clVersionNames = versionNames;
            this.clDates = dates;
            this.clReleaseInfos = releaseInfos;
            this.setViewSpacing(0);
            if (bullet != null) {
                this.clBullet = bullet;
            }
            return this;
        }

        public Builder changelogDialog(@NonNull List<Changelog> changelogs) {
            return this.changelogDialog(changelogs, "");
        }

        public Builder changelogDialog(@NonNull List<Changelog> changelogs, @Nullable String bullet) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.context);
            this.customView = inflater.inflate(R.layout.dialog_changelog, null);
            this.changelogDialog = true;
            this.message = null;
            this.clVersionNames = new String[changelogs.size()];
            this.clDates = new String[changelogs.size()];
            this.clReleaseInfos = new ReleaseInfo[changelogs.size()];
            this.setViewSpacing(0);
            if (bullet != null) {
                this.clBullet = bullet;
            }
            int i = 0;
            for (Changelog cl : changelogs) {
                this.clVersionNames[i] = cl.getVersionName();
                this.clDates[i] = cl.getDate();
                this.clReleaseInfos[i] = cl.getReleaseInfo();
                ++i;
            }
            return this;
        }

        public MaterialDialog build() {
            if (this.style == -1) {
                return new MaterialDialog(this);
            }
            return new MaterialDialog(this, this.style);
        }

        public void show() {
            this.build().show();
        }

        private void setViewSpacing(int spacing) {
            this.viewSpacingLeft = spacing;
            this.viewSpacingTop = spacing;
            this.viewSpacingRight = spacing;
            this.viewSpacingBottom = spacing;
        }
    }

    class ThreadDemo
    extends Thread {
        private Thread t;
        private ListView lv;
        private String threadName;

        ThreadDemo(ListView lv, String threadName) {
            this.lv = lv;
            this.threadName = threadName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ListView listView = this.lv;
            synchronized (listView) {
                this.lv.notify();
            }
            System.out.println("Thread " + this.threadName + " exiting.");
        }

        @Override
        public void start() {
            System.out.println("Starting " + this.threadName);
            if (this.t == null) {
                this.t = new Thread((Runnable)this, this.threadName);
                this.t.start();
            }
        }
    }
}

