/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengfeizhou.jscore;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import com.facebook.soloader.SoLoader;
import com.github.pengfeizhou.jscore.JSExecutor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class SOLibraryLoader {
    public static Context sContext = null;
    public static Logger sLogger = null;

    private static void log(String tag, String message) {
        if (sLogger != null) {
            sLogger.log(tag, message);
        }
    }

    public static boolean loadLibraryWithClass(String loadName, Class className) {
        boolean isLoad = false;
        try {
            ClassLoader classLoader = className.getClassLoader();
            Class<?> runtime = Runtime.getRuntime().getClass();
            Class[] args = new Class[2];
            int version = Build.VERSION.SDK_INT;
            String functionName = "loadLibrary";
            if (version > 24) {
                args[0] = ClassLoader.class;
                args[1] = String.class;
                functionName = "loadLibrary0";
                Method loadMethod = runtime.getDeclaredMethod(functionName, args);
                loadMethod.setAccessible(true);
                loadMethod.invoke((Object)Runtime.getRuntime(), classLoader, loadName);
            } else {
                args[0] = String.class;
                args[1] = ClassLoader.class;
                Method loadMethod = runtime.getDeclaredMethod(functionName, args);
                loadMethod.setAccessible(true);
                loadMethod.invoke((Object)Runtime.getRuntime(), loadName, classLoader);
            }
            isLoad = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isLoad;
    }

    public static boolean loadSOLibrary(String libName, int version) {
        boolean InitSuc;
        block10: {
            try {
                System.loadLibrary(libName);
                InitSuc = true;
            }
            catch (Error | Exception e) {
                SOLibraryLoader.log("ERR_LOAD_SO", "System load" + libName + " " + e.getMessage());
                InitSuc = SOLibraryLoader.loadLibraryWithClass(libName, JSExecutor.class);
                if (!InitSuc) break block10;
                SOLibraryLoader.log("SUC_LOAD_SO", "Reflect loadLibrary" + libName + " " + e.getMessage());
            }
        }
        if (!InitSuc && sContext != null) {
            try {
                if (SOLibraryLoader.isExist(libName, version)) {
                    boolean res = SOLibraryLoader._loadUnzipSo(libName, version);
                    if (res) {
                        SOLibraryLoader.log("SUC_LOAD_SO", "Existed Dynamic load " + libName + " success");
                        return true;
                    }
                    SOLibraryLoader.removeSoIfExit(libName, version);
                }
                if (InitSuc = SOLibraryLoader.unZipSelectedFiles(libName, version)) {
                    SOLibraryLoader.log("SUC_LOAD_SO", "unZip Dynamic load " + libName + " success");
                } else {
                    SOLibraryLoader.log("ERR_LOAD_SO", "Dynamic load " + libName + " error because unzip fail");
                }
            }
            catch (Error | Exception e2) {
                InitSuc = false;
                SOLibraryLoader.log("ERR_LOAD_SO", "Dynamic load " + libName + " " + e2.getMessage());
            }
        }
        if (!InitSuc) {
            SOLibraryLoader.log("ERR_DP_LOAD", "Try so loader " + libName);
            SoLoader.loadLibrary((String)libName);
        }
        return InitSuc;
    }

    static String _targetSoFile(String libName, int version) {
        Context context = sContext;
        if (null == context) {
            return "";
        }
        String path = "/data/data/" + context.getPackageName() + "/files";
        File f = context.getFilesDir();
        if (f != null) {
            path = f.getPath();
        }
        return path + "/lib" + libName + "bk" + version + ".so";
    }

    static void removeSoIfExit(String libName, int version) {
        String file = SOLibraryLoader._targetSoFile(libName, version);
        File a = new File(file);
        if (a.exists()) {
            a.delete();
        }
    }

    static boolean isExist(String libName, int version) {
        String file = SOLibraryLoader._targetSoFile(libName, version);
        File a = new File(file);
        return a.exists();
    }

    static boolean _loadUnzipSo(String libName, int version) {
        boolean initSuc = false;
        try {
            if (SOLibraryLoader.isExist(libName, version)) {
                System.load(SOLibraryLoader._targetSoFile(libName, version));
            }
            initSuc = true;
        }
        catch (Throwable e) {
            SOLibraryLoader.log("ERR_LOAD_SO", "_loadUnzipSo " + libName + " error:" + e.getMessage());
            initSuc = false;
        }
        return initSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean unZipSelectedFiles(String libName, int version) throws ZipException, IOException {
        String sourcePath = "lib/armeabi/lib" + libName + ".so";
        String zipPath = "";
        Context context = sContext;
        if (context == null) {
            return false;
        }
        ApplicationInfo aInfo = context.getApplicationInfo();
        if (null != aInfo) {
            zipPath = aInfo.sourceDir;
        } else {
            SOLibraryLoader.log("ERR_UNZIP_SO", "Unzip" + libName + " error:zipPath=null");
        }
        ZipFile zf = new ZipFile(zipPath);
        try {
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(sourcePath)) continue;
                InputStream in = null;
                FileOutputStream os = null;
                AbstractInterruptibleChannel channel = null;
                int total = 0;
                try {
                    int realLength;
                    SOLibraryLoader.removeSoIfExit(libName, version);
                    in = zf.getInputStream(entry);
                    os = context.openFileOutput("lib" + libName + "bk" + version + ".so", 0);
                    channel = os.getChannel();
                    byte[] buffers = new byte[1024];
                    while ((realLength = in.read(buffers)) > 0) {
                        ((FileChannel)channel).write(ByteBuffer.wrap(buffers, 0, realLength));
                        total += realLength;
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (zf != null) {
                        zf.close();
                        zf = null;
                    }
                }
                if (total > 0) {
                    boolean bl = SOLibraryLoader._loadUnzipSo(libName, version);
                    return bl;
                }
                SOLibraryLoader.log("ERR_UNZIP_SO", "Unzip" + libName + " error:total<=0");
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            SOLibraryLoader.log("ERR_UNZIP_SO", "Unzip" + libName + " error:" + e.getMessage());
        }
        finally {
            if (zf != null) {
                zf.close();
                zf = null;
            }
        }
        return false;
    }

    public static interface Logger {
        public void log(String var1, String var2);
    }
}

