/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengfeizhou.jscore;

import com.github.pengfeizhou.jscore.ArchiveException;
import com.github.pengfeizhou.jscore.Decoding;
import com.github.pengfeizhou.jscore.DecodingFactory;
import com.github.pengfeizhou.jscore.JSArray;
import com.github.pengfeizhou.jscore.JSBoolean;
import com.github.pengfeizhou.jscore.JSNull;
import com.github.pengfeizhou.jscore.JSNumber;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSString;
import com.github.pengfeizhou.jscore.JSValue;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class JSDecoder {
    private static final JSNull JS_NULL = new JSNull();
    private ByteBuffer byteBuffer;
    private byte[] __strBuf;

    public JSDecoder(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            bytes = new byte[]{78};
        }
        this.byteBuffer = ByteBuffer.wrap(bytes);
        this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    public boolean bool() throws ArchiveException {
        if (!this.isBool()) {
            throw new ArchiveException("unable to decode bool");
        }
        return this.readBool();
    }

    public boolean readBool() throws ArchiveException {
        return this.byteBuffer.get() == 1;
    }

    public String string() throws ArchiveException {
        if (!this.isString()) {
            throw new ArchiveException("unable to decode string");
        }
        return this.readString();
    }

    public String readString() throws ArchiveException {
        int len = this.byteBuffer.getInt();
        int a = len / 4096;
        int l = (a + 1) * 4096;
        if (this.__strBuf == null || this.__strBuf.length < l) {
            this.__strBuf = new byte[l];
        }
        this.byteBuffer.get(this.__strBuf, 0, len);
        try {
            return new String(this.__strBuf, 0, len, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ArchiveException("unable to decode string");
        }
    }

    public Double number() throws ArchiveException {
        if (!this.isNumber()) {
            throw new ArchiveException("unable to decode number");
        }
        return this.readNumber();
    }

    public Double readNumber() {
        return this.byteBuffer.getDouble();
    }

    public <T> T object(DecodingFactory<T> factory) throws ArchiveException {
        this.byteBuffer.rewind();
        return this.readObject(factory);
    }

    public <T> T readObject(DecodingFactory<T> factory) throws ArchiveException {
        byte b = this.byteBuffer.get();
        if (b == 78) {
            return factory.createInstance();
        }
        if (b == 79) {
            T obj = factory.createInstance();
            if (obj == null) {
                throw new ArchiveException("unable to create instance");
            }
            if (obj instanceof Decoding) {
                ((Decoding)obj).decode(this);
                return obj;
            }
            throw new ArchiveException("unable to decode class: " + obj.getClass().getSimpleName());
        }
        throw new ArchiveException("unable to read object: " + this);
    }

    public <T> T[] array(DecodingFactory<T> factory) throws ArchiveException {
        this.byteBuffer.rewind();
        return this.readArray(factory);
    }

    public <T> T[] readArray(DecodingFactory<T> factory) throws ArchiveException {
        byte b = this.byteBuffer.get();
        if (b == 78) {
            return factory.createArray(0);
        }
        if (b == 65) {
            int len = this.byteBuffer.getInt();
            T[] array = factory.createArray(len);
            for (int i = 0; i < len; ++i) {
                array[i] = this.readObject(factory);
            }
            return array;
        }
        throw new ArchiveException("unable to read array (object): " + this);
    }

    public int readKeyHash() throws ArchiveException {
        String name = this.readString();
        return name.hashCode() & 0xFFFF;
    }

    public boolean isBool() {
        this.byteBuffer.rewind();
        return this.byteBuffer.get() == 66;
    }

    public boolean isNULL() {
        this.byteBuffer.rewind();
        return this.byteBuffer.get() == 78;
    }

    public boolean isString() {
        this.byteBuffer.rewind();
        return this.byteBuffer.get() == 83;
    }

    public boolean isNumber() {
        this.byteBuffer.rewind();
        return this.byteBuffer.get() == 68;
    }

    public boolean isArray() {
        this.byteBuffer.rewind();
        return this.byteBuffer.get() == 65;
    }

    public boolean isObject() {
        this.byteBuffer.rewind();
        return this.byteBuffer.get() == 79;
    }

    public JSValue decode() throws ArchiveException {
        byte b = this.byteBuffer.get();
        switch (b) {
            case 65: {
                int len = this.byteBuffer.getInt();
                JSArray ret = new JSArray(len);
                for (int i = 0; i < len; ++i) {
                    ret.put(i, this.decode());
                }
                return ret;
            }
            case 83: {
                return new JSString(this.readString());
            }
            case 68: {
                return new JSNumber(this.readNumber());
            }
            case 66: {
                return new JSBoolean(this.readBool());
            }
            case 79: {
                JSValue propertyName;
                JSObject jsObject = new JSObject();
                while ((propertyName = this.decode()) instanceof JSString) {
                    jsObject.setProperty(((JSString)propertyName).value(), this.decode());
                }
                return jsObject;
            }
        }
        return JS_NULL;
    }
}

