package com.github.pengfeizhou.jscore;

import android.content.Context;
import android.content.pm.ApplicationInfo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

import com.facebook.soloader.SoLoader;

/**
 * Created by pengfei on 2017/6/21.
 */

public class SOLibraryLoader {
    public static Context sContext = null;
    public static Logger sLogger = null;

    public interface Logger {
        void log(String tag, String message);
    }

    private static void log(String tag, String message) {
        if (sLogger != null) {
            sLogger.log(tag, message);
        }
    }

    public static boolean loadLibraryWithClass(String loadName, Class className) {
        boolean isLoad = false;
        try {
            ClassLoader classLoader = className.getClassLoader();
            Class runtime = Runtime.getRuntime().getClass();
            Class[] args = new Class[2];
            int version = android.os.Build.VERSION.SDK_INT;
            String functionName = "loadLibrary";
            if (version > 24) {
                args[0] = ClassLoader.class;
                args[1] = String.class;
                functionName = "loadLibrary0";
                Method loadMethod = runtime.getDeclaredMethod(functionName, args);
                loadMethod.setAccessible(true);
                loadMethod.invoke(Runtime.getRuntime(), classLoader, loadName);
            } else {
                args[0] = String.class;
                args[1] = ClassLoader.class;
                Method loadMethod = runtime.getDeclaredMethod(functionName, args);
                loadMethod.setAccessible(true);
                loadMethod.invoke(Runtime.getRuntime(), loadName, classLoader);
            }
            isLoad = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return isLoad;
    }

    public static boolean loadSOLibrary(String libName, int version) {
        boolean InitSuc;
        /**
         * Load library with {@link System#loadLibrary(String)}
         */
        try {
            System.loadLibrary(libName);
            InitSuc = true;
        } catch (Exception | Error e) {
            log("ERR_LOAD_SO", "System load" + libName + " " + e.getMessage());
            InitSuc = loadLibraryWithClass(libName, JSExecutor.class);
            if (InitSuc) {
                log("SUC_LOAD_SO", "Reflect loadLibrary" + libName + " " + e.getMessage());
            }
        }
        if (!InitSuc && sContext != null) {
            try {
                //File extracted from apk already exists.
                if (isExist(libName, version)) {
                    boolean res = _loadUnzipSo(libName, version);
                    if (res) {
                        log("SUC_LOAD_SO", "Existed Dynamic load " + libName + " success");
                        return true;
                    } else {
                        //Delete the corrupt so library, and extract it again.
                        removeSoIfExit(libName, version);
                    }
                }
                InitSuc = unZipSelectedFiles(libName, version);
                if (InitSuc) {
                    log("SUC_LOAD_SO", "unZip Dynamic load " + libName + " success");
                }else{
                    log("ERR_LOAD_SO", "Dynamic load " + libName + " error because unzip fail");
                }
            } catch (Exception | Error e2) {
                InitSuc = false;
                log("ERR_LOAD_SO", "Dynamic load " + libName + " " + e2.getMessage());
            }
        }
        if(!InitSuc){
           log("ERR_DP_LOAD", "Try so loader " + libName);
           SoLoader.loadLibrary(libName);
        }
        return InitSuc;
    }

    /**
     * Concatenate the path of the so library, including directory.
     *
     * @param libName the raw name of the lib
     * @param version the version of the so library
     * @return the path of the so library
     */

    static String _targetSoFile(String libName, int version) {
        Context context = sContext;
        if (null == context) {
            return "";
        }

        String path = "/data/data/" + context.getPackageName() + "/files";

        File f = context.getFilesDir();
        if (f != null) {
            path = f.getPath();
        }
        return path + "/lib" + libName + "bk" + version + ".so";
    }

    /**
     * Remove the so library if it had been extracted.
     *
     * @param libName
     * @param version
     */
    static void removeSoIfExit(String libName, int version) {

        String file = _targetSoFile(libName, version);
        File a = new File(file);
        if (a.exists()) {
            a.delete();
        }

    }

    /**
     * Tell whether the so is extracted.
     */
    static boolean isExist(String libName, int version) {

        String file = _targetSoFile(libName, version);
        File a = new File(file);
        return a.exists();

    }

    /**
     * Load .so library
     */
    static boolean _loadUnzipSo(String libName, int version) {
        boolean initSuc = false;
        try {
            if (isExist(libName, version)) {
                System.load(_targetSoFile(libName, version));
            }
            initSuc = true;
        } catch (Throwable e) {
            log("ERR_LOAD_SO", "_loadUnzipSo " + libName + " error:" + e.getMessage());
            initSuc = false;
        }
        return initSuc;
    }

    static boolean unZipSelectedFiles(String libName, int version) throws ZipException, IOException {
        String sourcePath = "lib/armeabi/lib" + libName + ".so";

        String zipPath = "";
        Context context = sContext;
        if (context == null) {
            return false;
        }

        ApplicationInfo aInfo = context.getApplicationInfo();
        if (null != aInfo) {
            zipPath = aInfo.sourceDir;
        }else{
            log("ERR_UNZIP_SO", "Unzip" + libName + " error:zipPath=null");
        }

        ZipFile zf;
        zf = new ZipFile(zipPath);
        try {

            for (Enumeration<?> entries = zf.entries(); entries.hasMoreElements(); ) {
                ZipEntry entry = ((ZipEntry) entries.nextElement());
                if (entry.getName().startsWith(sourcePath)) {

                    InputStream in = null;
                    FileOutputStream os = null;
                    FileChannel channel = null;
                    int total = 0;
                    try {

                        //Make sure the old library is deleted.
                        removeSoIfExit(libName, version);

                        //Copy file
                        in = zf.getInputStream(entry);
                        os = context.openFileOutput("lib" + libName + "bk" + version + ".so",
                                Context.MODE_PRIVATE);
                        channel = os.getChannel();

                        byte[] buffers = new byte[1024];
                        int realLength;

                        while ((realLength = in.read(buffers)) > 0) {
                            //os.write(buffers);
                            channel.write(ByteBuffer.wrap(buffers, 0, realLength));
                            total += realLength;

                        }
                    } finally {
                        if (in != null) {
                            try {
                                in.close();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        if (channel != null) {
                            try {
                                channel.close();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        if (os != null) {
                            try {
                                os.close();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        if (zf != null) {
                            zf.close();
                            zf = null;
                        }
                    }

                    if (total > 0) {
                        return _loadUnzipSo(libName, version);
                    } else {
                        log("ERR_UNZIP_SO", "Unzip" + libName + " error:total<=0");
                        return false;
                    }
                }
            }
        } catch (java.io.IOException e) {
            log("ERR_UNZIP_SO", "Unzip" + libName + " error:" + e.getMessage());
        } finally {

            if (zf != null) {
                zf.close();
                zf = null;
            }
        }
        return false;
    }


}
