package com.github.pengfeizhou.jscore;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


/**
 * Created by pengfei on 2017/1/18.
 */
public class JSONBuilder {

    private final JSONObject jsonObject;

    public JSONBuilder() {
        this.jsonObject = new JSONObject();
    }

    public JSONBuilder(JSONObject jsonObject){
        this.jsonObject = jsonObject;
    }
    public JSONBuilder put(String key, Object val) {
        try {
            if (val == null) {
                jsonObject.put(key, JSONObject.NULL);
            } else if (val instanceof Encoding) {
                jsonObject.put(key, ((Encoding) val).encode());
            } else if (val instanceof Encoding[]) {
                JSONArray jsonArray = new JSONArray();
                for (Encoding object : (Encoding[]) val) {
                    jsonArray.put(object.encode());
                }
                jsonObject.put(key, jsonArray);
            } else {
                jsonObject.put(key, val);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public String toString() {
        return jsonObject.toString();
    }

    public JSONObject toJSONObject() {
        return jsonObject;
    }

    public JavaValue toValue() {
        return new JavaValue(jsonObject);
    }
}