/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.webp.decode;

import android.content.Context;
import com.github.penfeizhou.animation.io.Reader;
import com.github.penfeizhou.animation.io.StreamReader;
import com.github.penfeizhou.animation.webp.decode.ALPHChunk;
import com.github.penfeizhou.animation.webp.decode.ANIMChunk;
import com.github.penfeizhou.animation.webp.decode.ANMFChunk;
import com.github.penfeizhou.animation.webp.decode.BaseChunk;
import com.github.penfeizhou.animation.webp.decode.EXIFChunk;
import com.github.penfeizhou.animation.webp.decode.ICCPChunk;
import com.github.penfeizhou.animation.webp.decode.VP8Chunk;
import com.github.penfeizhou.animation.webp.decode.VP8LChunk;
import com.github.penfeizhou.animation.webp.decode.VP8XChunk;
import com.github.penfeizhou.animation.webp.decode.XMPChunk;
import com.github.penfeizhou.animation.webp.io.WebPReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class WebPParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAWebP(String filePath) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            boolean bl = WebPParser.isAWebP((Reader)new StreamReader((InputStream)inputStream));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAWebP(Context context, String assetPath) {
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(assetPath);
            boolean bl = WebPParser.isAWebP((Reader)new StreamReader(inputStream));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAWebP(Context context, int resId) {
        InputStream inputStream = null;
        try {
            inputStream = context.getResources().openRawResource(resId);
            boolean bl = WebPParser.isAWebP((Reader)new StreamReader(inputStream));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isAWebP(Reader in) {
        block5: {
            WebPReader reader = in instanceof WebPReader ? (WebPReader)in : new WebPReader(in);
            try {
                if (!reader.matchFourCC("RIFF")) {
                    return false;
                }
                reader.skip(4L);
                if (!reader.matchFourCC("WEBP")) {
                    return false;
                }
                while (reader.available() > 0) {
                    BaseChunk chunk = WebPParser.parseChunk(reader);
                    if (!(chunk instanceof VP8XChunk)) continue;
                    return ((VP8XChunk)chunk).animation();
                }
            }
            catch (IOException e) {
                if (e instanceof FormatException) break block5;
                e.printStackTrace();
            }
        }
        return false;
    }

    public static List<BaseChunk> parse(WebPReader reader) throws IOException {
        if (!reader.matchFourCC("RIFF")) {
            throw new FormatException();
        }
        reader.skip(4L);
        if (!reader.matchFourCC("WEBP")) {
            throw new FormatException();
        }
        ArrayList<BaseChunk> chunks = new ArrayList<BaseChunk>();
        while (reader.available() > 0) {
            chunks.add(WebPParser.parseChunk(reader));
        }
        return chunks;
    }

    static BaseChunk parseChunk(WebPReader reader) throws IOException {
        int offset = reader.position();
        int chunkFourCC = reader.getFourCC();
        int chunkSize = reader.getUInt32();
        BaseChunk chunk = VP8XChunk.ID == chunkFourCC ? new VP8XChunk() : (ANIMChunk.ID == chunkFourCC ? new ANIMChunk() : (ANMFChunk.ID == chunkFourCC ? new ANMFChunk() : (ALPHChunk.ID == chunkFourCC ? new ALPHChunk() : (VP8Chunk.ID == chunkFourCC ? new VP8Chunk() : (VP8LChunk.ID == chunkFourCC ? new VP8LChunk() : (ICCPChunk.ID == chunkFourCC ? new ICCPChunk() : (XMPChunk.ID == chunkFourCC ? new XMPChunk() : (EXIFChunk.ID == chunkFourCC ? new EXIFChunk() : new BaseChunk()))))))));
        chunk.chunkFourCC = chunkFourCC;
        chunk.payloadSize = chunkSize;
        chunk.offset = offset;
        chunk.parse(reader);
        return chunk;
    }

    static class FormatException
    extends IOException {
        FormatException() {
            super("WebP Format error");
        }
    }
}

