/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.apng.decode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.penfeizhou.animation.apng.decode.Chunk;
import com.github.penfeizhou.animation.apng.decode.FCTLChunk;
import com.github.penfeizhou.animation.apng.decode.FDATChunk;
import com.github.penfeizhou.animation.apng.decode.IDATChunk;
import com.github.penfeizhou.animation.apng.decode.IENDChunk;
import com.github.penfeizhou.animation.apng.decode.IHDRChunk;
import com.github.penfeizhou.animation.apng.io.APNGReader;
import com.github.penfeizhou.animation.apng.io.APNGWriter;
import com.github.penfeizhou.animation.decode.Frame;
import com.github.penfeizhou.animation.io.Reader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

public class APNGFrame
extends Frame<APNGReader, APNGWriter> {
    public final byte blend_op;
    public final byte dispose_op;
    byte[] ihdrData;
    List<Chunk> imageChunks = new ArrayList<Chunk>();
    List<Chunk> prefixChunks = new ArrayList<Chunk>();
    private static final byte[] sPNGSignatures = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] sPNGEndChunk = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    private static ThreadLocal<CRC32> sCRC32 = new ThreadLocal();

    private CRC32 getCRC32() {
        CRC32 crc32 = sCRC32.get();
        if (crc32 == null) {
            crc32 = new CRC32();
            sCRC32.set(crc32);
        }
        return crc32;
    }

    public APNGFrame(APNGReader reader, FCTLChunk fctlChunk) {
        super((Reader)reader);
        this.blend_op = fctlChunk.blend_op;
        this.dispose_op = fctlChunk.dispose_op;
        this.frameDuration = fctlChunk.delay_num * 1000 / (fctlChunk.delay_den == 0 ? 100 : (int)fctlChunk.delay_den);
        if (this.frameDuration < 10) {
            this.frameDuration = 100;
        }
        this.frameWidth = fctlChunk.width;
        this.frameHeight = fctlChunk.height;
        this.frameX = fctlChunk.x_offset;
        this.frameY = fctlChunk.y_offset;
    }

    private int encode(APNGWriter apngWriter) throws IOException {
        int fileSize = 33;
        for (Chunk chunk : this.prefixChunks) {
            fileSize += chunk.length + 12;
        }
        for (Chunk chunk : this.imageChunks) {
            if (chunk instanceof IDATChunk) {
                fileSize += chunk.length + 12;
                continue;
            }
            if (!(chunk instanceof FDATChunk)) continue;
            fileSize += chunk.length + 8;
        }
        apngWriter.reset(fileSize += sPNGEndChunk.length);
        apngWriter.putBytes(sPNGSignatures);
        apngWriter.writeInt(13);
        int start = apngWriter.position();
        apngWriter.writeFourCC(IHDRChunk.ID);
        apngWriter.writeInt(this.frameWidth);
        apngWriter.writeInt(this.frameHeight);
        apngWriter.putBytes(this.ihdrData);
        CRC32 crc32 = this.getCRC32();
        crc32.reset();
        crc32.update(apngWriter.toByteArray(), start, 17);
        apngWriter.writeInt((int)crc32.getValue());
        for (Chunk chunk : this.prefixChunks) {
            if (chunk instanceof IENDChunk) continue;
            ((APNGReader)this.reader).reset();
            ((APNGReader)this.reader).skip(chunk.offset);
            ((APNGReader)this.reader).read(apngWriter.toByteArray(), apngWriter.position(), chunk.length + 12);
            apngWriter.skip(chunk.length + 12);
        }
        for (Chunk chunk : this.imageChunks) {
            if (chunk instanceof IDATChunk) {
                ((APNGReader)this.reader).reset();
                ((APNGReader)this.reader).skip(chunk.offset);
                ((APNGReader)this.reader).read(apngWriter.toByteArray(), apngWriter.position(), chunk.length + 12);
                apngWriter.skip(chunk.length + 12);
                continue;
            }
            if (!(chunk instanceof FDATChunk)) continue;
            apngWriter.writeInt(chunk.length - 4);
            start = apngWriter.position();
            apngWriter.writeFourCC(IDATChunk.ID);
            ((APNGReader)this.reader).reset();
            ((APNGReader)this.reader).skip(chunk.offset + 4 + 4 + 4);
            ((APNGReader)this.reader).read(apngWriter.toByteArray(), apngWriter.position(), chunk.length - 4);
            apngWriter.skip(chunk.length - 4);
            crc32.reset();
            crc32.update(apngWriter.toByteArray(), start, chunk.length);
            apngWriter.writeInt((int)crc32.getValue());
        }
        apngWriter.putBytes(sPNGEndChunk);
        return fileSize;
    }

    public Bitmap draw(Canvas canvas, Paint paint, int sampleSize, Bitmap reusedBitmap, APNGWriter writer) {
        try {
            int length = this.encode(writer);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = false;
            options.inSampleSize = sampleSize;
            options.inMutable = true;
            options.inBitmap = reusedBitmap;
            byte[] bytes = writer.toByteArray();
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)length, (BitmapFactory.Options)options);
            assert (bitmap != null);
            canvas.drawBitmap(bitmap, (float)this.frameX / (float)sampleSize, (float)this.frameY / (float)sampleSize, paint);
            return bitmap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

