/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import com.pedro.common.ExtensionsKt;
import com.pedro.common.frame.MediaFrame;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J@\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2(\u0010\u000b\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\fH\u0096@\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/pedro/rtsp/rtp/packets/AacPacket;", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "<init>", "()V", "setAudioInfo", "", "sampleRate", "", "createAndSendPacket", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rtsp_release"})
public final class AacPacket
extends BasePacket {
    public AacPacket() {
        super(0L, 96 + RtpConstants.INSTANCE.getTrackAudio());
        this.setChannelIdentifier(RtpConstants.INSTANCE.getTrackAudio());
    }

    public final void setAudioInfo(int sampleRate) {
        this.setClock(sampleRate);
    }

    @Override
    @Nullable
    public Object createAndSendPacket(@NotNull MediaFrame mediaFrame, @NotNull Function2<? super List<RtpFrame>, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        int size;
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)mediaFrame.getData(), (MediaFrame.Info)mediaFrame.getInfo());
        int length = fixedBuffer.remaining();
        int maxPayload = this.getMaxPacketSize() - 16;
        long ts = mediaFrame.getInfo().getTimestamp() * (long)1000;
        List frames = new ArrayList();
        for (int sum = 0; sum < length; sum += size) {
            size = length - sum < maxPayload ? length - sum : maxPayload;
            byte[] buffer = this.getBuffer(size + 12 + 4);
            fixedBuffer.get(buffer, 16, size);
            this.markPacket(buffer);
            long rtpTs = this.updateTimeStamp(buffer, ts);
            buffer[12] = 0;
            buffer[13] = 16;
            buffer[14] = (byte)(size >> 5);
            buffer[15] = (byte)(size << 3);
            buffer[15] = (byte)(buffer[15] & 0xFFFFFFF8);
            buffer[15] = (byte)(buffer[15] | 0);
            this.updateSeq(buffer);
            RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, 12 + size + 4, this.getChannelIdentifier());
            frames.add(rtpFrame);
        }
        if (!((Collection)frames).isEmpty()) {
            Object object = callback.invoke((Object)frames, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }
}

