/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import com.pedro.common.socket.TcpStreamSocket;
import com.pedro.common.socket.UdpStreamSocket;
import com.pedro.rtsp.rtp.sockets.RtpSocketTcp;
import com.pedro.rtsp.rtp.sockets.RtpSocketUdp;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtpFrame;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a6@\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u00a6@\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/pedro/rtsp/rtp/sockets/BaseRtpSocket;", "", "<init>", "()V", "setSocket", "", "socket", "Lcom/pedro/common/socket/TcpStreamSocket;", "(Lcom/pedro/common/socket/TcpStreamSocket;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendFrame", "rtpFrame", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "(Lcom/pedro/rtsp/rtsp/RtpFrame;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "flush", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "Companion", "rtsp_release"})
public abstract class BaseRtpSocket {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public abstract Object setSocket(@NotNull TcpStreamSocket var1, @NotNull Continuation<? super Unit> var2) throws IOException;

    @Nullable
    public abstract Object sendFrame(@NotNull RtpFrame var1, @NotNull Continuation<? super Unit> var2) throws IOException;

    @Nullable
    public abstract Object flush(@NotNull Continuation<? super Unit> var1);

    @Nullable
    public abstract Object close(@NotNull Continuation<? super Unit> var1);

    @JvmStatic
    @NotNull
    public static final BaseRtpSocket getInstance(@NotNull Protocol protocol, @NotNull String host, int videoSourcePort, int audioSourcePort, int videoServerPort, int audioServerPort) {
        return Companion.getInstance(protocol, host, videoSourcePort, audioSourcePort, videoServerPort, audioServerPort);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/pedro/rtsp/rtp/sockets/BaseRtpSocket$Companion;", "", "<init>", "()V", "getInstance", "Lcom/pedro/rtsp/rtp/sockets/BaseRtpSocket;", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "host", "", "videoSourcePort", "", "audioSourcePort", "videoServerPort", "audioServerPort", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BaseRtpSocket getInstance(@NotNull Protocol protocol, @NotNull String host, int videoSourcePort, int audioSourcePort, int videoServerPort, int audioServerPort) {
            BaseRtpSocket baseRtpSocket;
            Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            if (protocol == Protocol.TCP) {
                baseRtpSocket = new RtpSocketTcp();
            } else {
                UdpStreamSocket videoSocket = new UdpStreamSocket(host, videoServerPort, Integer.valueOf(videoSourcePort), Integer.valueOf(1500), false, 16, null);
                UdpStreamSocket audioSocket = new UdpStreamSocket(host, audioServerPort, Integer.valueOf(audioSourcePort), Integer.valueOf(1500), false, 16, null);
                baseRtpSocket = new RtpSocketUdp(videoSocket, audioSocket);
            }
            return baseRtpSocket;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

