/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import com.pedro.common.ExtensionsKt;
import com.pedro.common.av1.Av1Parser;
import com.pedro.common.av1.Obu;
import com.pedro.common.av1.ObuType;
import com.pedro.common.frame.MediaFrame;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JC\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2(\u0010\t\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcom/pedro/rtsp/rtp/packets/Av1Packet;", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "()V", "parser", "Lcom/pedro/common/av1/Av1Parser;", "createAndSendPacket", "", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateAv1AggregationHeader", "", "isKeyFrame", "", "isFirstPacket", "isLastPacket", "numObu", "", "reset", "rtsp_release"})
@SourceDebugExtension(value={"SMAP\nAv1Packet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1Packet.kt\ncom/pedro/rtsp/rtp/packets/Av1Packet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1872#2,3:116\n*S KotlinDebug\n*F\n+ 1 Av1Packet.kt\ncom/pedro/rtsp/rtp/packets/Av1Packet\n*L\n65#1:116,3\n*E\n"})
public final class Av1Packet
extends BasePacket {
    @NotNull
    private final Av1Parser parser = new Av1Parser();

    public Av1Packet() {
        super(90000L, 96 + RtpConstants.INSTANCE.getTrackVideo());
        this.setChannelIdentifier(RtpConstants.INSTANCE.getTrackVideo());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object createAndSendPacket(@NotNull MediaFrame mediaFrame2, @NotNull Function2<? super List<RtpFrame>, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)mediaFrame2.getData(), (MediaFrame.Info)mediaFrame2.getInfo());
        if (this.parser.getObuType(fixedBuffer.get(0)) == ObuType.TEMPORAL_DELIMITER) {
            fixedBuffer.position(2);
            ByteBuffer byteBuffer = fixedBuffer.slice();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"fixedBuffer.slice()");
            fixedBuffer = byteBuffer;
        }
        ByteBuffer byteBuffer = fixedBuffer.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"fixedBuffer.duplicate()");
        List obuList = this.parser.getObus(ExtensionsKt.toByteArray((ByteBuffer)byteBuffer));
        long ts = mediaFrame2.getInfo().getTimestamp() * 1000L;
        if (obuList.isEmpty()) {
            return Unit.INSTANCE;
        }
        byte[] data = null;
        data = new byte[]{};
        Iterable $this$forEachIndexed$iv = obuList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void obu;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Obu obu2 = (Obu)item$iv;
            int index = n;
            boolean bl = false;
            byte[] obuData = obu.getFullData();
            data = index == obuList.size() - 1 ? ArraysKt.plus((byte[])data, (byte[])obuData) : ArraysKt.plus((byte[])data, (byte[])ArraysKt.plus((byte[])this.parser.writeLeb128((long)obuData.length), (byte[])obuData));
        }
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(data);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"wrap(data)");
        fixedBuffer = byteBuffer2;
        int size = fixedBuffer.remaining();
        int sum = 0;
        List frames = new ArrayList();
        while (sum < size) {
            boolean isFirstPacket = sum == 0;
            boolean isLastPacket = false;
            int length = size - sum > this.getMaxPacketSize() - 12 - 1 ? this.getMaxPacketSize() - 12 - 1 : fixedBuffer.remaining();
            byte[] buffer = this.getBuffer(length + 12 + 1);
            long rtpTs = this.updateTimeStamp(buffer, ts);
            fixedBuffer.get(buffer, 13, length);
            if ((sum += length) >= size) {
                isLastPacket = true;
                this.markPacket(buffer);
            }
            int oSize = isFirstPacket ? obuList.size() : 1;
            buffer[12] = this.generateAv1AggregationHeader(mediaFrame2.getInfo().isKeyFrame(), isFirstPacket, isLastPacket, oSize);
            this.updateSeq(buffer);
            RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, buffer.length, this.getChannelIdentifier());
            frames.add(rtpFrame);
        }
        if (!((Collection)frames).isEmpty()) {
            Object object = callback.invoke((Object)frames, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void reset() {
        super.reset();
    }

    private final byte generateAv1AggregationHeader(boolean isKeyFrame, boolean isFirstPacket, boolean isLastPacket, int numObu) {
        int z = isFirstPacket ? 0 : 1;
        int y = isLastPacket ? 0 : 1;
        int w = numObu;
        int n = isKeyFrame && isFirstPacket ? 1 : 0;
        return (byte)(z << 7 | y << 6 | w << 4 | n << 3 | 0);
    }
}

