/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import com.pedro.rtsp.utils.RtpConstants;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003JE\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\u0006\u0010 \u001a\u00020\u001dJ\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/pedro/rtsp/rtsp/RtpFrame;", "", "buffer", "", "timeStamp", "", "length", "", "rtpPort", "rtcpPort", "channelIdentifier", "([BJIIII)V", "getBuffer", "()[B", "getChannelIdentifier", "()I", "getLength", "getRtcpPort", "getRtpPort", "getTimeStamp", "()J", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "isVideoFrame", "toString", "", "rtsp_release"})
public final class RtpFrame {
    @NotNull
    private final byte[] buffer;
    private final long timeStamp;
    private final int length;
    private final int rtpPort;
    private final int rtcpPort;
    private final int channelIdentifier;

    public RtpFrame(@NotNull byte[] buffer, long timeStamp, int length, int rtpPort, int rtcpPort, int channelIdentifier) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.timeStamp = timeStamp;
        this.length = length;
        this.rtpPort = rtpPort;
        this.rtcpPort = rtcpPort;
        this.channelIdentifier = channelIdentifier;
    }

    @NotNull
    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getRtpPort() {
        return this.rtpPort;
    }

    public final int getRtcpPort() {
        return this.rtcpPort;
    }

    public final int getChannelIdentifier() {
        return this.channelIdentifier;
    }

    public final boolean isVideoFrame() {
        return this.channelIdentifier == RtpConstants.INSTANCE.getTrackVideo();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.pedro.rtsp.rtsp.RtpFrame");
        RtpFrame cfr_ignored_0 = (RtpFrame)other;
        if (!Arrays.equals(this.buffer, ((RtpFrame)other).buffer)) {
            return false;
        }
        if (this.timeStamp != ((RtpFrame)other).timeStamp) {
            return false;
        }
        if (this.length != ((RtpFrame)other).length) {
            return false;
        }
        if (this.rtpPort != ((RtpFrame)other).rtpPort) {
            return false;
        }
        if (this.rtcpPort != ((RtpFrame)other).rtcpPort) {
            return false;
        }
        return this.channelIdentifier == ((RtpFrame)other).channelIdentifier;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.buffer);
        result = 31 * result + Long.hashCode(this.timeStamp);
        result = 31 * result + this.length;
        result = 31 * result + this.rtpPort;
        result = 31 * result + this.rtcpPort;
        result = 31 * result + this.channelIdentifier;
        return result;
    }

    @NotNull
    public final byte[] component1() {
        return this.buffer;
    }

    public final long component2() {
        return this.timeStamp;
    }

    public final int component3() {
        return this.length;
    }

    public final int component4() {
        return this.rtpPort;
    }

    public final int component5() {
        return this.rtcpPort;
    }

    public final int component6() {
        return this.channelIdentifier;
    }

    @NotNull
    public final RtpFrame copy(@NotNull byte[] buffer, long timeStamp, int length, int rtpPort, int rtcpPort, int channelIdentifier) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return new RtpFrame(buffer, timeStamp, length, rtpPort, rtcpPort, channelIdentifier);
    }

    public static /* synthetic */ RtpFrame copy$default(RtpFrame rtpFrame, byte[] byArray, long l, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            byArray = rtpFrame.buffer;
        }
        if ((n5 & 2) != 0) {
            l = rtpFrame.timeStamp;
        }
        if ((n5 & 4) != 0) {
            n = rtpFrame.length;
        }
        if ((n5 & 8) != 0) {
            n2 = rtpFrame.rtpPort;
        }
        if ((n5 & 0x10) != 0) {
            n3 = rtpFrame.rtcpPort;
        }
        if ((n5 & 0x20) != 0) {
            n4 = rtpFrame.channelIdentifier;
        }
        return rtpFrame.copy(byArray, l, n, n2, n3, n4);
    }

    @NotNull
    public String toString() {
        return "RtpFrame(buffer=" + Arrays.toString(this.buffer) + ", timeStamp=" + this.timeStamp + ", length=" + this.length + ", rtpPort=" + this.rtpPort + ", rtcpPort=" + this.rtcpPort + ", channelIdentifier=" + this.channelIdentifier + ")";
    }
}

