/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp.commands;

import android.util.Base64;
import android.util.Log;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.commands.Command;
import com.pedro.rtsp.rtsp.commands.Method;
import com.pedro.rtsp.rtsp.commands.SdpBody;
import com.pedro.rtsp.utils.AuthUtil;
import com.pedro.rtsp.utils.RtpConstants;
import com.pedro.rtsp.utils.UtilsKt;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 h2\u00020\u0001:\u0001hB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010C\u001a\u00020\u0012H\u0002J\u0006\u0010D\u001a\u00020EJ\u0006\u0010F\u001a\u00020\u0012J\u000e\u0010G\u001a\u00020\u00122\u0006\u0010H\u001a\u00020\u0012J\u0010\u0010I\u001a\u00020\u00122\u0006\u0010H\u001a\u00020\u0012H\u0002J\b\u0010J\u001a\u00020\u0012H\u0002J\u0006\u0010K\u001a\u00020\u0012J\u0006\u0010L\u001a\u00020\u0012J\u0006\u0010M\u001a\u00020\u0012J\u0006\u0010N\u001a\u00020\u0012J\u0006\u0010O\u001a\u00020\u0012J\u0006\u0010P\u001a\u00020\u0012J\u0006\u0010Q\u001a\u00020\u0012J\u0010\u0010R\u001a\u00020\u00122\u0006\u0010S\u001a\u00020\u0010H\u0016J\u0006\u0010T\u001a\u00020\u0012J\u0012\u0010U\u001a\u00020\u00122\b\u0010V\u001a\u0004\u0018\u00010\u001fH\u0002J\u0014\u0010W\u001a\u0004\u0018\u00010\u001f2\b\u0010X\u001a\u0004\u0018\u00010YH\u0002J\u001a\u0010Z\u001a\u00020[2\b\u0010\\\u001a\u0004\u0018\u00010]2\b\b\u0002\u0010^\u001a\u00020_J\u0010\u0010`\u001a\u00020E2\u0006\u0010a\u001a\u00020\u0012H\u0002J\u0010\u0010b\u001a\u00020E2\u0006\u0010a\u001a\u00020\u0012H\u0002J\u0006\u0010c\u001a\u00020EJ\u0016\u0010d\u001a\u00020E2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\bJ\u001a\u0010e\u001a\u00020E2\b\u00106\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012J\"\u0010f\u001a\u00020E2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012J$\u0010g\u001a\u00020E2\b\u00100\u001a\u0004\u0018\u00010Y2\b\u0010 \u001a\u0004\u0018\u00010Y2\b\u0010?\u001a\u0004\u0018\u00010YR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\fR\"\u0010\u0018\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\"\u0010\u001a\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u001e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0015R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001e\"\u0004\b-\u0010.R\u0010\u0010/\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00100\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\"R\u0014\u00102\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0015R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00106\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0015R\u0011\u00108\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0006R\u001a\u0010:\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\n\"\u0004\b<\u0010\fR\u0011\u0010=\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0006R\"\u0010?\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\"R\u0014\u0010A\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0015\u00a8\u0006i"}, d2={"Lcom/pedro/rtsp/rtsp/commands/CommandsManager;", "", "()V", "audioClientPorts", "", "getAudioClientPorts", "()[I", "audioDisabled", "", "getAudioDisabled", "()Z", "setAudioDisabled", "(Z)V", "audioServerPorts", "getAudioServerPorts", "cSeq", "", "<set-?>", "", "host", "getHost", "()Ljava/lang/String;", "isStereo", "setStereo", "password", "getPassword", "path", "getPath", "port", "getPort", "()I", "", "pps", "getPps", "()[B", "ppsString", "getPpsString", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "getProtocol", "()Lcom/pedro/rtsp/rtsp/Protocol;", "setProtocol", "(Lcom/pedro/rtsp/rtsp/Protocol;)V", "sampleRate", "getSampleRate", "setSampleRate", "(I)V", "sessionId", "sps", "getSps", "spsString", "getSpsString", "timeStamp", "", "user", "getUser", "videoClientPorts", "getVideoClientPorts", "videoDisabled", "getVideoDisabled", "setVideoDisabled", "videoServerPorts", "getVideoServerPorts", "vps", "getVps", "vpsString", "getVpsString", "addHeaders", "clear", "", "createAnnounce", "createAnnounceWithAuth", "authResponse", "createAuth", "createBody", "createGetParameter", "createOptions", "createPause", "createPlay", "createRecord", "createRedirect", "createSetParameter", "createSetup", "track", "createTeardown", "encodeToString", "bytes", "getData", "byteBuffer", "Ljava/nio/ByteBuffer;", "getResponse", "Lcom/pedro/rtsp/rtsp/commands/Command;", "reader", "Ljava/io/BufferedReader;", "method", "Lcom/pedro/rtsp/rtsp/commands/Method;", "getServerPorts", "response", "getSession", "retryClear", "setAudioInfo", "setAuth", "setUrl", "setVideoInfo", "Companion", "rtsp_release"})
public class CommandsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String host;
    private int port;
    @Nullable
    private String path;
    @Nullable
    private byte[] sps;
    @Nullable
    private byte[] pps;
    private int cSeq;
    @Nullable
    private String sessionId;
    private final long timeStamp;
    private int sampleRate = 32000;
    private boolean isStereo = true;
    @NotNull
    private Protocol protocol = Protocol.TCP;
    private boolean videoDisabled;
    private boolean audioDisabled;
    @NotNull
    private final int[] audioClientPorts;
    @NotNull
    private final int[] videoClientPorts;
    @NotNull
    private final int[] audioServerPorts;
    @NotNull
    private final int[] videoServerPorts;
    @Nullable
    private byte[] vps;
    @Nullable
    private String user;
    @Nullable
    private String password;
    @NotNull
    private static final String TAG = "CommandsManager";
    @Nullable
    private static String authorization;

    public CommandsManager() {
        int[] nArray = new int[]{5000, 5001};
        this.audioClientPorts = nArray;
        nArray = new int[]{5002, 5003};
        this.videoClientPorts = nArray;
        nArray = new int[]{5004, 5005};
        this.audioServerPorts = nArray;
        nArray = new int[]{5006, 5007};
        this.videoServerPorts = nArray;
        long uptime = System.currentTimeMillis();
        this.timeStamp = uptime / (long)1000 << 32 & (uptime - uptime / (long)1000 * (long)1000 >> 32) / (long)1000;
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final byte[] getSps() {
        return this.sps;
    }

    @Nullable
    public final byte[] getPps() {
        return this.pps;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public final boolean isStereo() {
        return this.isStereo;
    }

    public final void setStereo(boolean bl) {
        this.isStereo = bl;
    }

    @NotNull
    public final Protocol getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"<set-?>");
        this.protocol = protocol;
    }

    public final boolean getVideoDisabled() {
        return this.videoDisabled;
    }

    public final void setVideoDisabled(boolean bl) {
        this.videoDisabled = bl;
    }

    public final boolean getAudioDisabled() {
        return this.audioDisabled;
    }

    public final void setAudioDisabled(boolean bl) {
        this.audioDisabled = bl;
    }

    @NotNull
    public final int[] getAudioClientPorts() {
        return this.audioClientPorts;
    }

    @NotNull
    public final int[] getVideoClientPorts() {
        return this.videoClientPorts;
    }

    @NotNull
    public final int[] getAudioServerPorts() {
        return this.audioServerPorts;
    }

    @NotNull
    public final int[] getVideoServerPorts() {
        return this.videoServerPorts;
    }

    @Nullable
    public final byte[] getVps() {
        return this.vps;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] getData(ByteBuffer byteBuffer) {
        byte[] byArray;
        if (byteBuffer != null) {
            void var3_3;
            int startCodeSize = UtilsKt.getVideoStartCodeSize(byteBuffer);
            byte[] bytes = new byte[byteBuffer.capacity() - startCodeSize];
            byteBuffer.position(startCodeSize);
            byteBuffer.get(bytes, 0, bytes.length);
            byArray = var3_3;
        } else {
            byArray = null;
        }
        return byArray;
    }

    private final String encodeToString(byte[] bytes) {
        byte[] byArray = bytes;
        if (byArray != null) {
            byte[] byArray2 = byArray;
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray2;
            boolean bl3 = false;
            String string = Base64.encodeToString((byte[])it, (int)0, (int)it.length, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(it, 0, it.size, Base64.NO_WRAP)");
            return string;
        }
        return "";
    }

    public final void setVideoInfo(@Nullable ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        this.sps = this.getData(sps);
        this.pps = this.getData(pps);
        this.vps = this.getData(vps);
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.isStereo = isStereo;
        this.sampleRate = sampleRate;
    }

    public final void setAuth(@Nullable String user, @Nullable String password) {
        this.user = user;
        this.password = password;
    }

    public final void setUrl(@Nullable String host, int port, @Nullable String path) {
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public final void clear() {
        this.sps = null;
        this.pps = null;
        this.vps = null;
        this.retryClear();
    }

    public final void retryClear() {
        this.cSeq = 0;
        this.sessionId = null;
    }

    private final String getSpsString() {
        return this.encodeToString(this.sps);
    }

    private final String getPpsString() {
        return this.encodeToString(this.pps);
    }

    private final String getVpsString() {
        return this.encodeToString(this.vps);
    }

    private final String addHeaders() {
        CommandsManager commandsManager = this;
        ++commandsManager.cSeq;
        return "CSeq: " + commandsManager.cSeq + "\r\nUser-Agent: com.pedro.rtsp 2.1.0\r\n" + (this.sessionId == null ? "" : "Session: " + this.sessionId + "\r\n") + (authorization == null ? "" : "Authorization: " + authorization + "\r\n");
    }

    private final String createBody() {
        String videoBody = "";
        if (!this.videoDisabled) {
            videoBody = this.vps == null ? SdpBody.INSTANCE.createH264Body(RtpConstants.INSTANCE.getTrackVideo(), this.getSpsString(), this.getPpsString()) : SdpBody.INSTANCE.createH265Body(RtpConstants.INSTANCE.getTrackVideo(), this.getSpsString(), this.getPpsString(), this.getVpsString());
        }
        String audioBody = "";
        if (!this.audioDisabled) {
            audioBody = SdpBody.INSTANCE.createAacBody(RtpConstants.INSTANCE.getTrackAudio(), this.sampleRate, this.isStereo);
        }
        return "v=0\r\no=- " + this.timeStamp + ' ' + this.timeStamp + " IN IP4 127.0.0.1\r\ns=Unnamed\r\ni=N/A\r\nc=IN IP4 " + this.host + "\r\nt=0 0\r\na=recvonly\r\n" + videoBody + audioBody;
    }

    private final String createAuth(String authResponse) {
        String string;
        Pattern authPattern = Pattern.compile("realm=\"(.+)\",\\s+nonce=\"(\\w+)\"", 2);
        Matcher matcher = authPattern.matcher(authResponse);
        if (matcher.find()) {
            Log.i((String)TAG, (String)"using digest auth");
            String realm = matcher.group(1);
            String nonce = matcher.group(2);
            String hash1 = AuthUtil.getMd5Hash(this.user + ':' + realm + ':' + this.password);
            String hash2 = AuthUtil.getMd5Hash("ANNOUNCE:rtsp://" + this.host + ':' + this.port + this.path);
            String hash3 = AuthUtil.getMd5Hash(hash1 + ':' + nonce + ':' + hash2);
            string = "Digest username=\"" + this.user + "\", realm=\"" + realm + "\", nonce=\"" + nonce + "\", uri=\"rtsp://" + this.host + ':' + this.port + this.path + "\", response=\"" + hash3 + '\"';
        } else {
            String data;
            Log.i((String)TAG, (String)"using basic auth");
            String string2 = data = this.user + ':' + this.password;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            String base64Data = Base64.encodeToString((byte[])byArray, (int)0);
            string = Intrinsics.stringPlus((String)"Basic ", (Object)base64Data);
        }
        return string;
    }

    @NotNull
    public final String createOptions() {
        String options = "OPTIONS rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)options);
        return options;
    }

    @NotNull
    public String createSetup(int track) {
        int[] udpPorts = track == RtpConstants.INSTANCE.getTrackVideo() ? this.videoClientPorts : this.audioClientPorts;
        String params = this.protocol == Protocol.UDP ? "UDP;unicast;client_port=" + udpPorts[0] + '-' + udpPorts[1] + ";mode=record" : "TCP;unicast;interleaved=" + 2 * track + '-' + (2 * track + 1) + ";mode=record";
        String setup = "SETUP rtsp://" + this.host + ':' + this.port + this.path + "/streamid=" + track + " RTSP/1.0\r\nTransport: RTP/AVP/" + params + "\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)setup);
        return setup;
    }

    @NotNull
    public final String createRecord() {
        String record = "RECORD rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\nRange: npt=0.000-\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)record);
        return record;
    }

    @NotNull
    public final String createAnnounce() {
        String body = this.createBody();
        String announce = "ANNOUNCE rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\nContent-Type: application/sdp\r\n" + this.addHeaders() + "Content-Length: " + body.length() + "\r\n\r\n" + body;
        Log.i((String)TAG, (String)announce);
        return announce;
    }

    @NotNull
    public final String createAnnounceWithAuth(@NotNull String authResponse) {
        Intrinsics.checkNotNullParameter((Object)authResponse, (String)"authResponse");
        authorization = this.createAuth(authResponse);
        Log.i((String)"Auth", (String)String.valueOf(authorization));
        return this.createAnnounce();
    }

    @NotNull
    public final String createTeardown() {
        String teardown = "TEARDOWN rtsp://" + this.host + ':' + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)teardown);
        return teardown;
    }

    @NotNull
    public final Command getResponse(@Nullable BufferedReader reader, @NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        BufferedReader bufferedReader = reader;
        if (bufferedReader != null) {
            Command command;
            BufferedReader bufferedReader2 = bufferedReader;
            boolean bl = false;
            boolean bl2 = false;
            BufferedReader br = bufferedReader2;
            boolean bl3 = false;
            try {
                Command command2;
                int n;
                String string;
                String response = "";
                String line = null;
                do {
                    string = br.readLine();
                    n = 0;
                    boolean bl4 = false;
                    String it = string;
                    boolean bl5 = false;
                    line = it;
                    if (string == null) break;
                    response = response + ((string = line) == null ? "" : string) + '\n';
                } while (((string = line) == null ? 0 : (n = string.length())) >= 3);
                Log.i((String)TAG, (String)response);
                if (method == Method.UNKNOWN) {
                    command2 = Command.Companion.parseCommand(response);
                } else {
                    Command command3 = Command.Companion.parseResponse(method, response);
                    this.getSession(command3.getText());
                    if (command3.getMethod() == Method.SETUP && this.getProtocol() == Protocol.UDP) {
                        this.getServerPorts(command3.getText());
                    }
                    command2 = command3;
                }
                command = command2;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"read error", (Throwable)e);
                command = new Command(method, this.cSeq, -1, "");
            }
            return command;
        }
        return new Command(method, this.cSeq, -1, "");
    }

    public static /* synthetic */ Command getResponse$default(CommandsManager commandsManager, BufferedReader bufferedReader, Method method, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getResponse");
        }
        if ((n & 2) != 0) {
            method = Method.UNKNOWN;
        }
        return commandsManager.getResponse(bufferedReader, method);
    }

    private final void getSession(String response) {
        String string;
        Pattern rtspPattern = Pattern.compile("Session:(\\s?\\w+)");
        Matcher matcher = rtspPattern.matcher(response);
        if (matcher.find() && (string = (this.sessionId = (string = matcher.group(1)) == null ? "" : string)) != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Object object = new String[]{";"};
            String temp = (String)StringsKt.split$default((CharSequence)it, (String[])object, (boolean)false, (int)0, (int)6, null).get(0);
            object = temp;
            boolean bl4 = false;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            this.sessionId = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
        }
    }

    private final void getServerPorts(String response) {
        Pattern rtspPattern;
        Matcher matcher;
        boolean isAudio = true;
        Pattern clientPattern = Pattern.compile("client_port=([0-9]+)-([0-9]+)");
        Matcher clientMatcher = clientPattern.matcher(response);
        if (clientMatcher.find()) {
            String string = clientMatcher.group(1);
            string = string == null ? "-1" : string;
            boolean bl = false;
            int port = Integer.parseInt(string);
            boolean bl2 = isAudio = port == this.audioClientPorts[0];
        }
        if ((matcher = (rtspPattern = Pattern.compile("server_port=([0-9]+)-([0-9]+)")).matcher(response)).find()) {
            if (isAudio) {
                String string = matcher.group(1);
                string = string == null ? String.valueOf(this.audioClientPorts[0]) : string;
                boolean bl = false;
                this.audioServerPorts[0] = Integer.parseInt(string);
                string = matcher.group(2);
                string = string == null ? String.valueOf(this.audioClientPorts[1]) : string;
                bl = false;
                this.audioServerPorts[1] = Integer.parseInt(string);
            } else {
                String string = matcher.group(1);
                string = string == null ? String.valueOf(this.videoClientPorts[0]) : string;
                boolean bl = false;
                this.videoServerPorts[0] = Integer.parseInt(string);
                string = matcher.group(2);
                string = string == null ? String.valueOf(this.videoClientPorts[1]) : string;
                bl = false;
                this.videoServerPorts[1] = Integer.parseInt(string);
            }
        }
    }

    @NotNull
    public final String createPause() {
        return "";
    }

    @NotNull
    public final String createPlay() {
        return "";
    }

    @NotNull
    public final String createGetParameter() {
        return "";
    }

    @NotNull
    public final String createSetParameter() {
        return "";
    }

    @NotNull
    public final String createRedirect() {
        return "";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pedro/rtsp/rtsp/commands/CommandsManager$Companion;", "", "()V", "TAG", "", "authorization", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

