/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspSender;
import com.pedro.rtsp.rtsp.commands.Command;
import com.pedro.rtsp.rtsp.commands.CommandsManager;
import com.pedro.rtsp.rtsp.commands.Method;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import com.pedro.rtsp.utils.CreateSSLSocket;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 [2\u00020\u0001:\u0001[B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u00100\u001a\u0002012\b\u0010-\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u00102\u001a\u00020\u0010H\u0007J\u0006\u00103\u001a\u000201J\u0010\u00103\u001a\u0002012\u0006\u00104\u001a\u00020\u0010H\u0002J\b\u00105\u001a\u000201H\u0002J\u0006\u00106\u001a\u00020\u0010J\u001c\u00107\u001a\u0002012\u0006\u00108\u001a\u00020\u00122\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u0006H\u0007J\u0006\u0010:\u001a\u000201J\u0006\u0010;\u001a\u000201J\u0006\u0010<\u001a\u000201J\u0006\u0010=\u001a\u000201J\u000e\u0010>\u001a\u0002012\u0006\u0010?\u001a\u00020\bJ\u0016\u0010@\u001a\u0002012\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DJ\u0016\u0010E\u001a\u0002012\u0006\u0010F\u001a\u00020B2\u0006\u0010C\u001a\u00020DJ\u0016\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020\b2\u0006\u0010I\u001a\u00020\u0010J\u001a\u0010J\u001a\u0002012\b\u0010K\u001a\u0004\u0018\u00010\u00062\b\u0010L\u001a\u0004\u0018\u00010\u0006J\u000e\u0010M\u001a\u0002012\u0006\u0010N\u001a\u00020\u0010J\u000e\u0010O\u001a\u0002012\u0006\u0010P\u001a\u00020\u0010J\u000e\u0010Q\u001a\u0002012\u0006\u0010R\u001a\u00020SJ\u000e\u0010T\u001a\u0002012\u0006\u0010\u001d\u001a\u00020\bJ$\u0010U\u001a\u0002012\b\u0010V\u001a\u0004\u0018\u00010B2\b\u0010W\u001a\u0004\u0018\u00010B2\b\u0010X\u001a\u0004\u0018\u00010BJ\u000e\u0010Y\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0014R\u0011\u0010(\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0014R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/pedro/rtsp/rtsp/RtspClient;", "", "connectCheckerRtsp", "Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;", "(Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;)V", "TAG", "", "cacheSize", "", "getCacheSize", "()I", "commandsManager", "Lcom/pedro/rtsp/rtsp/commands/CommandsManager;", "connectionSocket", "Ljava/net/Socket;", "doingRetry", "", "droppedAudioFrames", "", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "handler", "Ljava/util/concurrent/ScheduledExecutorService;", "<set-?>", "isStreaming", "()Z", "numRetry", "reTries", "reader", "Ljava/io/BufferedReader;", "rtspSender", "Lcom/pedro/rtsp/rtsp/RtspSender;", "runnable", "Ljava/lang/Runnable;", "semaphore", "Ljava/util/concurrent/Semaphore;", "sentAudioFrames", "getSentAudioFrames", "sentVideoFrames", "getSentVideoFrames", "thread", "Ljava/util/concurrent/ExecutorService;", "tlsEnabled", "url", "writer", "Ljava/io/BufferedWriter;", "connect", "", "isRetry", "disconnect", "clear", "handleServerCommands", "hasCongestion", "reConnect", "delay", "backupUrl", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudio", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideo", "h264Buffer", "setAudioInfo", "sampleRate", "isStereo", "setAuthorization", "user", "password", "setLogs", "enable", "setOnlyAudio", "onlyAudio", "setProtocol", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "setReTries", "setVideoInfo", "sps", "pps", "vps", "shouldRetry", "reason", "Companion", "rtsp_release"})
public class RtspClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectCheckerRtsp connectCheckerRtsp;
    @NotNull
    private final String TAG;
    @Nullable
    private Socket connectionSocket;
    @Nullable
    private BufferedReader reader;
    @Nullable
    private BufferedWriter writer;
    @Nullable
    private ExecutorService thread;
    @NotNull
    private final Semaphore semaphore;
    private volatile boolean isStreaming;
    private boolean tlsEnabled;
    @NotNull
    private final RtspSender rtspSender;
    @Nullable
    private String url;
    @NotNull
    private final CommandsManager commandsManager;
    private boolean doingRetry;
    private int numRetry;
    private int reTries;
    @Nullable
    private ScheduledExecutorService handler;
    @Nullable
    private Runnable runnable;
    private static final Pattern rtspUrlPattern = Pattern.compile("^rtsps?://([^/:]+)(?::(\\d+))*/([^/]+)/?([^*]*)$");

    public RtspClient(@NotNull ConnectCheckerRtsp connectCheckerRtsp) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtsp, (String)"connectCheckerRtsp");
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.TAG = "RtspClient";
        this.semaphore = new Semaphore(0);
        this.rtspSender = new RtspSender(this.connectCheckerRtsp);
        this.commandsManager = new CommandsManager();
    }

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final long getDroppedAudioFrames() {
        return this.rtspSender.getDroppedAudioFrames();
    }

    public final long getDroppedVideoFrames() {
        return this.rtspSender.getDroppedVideoFrames();
    }

    public final int getCacheSize() {
        return this.rtspSender.getCacheSize();
    }

    public final long getSentAudioFrames() {
        return this.rtspSender.getSentAudioFrames();
    }

    public final long getSentVideoFrames() {
        return this.rtspSender.getSentVideoFrames();
    }

    public final void setOnlyAudio(boolean onlyAudio) {
        if (onlyAudio) {
            RtpConstants.INSTANCE.setTrackAudio(0);
            RtpConstants.INSTANCE.setTrackVideo(1);
        } else {
            RtpConstants.INSTANCE.setTrackVideo(0);
            RtpConstants.INSTANCE.setTrackAudio(1);
        }
        this.commandsManager.setOnlyAudio(onlyAudio);
    }

    public final void setProtocol(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        this.commandsManager.setProtocol(protocol);
    }

    public final void setAuthorization(@Nullable String user, @Nullable String password) {
        this.commandsManager.setAuth(user, password);
    }

    public final void setReTries(int reTries) {
        this.numRetry = reTries;
        this.reTries = reTries;
    }

    public final boolean shouldRetry(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        boolean validReason = this.doingRetry && !StringsKt.contains$default((CharSequence)reason, (CharSequence)"Endpoint malformed", (boolean)false, (int)2, null);
        return validReason && this.reTries > 0;
    }

    public final void setVideoInfo(@Nullable ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Log.i((String)this.TAG, (String)"send sps and pps");
        this.commandsManager.setVideoInfo(sps, pps, vps);
        this.semaphore.release();
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.commandsManager.setAudioInfo(sampleRate, isStereo);
    }

    @JvmOverloads
    public final void connect(@Nullable String url, boolean isRetry) {
        if (!isRetry) {
            this.doingRetry = true;
        }
        if (url == null) {
            this.isStreaming = false;
            this.connectCheckerRtsp.onConnectionFailedRtsp("Endpoint malformed, should be: rtsp://ip:port/appname/streamname");
            return;
        }
        if (!this.isStreaming || isRetry) {
            this.url = url;
            this.connectCheckerRtsp.onConnectionStartedRtsp(url);
            Matcher rtspMatcher = rtspUrlPattern.matcher(url);
            if (!rtspMatcher.matches()) {
                this.isStreaming = false;
                this.connectCheckerRtsp.onConnectionFailedRtsp("Endpoint malformed, should be: rtsp://ip:port/appname/streamname");
                return;
            }
            String string = rtspMatcher.group(0);
            this.tlsEnabled = StringsKt.startsWith$default((String)(string == null ? "" : string), (String)"rtsps", (boolean)false, (int)2, null);
            String string2 = rtspMatcher.group(1);
            String host = string2 == null ? "" : string2;
            String string3 = rtspMatcher.group(2);
            string3 = string3 == null ? "554" : string3;
            boolean bl = false;
            int port = Integer.parseInt(string3);
            CharSequence charSequence = rtspMatcher.group(4);
            boolean bl2 = false;
            boolean bl3 = false;
            String streamName = charSequence == null || charSequence.length() == 0 ? "" : Intrinsics.stringPlus((String)"/", (Object)rtspMatcher.group(4));
            String path = '/' + rtspMatcher.group(3) + streamName;
            this.isStreaming = true;
            ExecutorService executorService = this.thread = Executors.newSingleThreadExecutor();
            if (executorService != null) {
                executorService.execute(() -> RtspClient.connect$lambda-1(this, host, port, path));
            }
        }
    }

    public static /* synthetic */ void connect$default(RtspClient rtspClient, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: connect");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        rtspClient.connect(string, bl);
    }

    private final void handleServerCommands() {
        while (!Thread.interrupted()) {
            try {
                Thread.sleep(2000L);
                BufferedReader bufferedReader = this.reader;
                if (bufferedReader == null) continue;
                BufferedReader bufferedReader2 = bufferedReader;
                boolean bl = false;
                boolean bl2 = false;
                BufferedReader r = bufferedReader2;
                boolean bl3 = false;
                if (!r.ready()) continue;
                Command command = CommandsManager.getResponse$default(this.commandsManager, r, null, 2, null);
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public final void disconnect() {
        Runnable runnable = this.runnable;
        if (runnable != null) {
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            ScheduledExecutorService scheduledExecutorService = this.handler;
            if (scheduledExecutorService != null) {
                scheduledExecutorService.shutdownNow();
            }
        }
        this.disconnect(true);
    }

    private final void disconnect(boolean clear) {
        AutoCloseable autoCloseable;
        if (this.isStreaming) {
            this.rtspSender.stop();
        }
        if ((autoCloseable = this.thread) != null) {
            autoCloseable.shutdownNow();
        }
        try {
            autoCloseable = this.reader;
            if (autoCloseable != null) {
                ((BufferedReader)autoCloseable).close();
            }
            this.reader = null;
            autoCloseable = this.writer;
            if (autoCloseable != null) {
                ((BufferedWriter)autoCloseable).flush();
            }
            autoCloseable = this.thread;
            if (autoCloseable != null) {
                autoCloseable.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thread = Executors.newSingleThreadExecutor();
        autoCloseable = this.thread;
        if (autoCloseable != null) {
            autoCloseable.execute(() -> RtspClient.disconnect$lambda-4(this, clear));
        }
        try {
            autoCloseable = this.thread;
            if (autoCloseable != null) {
                autoCloseable.shutdown();
            }
            autoCloseable = this.thread;
            if (autoCloseable != null) {
                autoCloseable.awaitTermination(200L, TimeUnit.MILLISECONDS);
            }
            autoCloseable = this.thread;
            if (!(autoCloseable == null ? false : autoCloseable.isTerminated()) && (autoCloseable = this.thread) != null) {
                autoCloseable.shutdownNow();
            }
            this.thread = null;
            this.semaphore.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clear) {
            this.reTries = this.numRetry;
            this.doingRetry = false;
            this.isStreaming = false;
            this.connectCheckerRtsp.onDisconnectRtsp();
        }
    }

    public final void sendVideo(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!this.commandsManager.isOnlyAudio()) {
            this.rtspSender.sendVideoFrame(h264Buffer, info);
        }
    }

    public final void sendAudio(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtspSender.sendAudioFrame(aacBuffer, info);
    }

    public final boolean hasCongestion() {
        return this.rtspSender.hasCongestion();
    }

    @JvmOverloads
    public final void reConnect(long delay, @Nullable String backupUrl) {
        Object object = this;
        int n = ((RtspClient)object).reTries;
        ((RtspClient)object).reTries = n + -1;
        this.disconnect(false);
        this.runnable = () -> RtspClient.reConnect$lambda-5(backupUrl, this);
        object = this.runnable;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            this.handler = Executors.newSingleThreadScheduledExecutor();
            ScheduledExecutorService scheduledExecutorService = this.handler;
            if (scheduledExecutorService != null) {
                scheduledExecutorService.schedule((Runnable)it, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static /* synthetic */ void reConnect$default(RtspClient rtspClient, long l, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reConnect");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        rtspClient.reConnect(l, string);
    }

    public final void resetSentAudioFrames() {
        this.rtspSender.resetSentAudioFrames();
    }

    public final void resetSentVideoFrames() {
        this.rtspSender.resetSentVideoFrames();
    }

    public final void resetDroppedAudioFrames() {
        this.rtspSender.resetDroppedAudioFrames();
    }

    public final void resetDroppedVideoFrames() {
        this.rtspSender.resetDroppedVideoFrames();
    }

    public final void resizeCache(int newSize) throws RuntimeException {
        this.rtspSender.resizeCache(newSize);
    }

    public final void setLogs(boolean enable) {
        this.rtspSender.setLogs(enable);
    }

    @JvmOverloads
    public final void connect(@Nullable String url) {
        RtspClient.connect$default(this, url, false, 2, null);
    }

    @JvmOverloads
    public final void reConnect(long delay) {
        RtspClient.reConnect$default(this, delay, null, 2, null);
    }

    private static final void connect$lambda-1(RtspClient this$0, String $host, int $port, String $path) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$host, (String)"$host");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        try {
            BufferedWriter setupVideoStatus2;
            Closeable closeable;
            Object socketAddress;
            this$0.commandsManager.setUrl($host, $port, $path);
            this$0.rtspSender.setSocketsInfo(this$0.commandsManager.getProtocol(), this$0.commandsManager.getVideoClientPorts(), this$0.commandsManager.getAudioClientPorts());
            this$0.rtspSender.setAudioInfo(this$0.commandsManager.getSampleRate());
            if (!this$0.commandsManager.isOnlyAudio()) {
                if (this$0.commandsManager.getSps() == null || this$0.commandsManager.getPps() == null) {
                    this$0.semaphore.drainPermits();
                    Log.i((String)this$0.TAG, (String)"waiting for sps and pps");
                    this$0.semaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS);
                }
                if (this$0.commandsManager.getSps() == null || this$0.commandsManager.getPps() == null) {
                    this$0.connectCheckerRtsp.onConnectionFailedRtsp("sps or pps is null");
                    return;
                }
                RtspSender rtspSender = this$0.rtspSender;
                byte[] byArray = this$0.commandsManager.getSps();
                Intrinsics.checkNotNull((Object)byArray);
                byte[] byArray2 = this$0.commandsManager.getPps();
                Intrinsics.checkNotNull((Object)byArray2);
                rtspSender.setVideoInfo(byArray, byArray2, this$0.commandsManager.getVps());
            }
            if (!this$0.tlsEnabled) {
                this$0.connectionSocket = new Socket();
                socketAddress = new InetSocketAddress($host, $port);
                closeable = this$0.connectionSocket;
                if (closeable != null) {
                    ((Socket)closeable).connect((SocketAddress)socketAddress, 5000);
                }
            } else {
                this$0.connectionSocket = CreateSSLSocket.createSSlSocket($host, $port);
                if (this$0.connectionSocket == null) {
                    throw new IOException("Socket creation failed");
                }
            }
            socketAddress = this$0.connectionSocket;
            if (socketAddress != null) {
                ((Socket)socketAddress).setSoTimeout(5000);
            }
            socketAddress = this$0.connectionSocket;
            this$0.reader = new BufferedReader(new InputStreamReader(socketAddress == null ? null : ((Socket)socketAddress).getInputStream()));
            closeable = this$0.connectionSocket;
            OutputStream outputStream = closeable == null ? null : ((Socket)closeable).getOutputStream();
            this$0.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
            closeable = this$0.writer;
            if (closeable != null) {
                ((Writer)closeable).write(this$0.commandsManager.createOptions());
            }
            closeable = this$0.writer;
            if (closeable != null) {
                ((BufferedWriter)closeable).flush();
            }
            this$0.commandsManager.getResponse(this$0.reader, Method.OPTIONS);
            closeable = this$0.writer;
            if (closeable != null) {
                ((Writer)closeable).write(this$0.commandsManager.createAnnounce());
            }
            closeable = this$0.writer;
            if (closeable != null) {
                ((BufferedWriter)closeable).flush();
            }
            Command announceResponse = this$0.commandsManager.getResponse(this$0.reader, Method.ANNOUNCE);
            int n = announceResponse.getStatus();
            block1 : switch (n) {
                case 403: {
                    this$0.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, access denied");
                    Log.e((String)this$0.TAG, (String)"Response 403, access denied");
                    return;
                }
                case 401: {
                    if (this$0.commandsManager.getUser() == null || this$0.commandsManager.getPassword() == null) {
                        this$0.connectCheckerRtsp.onAuthErrorRtsp();
                        return;
                    }
                    BufferedWriter bufferedWriter = this$0.writer;
                    if (bufferedWriter != null) {
                        bufferedWriter.write(this$0.commandsManager.createAnnounceWithAuth(announceResponse.getText()));
                    }
                    bufferedWriter = this$0.writer;
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                    }
                    int n2 = this$0.commandsManager.getResponse(this$0.reader, Method.ANNOUNCE).getStatus();
                    switch (n2) {
                        case 401: {
                            this$0.connectCheckerRtsp.onAuthErrorRtsp();
                            return;
                        }
                        case 200: {
                            this$0.connectCheckerRtsp.onAuthSuccessRtsp();
                            break block1;
                        }
                    }
                    this$0.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, announce with auth failed");
                    return;
                }
                case 200: {
                    Log.i((String)this$0.TAG, (String)"announce success");
                    break;
                }
                default: {
                    this$0.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, announce failed");
                    return;
                }
            }
            if (!this$0.commandsManager.isOnlyAudio()) {
                BufferedWriter bufferedWriter = this$0.writer;
                if (bufferedWriter != null) {
                    bufferedWriter.write(this$0.commandsManager.createSetup(RtpConstants.INSTANCE.getTrackVideo()));
                }
                bufferedWriter = this$0.writer;
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                }
                int setupVideoStatus2 = this$0.commandsManager.getResponse(this$0.reader, Method.SETUP).getStatus();
                if (setupVideoStatus2 != 200) {
                    this$0.connectCheckerRtsp.onConnectionFailedRtsp(Intrinsics.stringPlus((String)"Error configure stream, setup video ", (Object)setupVideoStatus2));
                    return;
                }
            }
            if ((setupVideoStatus2 = this$0.writer) != null) {
                setupVideoStatus2.write(this$0.commandsManager.createSetup(RtpConstants.INSTANCE.getTrackAudio()));
            }
            setupVideoStatus2 = this$0.writer;
            if (setupVideoStatus2 != null) {
                setupVideoStatus2.flush();
            }
            int setupAudioStatus = this$0.commandsManager.getResponse(this$0.reader, Method.SETUP).getStatus();
            if (setupAudioStatus != 200) {
                this$0.connectCheckerRtsp.onConnectionFailedRtsp(Intrinsics.stringPlus((String)"Error configure stream, setup audio ", (Object)setupAudioStatus));
                return;
            }
            BufferedWriter bufferedWriter = this$0.writer;
            if (bufferedWriter != null) {
                bufferedWriter.write(this$0.commandsManager.createRecord());
            }
            bufferedWriter = this$0.writer;
            if (bufferedWriter != null) {
                bufferedWriter.flush();
            }
            int recordStatus = this$0.commandsManager.getResponse(this$0.reader, Method.RECORD).getStatus();
            if (recordStatus != 200) {
                this$0.connectCheckerRtsp.onConnectionFailedRtsp(Intrinsics.stringPlus((String)"Error configure stream, record ", (Object)recordStatus));
                return;
            }
            OutputStream outputStream2 = outputStream;
            if (outputStream2 != null) {
                OutputStream outputStream3 = outputStream2;
                boolean bl = false;
                boolean bl2 = false;
                OutputStream out = outputStream3;
                boolean bl3 = false;
                this$0.rtspSender.setDataStream(out, $host);
            }
            int[] videoPorts = this$0.commandsManager.getVideoServerPorts();
            int[] audioPorts = this$0.commandsManager.getAudioServerPorts();
            if (!this$0.commandsManager.isOnlyAudio()) {
                this$0.rtspSender.setVideoPorts(videoPorts[0], videoPorts[1]);
            }
            this$0.rtspSender.setAudioPorts(audioPorts[0], audioPorts[1]);
            this$0.rtspSender.start();
            this$0.reTries = this$0.numRetry;
            this$0.connectCheckerRtsp.onConnectionSuccessRtsp();
            this$0.handleServerCommands();
        }
        catch (Exception e) {
            Log.e((String)this$0.TAG, (String)"connection error", (Throwable)e);
            this$0.connectCheckerRtsp.onConnectionFailedRtsp(Intrinsics.stringPlus((String)"Error configure stream, ", (Object)e.getMessage()));
            return;
        }
    }

    private static final void disconnect$lambda-4(RtspClient this$0, boolean $clear) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            Closeable closeable = this$0.writer;
            if (closeable != null) {
                ((Writer)closeable).write(this$0.commandsManager.createTeardown());
            }
            closeable = this$0.writer;
            if (closeable != null) {
                ((BufferedWriter)closeable).flush();
            }
            if ($clear) {
                this$0.commandsManager.clear();
            } else {
                this$0.commandsManager.retryClear();
            }
            closeable = this$0.connectionSocket;
            if (closeable != null) {
                ((Socket)closeable).close();
            }
            closeable = this$0.writer;
            if (closeable != null) {
                ((BufferedWriter)closeable).close();
            }
            this$0.writer = null;
            this$0.connectionSocket = null;
            Log.i((String)this$0.TAG, (String)"write teardown success");
        }
        catch (IOException e) {
            if ($clear) {
                this$0.commandsManager.clear();
            } else {
                this$0.commandsManager.retryClear();
            }
            Log.e((String)this$0.TAG, (String)"disconnect error", (Throwable)e);
        }
    }

    private static final void reConnect$lambda-5(String $backupUrl, RtspClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = $backupUrl;
        String reconnectUrl = string == null ? this$0.url : string;
        this$0.connect(reconnectUrl, true);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pedro/rtsp/rtsp/RtspClient$Companion;", "", "()V", "rtspUrlPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

