/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspSender;
import com.pedro.rtsp.rtsp.commands.Command;
import com.pedro.rtsp.rtsp.commands.CommandsManager;
import com.pedro.rtsp.rtsp.commands.Method;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import com.pedro.rtsp.utils.CreateSSLSocket;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 [2\u00020\u0001:\u0001[B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u00100\u001a\u0002012\b\u0010-\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u00102\u001a\u00020\u0010H\u0007J\u0006\u00103\u001a\u000201J\u0010\u00103\u001a\u0002012\u0006\u00104\u001a\u00020\u0010H\u0002J\b\u00105\u001a\u000201H\u0002J\u0006\u00106\u001a\u00020\u0010J\u000e\u00107\u001a\u0002012\u0006\u00108\u001a\u00020\u0012J\u0006\u00109\u001a\u000201J\u0006\u0010:\u001a\u000201J\u0006\u0010;\u001a\u000201J\u0006\u0010<\u001a\u000201J\u000e\u0010=\u001a\u0002012\u0006\u0010>\u001a\u00020\bJ\u0016\u0010?\u001a\u0002012\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ\u0016\u0010D\u001a\u0002012\u0006\u0010E\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ\u001a\u0010F\u001a\u0002012\b\u0010G\u001a\u0004\u0018\u00010\u00062\b\u0010H\u001a\u0004\u0018\u00010\u0006J\u000e\u0010I\u001a\u0002012\u0006\u0010J\u001a\u00020\u0010J\u000e\u0010K\u001a\u0002012\u0006\u0010L\u001a\u00020\u0010J\u000e\u0010M\u001a\u0002012\u0006\u0010N\u001a\u00020\u0010J\u000e\u0010O\u001a\u0002012\u0006\u0010P\u001a\u00020QJ\u000e\u0010R\u001a\u0002012\u0006\u0010\u001d\u001a\u00020\bJ$\u0010S\u001a\u0002012\b\u0010T\u001a\u0004\u0018\u00010A2\b\u0010U\u001a\u0004\u0018\u00010A2\b\u0010V\u001a\u0004\u0018\u00010AJ\u000e\u0010W\u001a\u0002012\u0006\u0010X\u001a\u00020\bJ\u000e\u0010Y\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0014R\u0011\u0010(\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0014R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/pedro/rtsp/rtsp/RtspClient;", "", "connectCheckerRtsp", "Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;", "(Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;)V", "TAG", "", "cacheSize", "", "getCacheSize", "()I", "commandsManager", "Lcom/pedro/rtsp/rtsp/commands/CommandsManager;", "connectionSocket", "Ljava/net/Socket;", "doingRetry", "", "droppedAudioFrames", "", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "handler", "Landroid/os/Handler;", "<set-?>", "isStreaming", "()Z", "numRetry", "reTries", "reader", "Ljava/io/BufferedReader;", "rtspSender", "Lcom/pedro/rtsp/rtsp/RtspSender;", "runnable", "Ljava/lang/Runnable;", "semaphore", "Ljava/util/concurrent/Semaphore;", "sentAudioFrames", "getSentAudioFrames", "sentVideoFrames", "getSentVideoFrames", "thread", "Landroid/os/HandlerThread;", "tlsEnabled", "url", "writer", "Ljava/io/BufferedWriter;", "connect", "", "isRetry", "disconnect", "clear", "handleServerCommands", "hasCongestion", "reConnect", "delay", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudio", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideo", "h264Buffer", "setAuthorization", "user", "password", "setIsStereo", "isStereo", "setLogs", "enable", "setOnlyAudio", "onlyAudio", "setProtocol", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "setReTries", "setSPSandPPS", "sps", "pps", "vps", "setSampleRate", "sampleRate", "shouldRetry", "reason", "Companion", "rtsp_release"})
public class RtspClient {
    private final String TAG;
    private Socket connectionSocket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private HandlerThread thread;
    private final Semaphore semaphore;
    private volatile boolean isStreaming;
    private boolean tlsEnabled;
    private final RtspSender rtspSender;
    private String url;
    private final CommandsManager commandsManager;
    private boolean doingRetry;
    private int numRetry;
    private int reTries;
    private final Handler handler;
    private Runnable runnable;
    private final ConnectCheckerRtsp connectCheckerRtsp;
    private static final Pattern rtspUrlPattern;
    @NotNull
    public static final Companion Companion;

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final long getDroppedAudioFrames() {
        return this.rtspSender.getDroppedAudioFrames();
    }

    public final long getDroppedVideoFrames() {
        return this.rtspSender.getDroppedVideoFrames();
    }

    public final int getCacheSize() {
        return this.rtspSender.getCacheSize();
    }

    public final long getSentAudioFrames() {
        return this.rtspSender.getSentAudioFrames();
    }

    public final long getSentVideoFrames() {
        return this.rtspSender.getSentVideoFrames();
    }

    public final void setOnlyAudio(boolean onlyAudio) {
        if (onlyAudio) {
            RtpConstants.INSTANCE.setTrackAudio(0);
            RtpConstants.INSTANCE.setTrackVideo(1);
        } else {
            RtpConstants.INSTANCE.setTrackVideo(0);
            RtpConstants.INSTANCE.setTrackAudio(1);
        }
        this.commandsManager.setOnlyAudio(onlyAudio);
    }

    public final void setProtocol(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        this.commandsManager.setProtocol(protocol);
    }

    public final void setAuthorization(@Nullable String user, @Nullable String password) {
        this.commandsManager.setAuth(user, password);
    }

    public final void setReTries(int reTries) {
        this.numRetry = reTries;
        this.reTries = reTries;
    }

    public final boolean shouldRetry(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        boolean validReason = this.doingRetry && !StringsKt.contains$default((CharSequence)reason, (CharSequence)"Endpoint malformed", (boolean)false, (int)2, null);
        return validReason && this.reTries > 0;
    }

    public final void setSampleRate(int sampleRate) {
        this.commandsManager.setSampleRate(sampleRate);
    }

    public final void setSPSandPPS(@Nullable ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Log.i((String)this.TAG, (String)"send sps and pps");
        this.commandsManager.setVideoInfo(sps, pps, vps);
        this.semaphore.release();
    }

    public final void setIsStereo(boolean isStereo) {
        this.commandsManager.setStereo(isStereo);
    }

    @JvmOverloads
    public final void connect(@Nullable String url, boolean isRetry) {
        block9: {
            String string;
            String host;
            String string2;
            if (!isRetry) {
                this.doingRetry = true;
            }
            if (url == null) {
                this.isStreaming = false;
                this.connectCheckerRtsp.onConnectionFailedRtsp("Endpoint malformed, should be: rtsp://ip:port/appname/streamname");
                return;
            }
            if (this.isStreaming && !isRetry) break block9;
            this.url = url;
            Matcher rtspMatcher = rtspUrlPattern.matcher(url);
            if (rtspMatcher.matches()) {
                string2 = rtspMatcher.group(0);
                if (string2 == null) {
                    string2 = "";
                }
            } else {
                this.isStreaming = false;
                this.connectCheckerRtsp.onConnectionFailedRtsp("Endpoint malformed, should be: rtsp://ip:port/appname/streamname");
                return;
            }
            this.tlsEnabled = StringsKt.startsWith$default((String)string2, (String)"rtsps", (boolean)false, (int)2, null);
            String string3 = rtspMatcher.group(1);
            if (string3 == null) {
                string3 = host = "";
            }
            if ((string = rtspMatcher.group(2)) == null) {
                string = "554";
            }
            String string4 = string;
            boolean bl = false;
            int port = Integer.parseInt(string4);
            CharSequence charSequence = rtspMatcher.group(4);
            boolean bl2 = false;
            boolean bl3 = false;
            String streamName = charSequence == null || charSequence.length() == 0 ? "" : "/" + rtspMatcher.group(4);
            String path = "/" + rtspMatcher.group(3) + streamName;
            this.isStreaming = true;
            HandlerThread handlerThread = this.thread = new HandlerThread(this.TAG);
            if (handlerThread != null) {
                handlerThread.start();
            }
            HandlerThread handlerThread2 = this.thread;
            if (handlerThread2 != null) {
                HandlerThread handlerThread3 = handlerThread2;
                bl3 = false;
                boolean bl4 = false;
                HandlerThread it = handlerThread3;
                boolean bl5 = false;
                Handler h = new Handler(it.getLooper());
                h.post(new Runnable(this, host, port, path){
                    final /* synthetic */ RtspClient this$0;
                    final /* synthetic */ String $host$inlined;
                    final /* synthetic */ int $port$inlined;
                    final /* synthetic */ String $path$inlined;
                    {
                        this.this$0 = rtspClient;
                        this.$host$inlined = string;
                        this.$port$inlined = n;
                        this.$path$inlined = string2;
                    }

                    public final void run() {
                        try {
                            RtspClient.access$getCommandsManager$p(this.this$0).setUrl(this.$host$inlined, this.$port$inlined, this.$path$inlined);
                            RtspClient.access$getRtspSender$p(this.this$0).setSocketsInfo(RtspClient.access$getCommandsManager$p(this.this$0).getProtocol(), RtspClient.access$getCommandsManager$p(this.this$0).getVideoClientPorts(), RtspClient.access$getCommandsManager$p(this.this$0).getAudioClientPorts());
                            RtspClient.access$getRtspSender$p(this.this$0).setAudioInfo(RtspClient.access$getCommandsManager$p(this.this$0).getSampleRate());
                            if (!RtspClient.access$getCommandsManager$p(this.this$0).isOnlyAudio()) {
                                if (RtspClient.access$getCommandsManager$p(this.this$0).getSps() == null && RtspClient.access$getCommandsManager$p(this.this$0).getPps() == null) {
                                    RtspClient.access$getSemaphore$p(this.this$0).drainPermits();
                                    Log.i((String)RtspClient.access$getTAG$p(this.this$0), (String)"waiting for sps and pps");
                                    RtspClient.access$getSemaphore$p(this.this$0).tryAcquire(5000L, TimeUnit.MILLISECONDS);
                                }
                                if (RtspClient.access$getCommandsManager$p(this.this$0).getSps() == null && RtspClient.access$getCommandsManager$p(this.this$0).getPps() == null) {
                                    RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onConnectionFailedRtsp("sps or pps is null");
                                    return;
                                }
                                RtspSender rtspSender = RtspClient.access$getRtspSender$p(this.this$0);
                                byte[] byArray = RtspClient.access$getCommandsManager$p(this.this$0).getSps();
                                Intrinsics.checkNotNull((Object)byArray);
                                byte[] byArray2 = RtspClient.access$getCommandsManager$p(this.this$0).getPps();
                                Intrinsics.checkNotNull((Object)byArray2);
                                rtspSender.setVideoInfo(byArray, byArray2, RtspClient.access$getCommandsManager$p(this.this$0).getVps());
                            }
                            if (!RtspClient.access$getTlsEnabled$p(this.this$0)) {
                                RtspClient.access$setConnectionSocket$p(this.this$0, new Socket());
                                SocketAddress socketAddress = new InetSocketAddress(this.$host$inlined, this.$port$inlined);
                                Socket socket = RtspClient.access$getConnectionSocket$p(this.this$0);
                                if (socket != null) {
                                    socket.connect(socketAddress, 5000);
                                }
                            } else {
                                RtspClient.access$setConnectionSocket$p(this.this$0, CreateSSLSocket.createSSlSocket(this.$host$inlined, this.$port$inlined));
                                if (RtspClient.access$getConnectionSocket$p(this.this$0) == null) {
                                    throw (Throwable)new IOException("Socket creation failed");
                                }
                            }
                            Socket socket = RtspClient.access$getConnectionSocket$p(this.this$0);
                            if (socket != null) {
                                socket.setSoTimeout(5000);
                            }
                            Socket socket2 = RtspClient.access$getConnectionSocket$p(this.this$0);
                            RtspClient.access$setReader$p(this.this$0, new BufferedReader(new InputStreamReader(socket2 != null ? socket2.getInputStream() : null)));
                            Socket socket3 = RtspClient.access$getConnectionSocket$p(this.this$0);
                            OutputStream outputStream = socket3 != null ? socket3.getOutputStream() : null;
                            RtspClient.access$setWriter$p(this.this$0, new BufferedWriter(new OutputStreamWriter(outputStream)));
                            BufferedWriter bufferedWriter = RtspClient.access$getWriter$p(this.this$0);
                            if (bufferedWriter != null) {
                                bufferedWriter.write(RtspClient.access$getCommandsManager$p(this.this$0).createOptions());
                            }
                            BufferedWriter bufferedWriter2 = RtspClient.access$getWriter$p(this.this$0);
                            if (bufferedWriter2 != null) {
                                bufferedWriter2.flush();
                            }
                            RtspClient.access$getCommandsManager$p(this.this$0).getResponse(RtspClient.access$getReader$p(this.this$0), Method.OPTIONS);
                            BufferedWriter bufferedWriter3 = RtspClient.access$getWriter$p(this.this$0);
                            if (bufferedWriter3 != null) {
                                bufferedWriter3.write(RtspClient.access$getCommandsManager$p(this.this$0).createAnnounce());
                            }
                            BufferedWriter bufferedWriter4 = RtspClient.access$getWriter$p(this.this$0);
                            if (bufferedWriter4 != null) {
                                bufferedWriter4.flush();
                            }
                            Command announceResponse = RtspClient.access$getCommandsManager$p(this.this$0).getResponse(RtspClient.access$getReader$p(this.this$0), Method.ANNOUNCE);
                            block1 : switch (announceResponse.getStatus()) {
                                case 403: {
                                    RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onConnectionFailedRtsp("Error configure stream, access denied");
                                    Log.e((String)RtspClient.access$getTAG$p(this.this$0), (String)"Response 403, access denied");
                                    return;
                                }
                                case 401: {
                                    if (RtspClient.access$getCommandsManager$p(this.this$0).getUser() == null || RtspClient.access$getCommandsManager$p(this.this$0).getPassword() == null) {
                                        RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onAuthErrorRtsp();
                                        return;
                                    }
                                    BufferedWriter bufferedWriter5 = RtspClient.access$getWriter$p(this.this$0);
                                    if (bufferedWriter5 != null) {
                                        bufferedWriter5.write(RtspClient.access$getCommandsManager$p(this.this$0).createAnnounceWithAuth(announceResponse.getText()));
                                    }
                                    BufferedWriter bufferedWriter6 = RtspClient.access$getWriter$p(this.this$0);
                                    if (bufferedWriter6 != null) {
                                        bufferedWriter6.flush();
                                    }
                                    switch (RtspClient.access$getCommandsManager$p(this.this$0).getResponse(RtspClient.access$getReader$p(this.this$0), Method.ANNOUNCE).getStatus()) {
                                        case 401: {
                                            RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onAuthErrorRtsp();
                                            return;
                                        }
                                        case 200: {
                                            RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onAuthSuccessRtsp();
                                            break block1;
                                        }
                                    }
                                    RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onConnectionFailedRtsp("Error configure stream, announce with auth failed");
                                    return;
                                }
                                case 200: {
                                    Log.i((String)RtspClient.access$getTAG$p(this.this$0), (String)"announce success");
                                    break;
                                }
                                default: {
                                    RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onConnectionFailedRtsp("Error configure stream, announce failed");
                                    return;
                                }
                            }
                            if (!RtspClient.access$getCommandsManager$p(this.this$0).isOnlyAudio()) {
                                BufferedWriter bufferedWriter7 = RtspClient.access$getWriter$p(this.this$0);
                                if (bufferedWriter7 != null) {
                                    bufferedWriter7.write(RtspClient.access$getCommandsManager$p(this.this$0).createSetup(RtpConstants.INSTANCE.getTrackVideo()));
                                }
                                BufferedWriter bufferedWriter8 = RtspClient.access$getWriter$p(this.this$0);
                                if (bufferedWriter8 != null) {
                                    bufferedWriter8.flush();
                                }
                                int setupVideoStatus = RtspClient.access$getCommandsManager$p(this.this$0).getResponse(RtspClient.access$getReader$p(this.this$0), Method.SETUP).getStatus();
                                if (setupVideoStatus != 200) {
                                    RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onConnectionFailedRtsp("Error configure stream, setup video " + setupVideoStatus);
                                    return;
                                }
                            }
                            BufferedWriter bufferedWriter9 = RtspClient.access$getWriter$p(this.this$0);
                            if (bufferedWriter9 != null) {
                                bufferedWriter9.write(RtspClient.access$getCommandsManager$p(this.this$0).createSetup(RtpConstants.INSTANCE.getTrackAudio()));
                            }
                            BufferedWriter bufferedWriter10 = RtspClient.access$getWriter$p(this.this$0);
                            if (bufferedWriter10 != null) {
                                bufferedWriter10.flush();
                            }
                            int setupAudioStatus = RtspClient.access$getCommandsManager$p(this.this$0).getResponse(RtspClient.access$getReader$p(this.this$0), Method.SETUP).getStatus();
                            if (setupAudioStatus != 200) {
                                RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onConnectionFailedRtsp("Error configure stream, setup audio " + setupAudioStatus);
                                return;
                            }
                            BufferedWriter bufferedWriter11 = RtspClient.access$getWriter$p(this.this$0);
                            if (bufferedWriter11 != null) {
                                bufferedWriter11.write(RtspClient.access$getCommandsManager$p(this.this$0).createRecord());
                            }
                            BufferedWriter bufferedWriter12 = RtspClient.access$getWriter$p(this.this$0);
                            if (bufferedWriter12 != null) {
                                bufferedWriter12.flush();
                            }
                            int recordStatus = RtspClient.access$getCommandsManager$p(this.this$0).getResponse(RtspClient.access$getReader$p(this.this$0), Method.RECORD).getStatus();
                            if (recordStatus != 200) {
                                RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onConnectionFailedRtsp("Error configure stream, record " + recordStatus);
                                return;
                            }
                            OutputStream outputStream2 = outputStream;
                            if (outputStream2 != null) {
                                OutputStream outputStream3 = outputStream2;
                                boolean bl = false;
                                boolean bl2 = false;
                                OutputStream out = outputStream3;
                                boolean bl3 = false;
                                RtspClient.access$getRtspSender$p(this.this$0).setDataStream(out, this.$host$inlined);
                            }
                            int[] videoPorts = RtspClient.access$getCommandsManager$p(this.this$0).getVideoServerPorts();
                            int[] audioPorts = RtspClient.access$getCommandsManager$p(this.this$0).getAudioServerPorts();
                            if (!RtspClient.access$getCommandsManager$p(this.this$0).isOnlyAudio()) {
                                RtspClient.access$getRtspSender$p(this.this$0).setVideoPorts(videoPorts[0], videoPorts[1]);
                            }
                            RtspClient.access$getRtspSender$p(this.this$0).setAudioPorts(audioPorts[0], audioPorts[1]);
                            RtspClient.access$getRtspSender$p(this.this$0).start();
                            RtspClient.access$setReTries$p(this.this$0, RtspClient.access$getNumRetry$p(this.this$0));
                            RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onConnectionSuccessRtsp();
                            RtspClient.access$handleServerCommands(this.this$0);
                        }
                        catch (Exception e) {
                            Log.e((String)RtspClient.access$getTAG$p(this.this$0), (String)"connection error", (Throwable)e);
                            RtspClient.access$getConnectCheckerRtsp$p(this.this$0).onConnectionFailedRtsp("Error configure stream, " + e.getMessage());
                            return;
                        }
                    }
                });
            }
        }
    }

    public static /* synthetic */ void connect$default(RtspClient rtspClient, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: connect");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        rtspClient.connect(string, bl);
    }

    @JvmOverloads
    public final void connect(@Nullable String url) {
        RtspClient.connect$default(this, url, false, 2, null);
    }

    private final void handleServerCommands() {
        while (!Thread.interrupted()) {
            try {
                BufferedReader bufferedReader;
                Thread.sleep(2000L);
                if (this.reader == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                BufferedReader r = bufferedReader;
                boolean bl3 = false;
                if (!r.ready()) continue;
                Command command = CommandsManager.getResponse$default(this.commandsManager, r, null, 2, null);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final void disconnect() {
        Runnable runnable = this.runnable;
        if (runnable != null) {
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            this.handler.removeCallbacks(it);
        }
        this.disconnect(true);
    }

    private final void disconnect(boolean clear) {
        HandlerThread handlerThread;
        Object object;
        if (this.isStreaming) {
            this.rtspSender.stop();
        }
        if ((object = this.thread) != null && (object = object.getLooper()) != null && (object = object.getThread()) != null) {
            ((Thread)object).interrupt();
        }
        if ((handlerThread = this.thread) != null && (handlerThread = handlerThread.getLooper()) != null) {
            handlerThread.quit();
        }
        HandlerThread handlerThread2 = this.thread;
        if (handlerThread2 != null) {
            handlerThread2.quit();
        }
        try {
            BufferedWriter bufferedWriter = this.writer;
            if (bufferedWriter != null) {
                bufferedWriter.flush();
            }
            HandlerThread handlerThread3 = this.thread;
            if (handlerThread3 != null) {
                handlerThread3.join(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HandlerThread handlerThread4 = this.thread = new HandlerThread(this.TAG);
        if (handlerThread4 != null) {
            handlerThread4.start();
        }
        HandlerThread handlerThread5 = this.thread;
        if (handlerThread5 != null) {
            HandlerThread handlerThread6 = handlerThread5;
            boolean bl = false;
            boolean bl2 = false;
            HandlerThread it = handlerThread6;
            boolean bl3 = false;
            Handler h = new Handler(it.getLooper());
            h.post(new Runnable(this, clear){
                final /* synthetic */ RtspClient this$0;
                final /* synthetic */ boolean $clear$inlined;
                {
                    this.this$0 = rtspClient;
                    this.$clear$inlined = bl;
                }

                public final void run() {
                    try {
                        BufferedWriter bufferedWriter = RtspClient.access$getWriter$p(this.this$0);
                        if (bufferedWriter != null) {
                            bufferedWriter.write(RtspClient.access$getCommandsManager$p(this.this$0).createTeardown());
                        }
                        BufferedWriter bufferedWriter2 = RtspClient.access$getWriter$p(this.this$0);
                        if (bufferedWriter2 != null) {
                            bufferedWriter2.flush();
                        }
                        if (this.$clear$inlined) {
                            RtspClient.access$getCommandsManager$p(this.this$0).clear();
                        } else {
                            RtspClient.access$getCommandsManager$p(this.this$0).retryClear();
                        }
                        Socket socket = RtspClient.access$getConnectionSocket$p(this.this$0);
                        if (socket != null) {
                            socket.close();
                        }
                        RtspClient.access$setWriter$p(this.this$0, null);
                        RtspClient.access$setConnectionSocket$p(this.this$0, null);
                        Log.i((String)RtspClient.access$getTAG$p(this.this$0), (String)"write teardown success");
                    }
                    catch (IOException e) {
                        if (this.$clear$inlined) {
                            RtspClient.access$getCommandsManager$p(this.this$0).clear();
                        } else {
                            RtspClient.access$getCommandsManager$p(this.this$0).retryClear();
                        }
                        Log.e((String)RtspClient.access$getTAG$p(this.this$0), (String)"disconnect error", (Throwable)e);
                    }
                }
            });
        }
        try {
            HandlerThread handlerThread7;
            Object object2;
            HandlerThread handlerThread8 = this.thread;
            if (handlerThread8 != null) {
                handlerThread8.join(200L);
            }
            if ((object2 = this.thread) != null && (object2 = object2.getLooper()) != null && (object2 = object2.getThread()) != null) {
                ((Thread)object2).interrupt();
            }
            if ((handlerThread7 = this.thread) != null && (handlerThread7 = handlerThread7.getLooper()) != null) {
                handlerThread7.quit();
            }
            HandlerThread handlerThread9 = this.thread;
            if (handlerThread9 != null) {
                handlerThread9.quit();
            }
            BufferedWriter bufferedWriter = this.writer;
            if (bufferedWriter != null) {
                bufferedWriter.flush();
            }
            HandlerThread handlerThread10 = this.thread;
            if (handlerThread10 != null) {
                handlerThread10.join(100L);
            }
            this.thread = null;
            this.semaphore.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clear) {
            this.reTries = this.numRetry;
            this.doingRetry = false;
            this.isStreaming = false;
            this.connectCheckerRtsp.onDisconnectRtsp();
        }
    }

    public final void sendVideo(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!this.commandsManager.isOnlyAudio()) {
            this.rtspSender.sendVideoFrame(h264Buffer, info);
        }
    }

    public final void sendAudio(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.rtspSender.sendAudioFrame(aacBuffer, info);
    }

    public final boolean hasCongestion() {
        return this.rtspSender.hasCongestion();
    }

    public final void reConnect(long delay) {
        block0: {
            int n = this.reTries;
            this.reTries = n + -1;
            this.disconnect(false);
            Runnable runnable = this.runnable = (Runnable)new Runnable(this){
                final /* synthetic */ RtspClient this$0;

                public final void run() {
                    Log.e((String)"Pedro", (String)"connect");
                    this.this$0.connect(RtspClient.access$getUrl$p(this.this$0), true);
                }
                {
                    this.this$0 = rtspClient;
                }
            };
            if (runnable == null) break block0;
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            this.handler.postDelayed(it, delay);
        }
    }

    public final void resetSentAudioFrames() {
        this.rtspSender.resetSentAudioFrames();
    }

    public final void resetSentVideoFrames() {
        this.rtspSender.resetSentVideoFrames();
    }

    public final void resetDroppedAudioFrames() {
        this.rtspSender.resetDroppedAudioFrames();
    }

    public final void resetDroppedVideoFrames() {
        this.rtspSender.resetDroppedVideoFrames();
    }

    public final void resizeCache(int newSize) throws RuntimeException {
        this.rtspSender.resizeCache(newSize);
    }

    public final void setLogs(boolean enable) {
        this.rtspSender.setLogs(enable);
    }

    public RtspClient(@NotNull ConnectCheckerRtsp connectCheckerRtsp) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtsp, (String)"connectCheckerRtsp");
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.TAG = "RtspClient";
        this.semaphore = new Semaphore(0);
        this.rtspSender = new RtspSender(this.connectCheckerRtsp);
        this.commandsManager = new CommandsManager();
        this.handler = new Handler(Looper.getMainLooper());
    }

    static {
        Companion = new Companion(null);
        rtspUrlPattern = Pattern.compile("^rtsps?://([^/:]+)(?::(\\d+))*/([^/]+)/?([^*]*)$");
    }

    public static final /* synthetic */ CommandsManager access$getCommandsManager$p(RtspClient $this) {
        return $this.commandsManager;
    }

    public static final /* synthetic */ RtspSender access$getRtspSender$p(RtspClient $this) {
        return $this.rtspSender;
    }

    public static final /* synthetic */ Semaphore access$getSemaphore$p(RtspClient $this) {
        return $this.semaphore;
    }

    public static final /* synthetic */ String access$getTAG$p(RtspClient $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ ConnectCheckerRtsp access$getConnectCheckerRtsp$p(RtspClient $this) {
        return $this.connectCheckerRtsp;
    }

    public static final /* synthetic */ boolean access$getTlsEnabled$p(RtspClient $this) {
        return $this.tlsEnabled;
    }

    public static final /* synthetic */ void access$setTlsEnabled$p(RtspClient $this, boolean bl) {
        $this.tlsEnabled = bl;
    }

    public static final /* synthetic */ Socket access$getConnectionSocket$p(RtspClient $this) {
        return $this.connectionSocket;
    }

    public static final /* synthetic */ void access$setConnectionSocket$p(RtspClient $this, Socket socket) {
        $this.connectionSocket = socket;
    }

    public static final /* synthetic */ BufferedReader access$getReader$p(RtspClient $this) {
        return $this.reader;
    }

    public static final /* synthetic */ void access$setReader$p(RtspClient $this, BufferedReader bufferedReader) {
        $this.reader = bufferedReader;
    }

    public static final /* synthetic */ BufferedWriter access$getWriter$p(RtspClient $this) {
        return $this.writer;
    }

    public static final /* synthetic */ void access$setWriter$p(RtspClient $this, BufferedWriter bufferedWriter) {
        $this.writer = bufferedWriter;
    }

    public static final /* synthetic */ int access$getReTries$p(RtspClient $this) {
        return $this.reTries;
    }

    public static final /* synthetic */ void access$setReTries$p(RtspClient $this, int n) {
        $this.reTries = n;
    }

    public static final /* synthetic */ int access$getNumRetry$p(RtspClient $this) {
        return $this.numRetry;
    }

    public static final /* synthetic */ void access$setNumRetry$p(RtspClient $this, int n) {
        $this.numRetry = n;
    }

    public static final /* synthetic */ void access$handleServerCommands(RtspClient $this) {
        $this.handleServerCommands();
    }

    public static final /* synthetic */ String access$getUrl$p(RtspClient $this) {
        return $this.url;
    }

    public static final /* synthetic */ void access$setUrl$p(RtspClient $this, String string) {
        $this.url = string;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pedro/rtsp/rtsp/RtspClient$Companion;", "", "()V", "rtspUrlPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

