/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import com.pedro.rtsp.utils.UtilsKt;
import java.nio.ByteBuffer;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000b\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H&J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0004J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020$H\u0004J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020$H\u0002J\b\u0010)\u001a\u00020\u001eH\u0016J\u0018\u0010*\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0016\u0010+\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020$H\u0004J\u0018\u0010-\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0003H\u0004R\u0014\u0010\u0007\u001a\u00020\bX\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0005X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0013\"\u0004\b\u001a\u0010\u0017R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/pedro/rtsp/rtp/packets/BasePacket;", "", "clock", "", "payloadType", "", "(JI)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "channelIdentifier", "", "getChannelIdentifier", "()B", "setChannelIdentifier", "(B)V", "maxPacketSize", "getMaxPacketSize", "()I", "rtcpPort", "getRtcpPort", "setRtcpPort", "(I)V", "rtpPort", "getRtpPort", "setRtpPort", "seq", "ssrc", "createAndSendPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "getBuffer", "", "size", "markPacket", "buffer", "requestBuffer", "reset", "setLongSSRC", "setPorts", "updateSeq", "updateTimeStamp", "timestamp", "rtsp_release"})
public abstract class BasePacket {
    private byte channelIdentifier;
    private int rtpPort;
    private int rtcpPort;
    private int seq;
    private int ssrc;
    private final int maxPacketSize;
    @NotNull
    private final String TAG;
    private final long clock;
    private final int payloadType;

    protected final byte getChannelIdentifier() {
        return this.channelIdentifier;
    }

    protected final void setChannelIdentifier(byte by) {
        this.channelIdentifier = by;
    }

    protected final int getRtpPort() {
        return this.rtpPort;
    }

    protected final void setRtpPort(int n) {
        this.rtpPort = n;
    }

    protected final int getRtcpPort() {
        return this.rtcpPort;
    }

    protected final void setRtcpPort(int n) {
        this.rtcpPort = n;
    }

    protected final int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    @NotNull
    protected final String getTAG() {
        return this.TAG;
    }

    public abstract void createAndSendPacket(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2);

    public final void setPorts(int rtpPort, int rtcpPort) {
        this.rtpPort = rtpPort;
        this.rtcpPort = rtcpPort;
    }

    public void reset() {
        this.seq = 0;
        this.ssrc = new Random().nextInt();
    }

    @NotNull
    protected final byte[] getBuffer(int size) {
        byte[] buffer = new byte[size];
        String string = "10000000";
        int n = 2;
        boolean bl = false;
        buffer[0] = (byte)Integer.parseInt(string, CharsKt.checkRadix((int)n));
        buffer[1] = (byte)this.payloadType;
        this.setLongSSRC(buffer, this.ssrc);
        this.requestBuffer(buffer);
        return buffer;
    }

    protected final void updateTimeStamp(@NotNull byte[] buffer, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long ts = timestamp * this.clock / 1000000000L;
        UtilsKt.setLong(buffer, ts, 4, 8);
    }

    protected final void updateSeq(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BasePacket basePacket = this;
        ++basePacket.seq;
        UtilsKt.setLong(buffer, basePacket.seq, 2, 4);
    }

    protected final void markPacket(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        byte by = buffer[1];
        byte by2 = (byte)128;
        boolean bl = false;
        buffer[1] = (byte)(by | by2);
    }

    private final void setLongSSRC(byte[] buffer, int ssrc) {
        UtilsKt.setLong(buffer, ssrc, 8, 12);
    }

    private final void requestBuffer(byte[] buffer) {
        byte by = buffer[1];
        int n = 127;
        boolean bl = false;
        buffer[1] = (byte)(by & n);
    }

    public BasePacket(long clock, int payloadType) {
        this.clock = clock;
        this.payloadType = payloadType;
        this.ssrc = new Random().nextInt();
        this.maxPacketSize = 1272;
        this.TAG = "BasePacket";
    }
}

