/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J&\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/pedro/rtsp/rtsp/Body;", "", "()V", "AUDIO_SAMPLING_RATES", "", "createAacBody", "", "trackAudio", "", "sampleRate", "isStereo", "", "createH264Body", "trackVideo", "sps", "pps", "createH265Body", "vps", "rtsp_release"})
public final class Body {
    private static final int[] AUDIO_SAMPLING_RATES;
    @NotNull
    public static final Body INSTANCE;

    @NotNull
    public final String createAacBody(int trackAudio, int sampleRate, boolean isStereo) {
        int sampleRateNum = ArraysKt.toList((int[])AUDIO_SAMPLING_RATES).indexOf(sampleRate);
        int channel = isStereo ? 2 : 1;
        int config = 0x1000 | (sampleRateNum & 0xF) << 7 | (channel & 0xF) << 3;
        return "m=audio 0 RTP/AVP 97\r\n" + "a=rtpmap:97 MPEG4-GENERIC/" + sampleRate + '/' + channel + "\r\n" + "a=fmtp:97 streamtype=5; profile-level-id=15; mode=AAC-hbr; config=" + Integer.toHexString(config) + "; SizeLength=13; IndexLength=3; IndexDeltaLength=3;\n" + "a=control:trackID=" + trackAudio + "\r\n";
    }

    @NotNull
    public final String createH264Body(int trackVideo, @NotNull String sps, @NotNull String pps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        return "m=video 0 RTP/AVP 96\r\na=rtpmap:96 H264/90000\r\n" + "a=fmtp:96 packetization-mode=1; sprop-parameter-sets=" + sps + ',' + pps + ";\r\n" + "a=control:trackID=" + trackVideo + "\r\n";
    }

    @NotNull
    public final String createH265Body(int trackVideo, @NotNull String sps, @NotNull String pps, @NotNull String vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Intrinsics.checkNotNullParameter((Object)vps, (String)"vps");
        return "m=video 0 RTP/AVP 96\r\na=rtpmap:96 H265/90000\r\n" + "a=fmtp:96 sprop-sps=" + sps + "; sprop-pps=" + pps + "; sprop-vps=" + vps + ";\r\n" + "a=control:trackID=" + trackVideo + "\r\n";
    }

    private Body() {
    }

    static {
        Body body;
        INSTANCE = body = new Body();
        AUDIO_SAMPLING_RATES = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350, -1, -1, -1};
    }
}

