/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

import android.util.Log;
import com.pedro.rtsp.rtcp.SenderReportTcp;
import com.pedro.rtsp.rtcp.SenderReportUdp;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.UtilsKt;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H&J\u0006\u0010\u0019\u001a\u00020\u0018J8\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H&J \u0010#\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\tH&J\u0016\u0010*\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J\u0018\u0010+\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/pedro/rtsp/rtcp/BaseSenderReport;", "", "()V", "MTU", "", "PACKET_LENGTH", "getPACKET_LENGTH", "()I", "TAG", "", "getTAG", "()Ljava/lang/String;", "audioBuffer", "", "audioOctetCount", "audioPacketCount", "audioTime", "", "interval", "videoBuffer", "videoOctetCount", "videoPacketCount", "videoTime", "close", "", "reset", "sendReport", "buffer", "rtpFrame", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "type", "packetCount", "octetCount", "isEnableLogs", "", "setData", "ntpts", "rtpts", "setDataStream", "outputStream", "Ljava/io/OutputStream;", "host", "update", "updateAudio", "updateVideo", "Companion", "rtsp_release"})
public abstract class BaseSenderReport {
    private final long interval;
    private final int MTU;
    private final byte[] videoBuffer;
    private final byte[] audioBuffer;
    private long videoTime;
    private long audioTime;
    private int videoPacketCount;
    private int videoOctetCount;
    private int audioPacketCount;
    private int audioOctetCount;
    private final int PACKET_LENGTH;
    @NotNull
    private final String TAG;
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected final int getPACKET_LENGTH() {
        return this.PACKET_LENGTH;
    }

    @NotNull
    protected final String getTAG() {
        return this.TAG;
    }

    public abstract void setDataStream(@NotNull OutputStream var1, @NotNull String var2);

    public final void update(@NotNull RtpFrame rtpFrame, boolean isEnableLogs) {
        Intrinsics.checkNotNullParameter((Object)rtpFrame, (String)"rtpFrame");
        if (rtpFrame.getChannelIdentifier() == (byte)2) {
            this.updateVideo(rtpFrame, isEnableLogs);
        } else {
            this.updateAudio(rtpFrame, isEnableLogs);
        }
    }

    public abstract void sendReport(@NotNull byte[] var1, @NotNull RtpFrame var2, @NotNull String var3, int var4, int var5, boolean var6) throws IOException;

    private final void updateVideo(RtpFrame rtpFrame, boolean isEnableLogs) {
        int n = this.videoPacketCount;
        this.videoPacketCount = n + 1;
        this.videoOctetCount += rtpFrame.getLength();
        UtilsKt.setLong(this.videoBuffer, this.videoPacketCount, 20, 24);
        UtilsKt.setLong(this.videoBuffer, this.videoOctetCount, 24, 28);
        if (System.currentTimeMillis() - this.videoTime >= this.interval) {
            this.videoTime = System.currentTimeMillis();
            this.setData(this.videoBuffer, System.nanoTime(), rtpFrame.getTimeStamp());
            try {
                this.sendReport(this.videoBuffer, rtpFrame, "Video", this.videoPacketCount, this.videoOctetCount, isEnableLogs);
            }
            catch (IOException e) {
                Log.e((String)this.TAG, (String)"Error", (Throwable)e);
            }
        }
    }

    private final void updateAudio(RtpFrame rtpFrame, boolean isEnableLogs) {
        int n = this.audioPacketCount;
        this.audioPacketCount = n + 1;
        this.audioOctetCount += rtpFrame.getLength();
        UtilsKt.setLong(this.audioBuffer, this.audioPacketCount, 20, 24);
        UtilsKt.setLong(this.audioBuffer, this.audioOctetCount, 24, 28);
        if (System.currentTimeMillis() - this.audioTime >= this.interval) {
            this.audioTime = System.currentTimeMillis();
            this.setData(this.audioBuffer, System.nanoTime(), rtpFrame.getTimeStamp());
            try {
                this.sendReport(this.audioBuffer, rtpFrame, "Audio", this.audioPacketCount, this.audioOctetCount, isEnableLogs);
            }
            catch (IOException e) {
                Log.e((String)this.TAG, (String)"Error", (Throwable)e);
            }
        }
    }

    public final void reset() {
        this.videoPacketCount = this.videoOctetCount = 0;
        this.audioPacketCount = this.audioOctetCount = 0;
        this.videoTime = this.audioTime = 0L;
        UtilsKt.setLong(this.videoBuffer, this.videoPacketCount, 20, 24);
        UtilsKt.setLong(this.videoBuffer, this.videoOctetCount, 24, 28);
        UtilsKt.setLong(this.audioBuffer, this.audioPacketCount, 20, 24);
        UtilsKt.setLong(this.audioBuffer, this.audioOctetCount, 24, 28);
    }

    public abstract void close();

    private final void setData(byte[] buffer, long ntpts, long rtpts) {
        long hb = ntpts / (long)1000000000;
        long lb = (ntpts - hb * (long)1000000000) * 0x100000000L / (long)1000000000;
        UtilsKt.setLong(buffer, hb, 8, 12);
        UtilsKt.setLong(buffer, lb, 12, 16);
        UtilsKt.setLong(buffer, rtpts, 16, 20);
    }

    public BaseSenderReport() {
        this.interval = 3000L;
        this.MTU = 1500;
        this.videoBuffer = new byte[this.MTU];
        this.audioBuffer = new byte[this.MTU];
        this.PACKET_LENGTH = 28;
        this.TAG = "BaseSenderReport";
        String string = "10000000";
        int n = 2;
        boolean bl = false;
        this.videoBuffer[0] = (byte)Integer.parseInt(string, CharsKt.checkRadix((int)n));
        string = "10000000";
        n = 2;
        bl = false;
        this.audioBuffer[0] = (byte)Integer.parseInt(string, CharsKt.checkRadix((int)n));
        this.videoBuffer[1] = (byte)200;
        this.audioBuffer[1] = (byte)200;
        UtilsKt.setLong(this.videoBuffer, (long)(this.PACKET_LENGTH / 4) - 1L, 2, 4);
        UtilsKt.setLong(this.audioBuffer, (long)(this.PACKET_LENGTH / 4) - 1L, 2, 4);
        UtilsKt.setLong(this.videoBuffer, new Random().nextInt(), 4, 8);
        UtilsKt.setLong(this.audioBuffer, new Random().nextInt(), 4, 8);
    }

    @JvmStatic
    @NotNull
    public static final BaseSenderReport getInstance(@NotNull Protocol protocol, int videoSourcePort, int audioSourcePort) {
        return Companion.getInstance(protocol, videoSourcePort, audioSourcePort);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lcom/pedro/rtsp/rtcp/BaseSenderReport$Companion;", "", "()V", "getInstance", "Lcom/pedro/rtsp/rtcp/BaseSenderReport;", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "videoSourcePort", "", "audioSourcePort", "rtsp_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final BaseSenderReport getInstance(@NotNull Protocol protocol, int videoSourcePort, int audioSourcePort) {
            Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
            return protocol == Protocol.TCP ? (BaseSenderReport)new SenderReportTcp() : (BaseSenderReport)new SenderReportUdp(videoSourcePort, audioSourcePort);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

