/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.IOException;
import java.io.OutputStream;

public class SenderReportTcp
extends BaseSenderReport {
    private OutputStream outputStream;
    private byte[] tcpHeader = new byte[]{36, 0, 0, 28};

    @Override
    public void setDataStream(OutputStream outputStream, String host) {
        this.outputStream = outputStream;
    }

    @Override
    public void sendReport(byte[] buffer, RtpFrame rtpFrame, String type, int packetCount, int octetCount, boolean isEnableLogs) throws IOException {
        this.sendReportTCP(buffer, rtpFrame.getChannelIdentifier(), type, packetCount, octetCount, isEnableLogs);
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReportTCP(byte[] buffer, byte channelIdentifier, String type, int packet, int octet, boolean isEnableLogs) throws IOException {
        Object object = RtpConstants.lock;
        synchronized (object) {
            this.tcpHeader[1] = (byte)(channelIdentifier + 1);
            this.outputStream.write(this.tcpHeader);
            this.outputStream.write(buffer, 0, 28);
            this.outputStream.flush();
            if (isEnableLogs) {
                Log.i((String)"BaseSenderReport", (String)("wrote report: " + type + ", packets: " + packet + ", octet: " + octet));
            }
        }
    }
}

