/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.rtsp.RtpFrame;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class SenderReportUdp
extends BaseSenderReport {
    private MulticastSocket multicastSocketVideo;
    private MulticastSocket multicastSocketAudio;
    private DatagramPacket datagramPacket = new DatagramPacket(new byte[]{0}, 1);

    public SenderReportUdp(int videoSourcePort, int audioSourcePort) {
        try {
            this.multicastSocketVideo = new MulticastSocket(videoSourcePort);
            this.multicastSocketVideo.setTimeToLive(64);
            this.multicastSocketAudio = new MulticastSocket(audioSourcePort);
            this.multicastSocketAudio.setTimeToLive(64);
        }
        catch (IOException e) {
            Log.e((String)"BaseSenderReport", (String)"Error", (Throwable)e);
        }
    }

    @Override
    public void setDataStream(OutputStream outputStream, String host) {
        try {
            this.datagramPacket.setAddress(InetAddress.getByName(host));
        }
        catch (UnknownHostException e) {
            Log.e((String)"BaseSenderReport", (String)"Error", (Throwable)e);
        }
    }

    @Override
    public void sendReport(byte[] buffer, RtpFrame rtpFrame, String type, int packetCount, int octetCount, boolean isEnableLogs) throws IOException {
        this.sendReportUDP(buffer, rtpFrame.getRtcpPort(), type, packetCount, octetCount, isEnableLogs);
    }

    @Override
    public void close() {
        this.multicastSocketVideo.close();
        this.multicastSocketAudio.close();
    }

    private void sendReportUDP(byte[] buffer, int port, String type, int packet, int octet, boolean isEnableLogs) throws IOException {
        this.datagramPacket.setData(buffer);
        this.datagramPacket.setPort(port);
        this.datagramPacket.setLength(28);
        if (type.equals("Video")) {
            this.multicastSocketVideo.send(this.datagramPacket);
        } else {
            this.multicastSocketAudio.send(this.datagramPacket);
        }
        if (isEnableLogs) {
            Log.i((String)"BaseSenderReport", (String)("wrote report: " + type + ", port: " + port + ", packets: " + packet + ", octet: " + octet));
        }
    }
}

