/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtsp.RtpFrame;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class RtpSocketUdp
extends BaseRtpSocket {
    private MulticastSocket multicastSocketVideo;
    private MulticastSocket multicastSocketAudio;
    private DatagramPacket datagramPacket = new DatagramPacket(new byte[]{0}, 1);

    public RtpSocketUdp(int videoSourcePort, int audioSourcePort) {
        try {
            this.multicastSocketVideo = new MulticastSocket(videoSourcePort);
            this.multicastSocketVideo.setTimeToLive(64);
            this.multicastSocketAudio = new MulticastSocket(audioSourcePort);
            this.multicastSocketAudio.setTimeToLive(64);
        }
        catch (IOException e) {
            Log.e((String)"BaseRtpSocket", (String)"Error", (Throwable)e);
        }
    }

    @Override
    public void setDataStream(OutputStream outputStream, String host) {
        try {
            this.datagramPacket.setAddress(InetAddress.getByName(host));
        }
        catch (UnknownHostException e) {
            Log.e((String)"BaseRtpSocket", (String)"Error", (Throwable)e);
        }
    }

    @Override
    public void sendFrame(RtpFrame rtpFrame) throws IOException {
        this.sendFrameUDP(rtpFrame);
    }

    @Override
    public void close() {
        this.multicastSocketVideo.close();
        this.multicastSocketAudio.close();
    }

    private void sendFrameUDP(RtpFrame rtpFrame) throws IOException {
        this.datagramPacket.setData(rtpFrame.getBuffer());
        this.datagramPacket.setPort(rtpFrame.getRtpPort());
        this.datagramPacket.setLength(rtpFrame.getLength());
        if (rtpFrame.getChannelIdentifier() == 2) {
            this.multicastSocketVideo.send(this.datagramPacket);
        } else {
            this.multicastSocketAudio.send(this.datagramPacket);
        }
        Log.i((String)"BaseRtpSocket", (String)("wrote packet: " + (rtpFrame.getChannelIdentifier() == 2 ? "Video" : "Audio") + ", size: " + rtpFrame.getLength() + ", port: " + rtpFrame.getRtpPort()));
    }
}

