/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.pedro.rtsp.rtsp.CommandsManager;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspSender;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import com.pedro.rtsp.utils.CreateSSLSocket;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RtspClient {
    private final String TAG = "RtspClient";
    private static final Pattern rtspUrlPattern = Pattern.compile("^rtsps?://([^/:]+)(?::(\\d+))*/([^/]+)/?([^*]*)$");
    private ConnectCheckerRtsp connectCheckerRtsp;
    private Socket connectionSocket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private Thread thread;
    private OutputStream outputStream;
    private volatile boolean streaming = false;
    private boolean tlsEnabled = false;
    private RtspSender rtspSender;
    private String url;
    private CommandsManager commandsManager;
    private int numRetry;
    private int reTries;
    private Handler handler;
    private Runnable runnable;

    public RtspClient(ConnectCheckerRtsp connectCheckerRtsp) {
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.commandsManager = new CommandsManager();
        this.rtspSender = new RtspSender(connectCheckerRtsp);
        this.handler = new Handler(Looper.getMainLooper());
    }

    public void setProtocol(Protocol protocol) {
        this.commandsManager.setProtocol(protocol);
    }

    public void setAuthorization(String user, String password) {
        this.commandsManager.setAuth(user, password);
    }

    public void setReTries(int reTries) {
        this.numRetry = reTries;
        this.reTries = reTries;
    }

    public boolean shouldRetry(String reason) {
        boolean validReason = !reason.contains("Endpoint malformed");
        return validReason && this.reTries > 0;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSampleRate(int sampleRate) {
        this.commandsManager.setSampleRate(sampleRate);
    }

    public String getHost() {
        return this.commandsManager.getHost();
    }

    public int getPort() {
        return this.commandsManager.getPort();
    }

    public String getPath() {
        return this.commandsManager.getPath();
    }

    public ConnectCheckerRtsp getConnectCheckerRtsp() {
        return this.connectCheckerRtsp;
    }

    public void setSPSandPPS(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.commandsManager.setVideoInfo(sps, pps, vps);
    }

    public void setIsStereo(boolean isStereo) {
        this.commandsManager.setIsStereo(isStereo);
    }

    public void connect() {
        if (!this.streaming) {
            Matcher rtspMatcher = rtspUrlPattern.matcher(this.url);
            if (!rtspMatcher.matches()) {
                this.streaming = false;
                this.connectCheckerRtsp.onConnectionFailedRtsp("Endpoint malformed, should be: rtsp://ip:port/appname/streamname");
                return;
            }
            this.tlsEnabled = rtspMatcher.group(0).startsWith("rtsps");
            String host = rtspMatcher.group(1);
            int port = Integer.parseInt(rtspMatcher.group(2) != null ? rtspMatcher.group(2) : "554");
            String path = "/" + rtspMatcher.group(3) + "/" + rtspMatcher.group(4);
            this.commandsManager.setUrl(host, port, path);
            this.rtspSender.setInfo(this.commandsManager.getProtocol(), this.commandsManager.getSps(), this.commandsManager.getPps(), this.commandsManager.getVps(), this.commandsManager.getSampleRate(), this.commandsManager.getVideoClientPorts(), this.commandsManager.getAudioClientPorts());
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!RtspClient.this.tlsEnabled) {
                            RtspClient.this.connectionSocket = new Socket();
                            InetSocketAddress socketAddress = new InetSocketAddress(RtspClient.this.commandsManager.getHost(), RtspClient.this.commandsManager.getPort());
                            RtspClient.this.connectionSocket.connect(socketAddress, 5000);
                        } else {
                            RtspClient.this.connectionSocket = CreateSSLSocket.createSSlSocket(RtspClient.this.commandsManager.getHost(), RtspClient.this.commandsManager.getPort());
                            if (RtspClient.this.connectionSocket == null) {
                                throw new IOException("Socket creation failed");
                            }
                        }
                        RtspClient.this.connectionSocket.setSoTimeout(5000);
                        RtspClient.this.reader = new BufferedReader(new InputStreamReader(RtspClient.this.connectionSocket.getInputStream()));
                        RtspClient.this.outputStream = RtspClient.this.connectionSocket.getOutputStream();
                        RtspClient.this.writer = new BufferedWriter(new OutputStreamWriter(RtspClient.this.outputStream));
                        RtspClient.this.writer.write(RtspClient.this.commandsManager.createOptions());
                        RtspClient.this.writer.flush();
                        RtspClient.this.commandsManager.getResponse(RtspClient.this.reader, RtspClient.this.connectCheckerRtsp, false, false);
                        RtspClient.this.writer.write(RtspClient.this.commandsManager.createAnnounce());
                        RtspClient.this.writer.flush();
                        String response = RtspClient.this.commandsManager.getResponse(RtspClient.this.reader, RtspClient.this.connectCheckerRtsp, false, false);
                        int status = RtspClient.this.commandsManager.getResponseStatus(response);
                        if (status == 403) {
                            RtspClient.this.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, access denied");
                            Log.e((String)"RtspClient", (String)"Response 403, access denied");
                            return;
                        }
                        if (status == 401) {
                            if (RtspClient.this.commandsManager.getUser() == null || RtspClient.this.commandsManager.getPassword() == null) {
                                RtspClient.this.connectCheckerRtsp.onAuthErrorRtsp();
                                return;
                            }
                            RtspClient.this.writer.write(RtspClient.this.commandsManager.createAnnounceWithAuth(response));
                            RtspClient.this.writer.flush();
                            int statusAuth = RtspClient.this.commandsManager.getResponseStatus(RtspClient.this.commandsManager.getResponse(RtspClient.this.reader, RtspClient.this.connectCheckerRtsp, false, false));
                            if (statusAuth == 401) {
                                RtspClient.this.connectCheckerRtsp.onAuthErrorRtsp();
                                return;
                            }
                            if (statusAuth == 200) {
                                RtspClient.this.connectCheckerRtsp.onAuthSuccessRtsp();
                            } else {
                                RtspClient.this.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, announce with auth failed");
                            }
                        } else if (status != 200) {
                            RtspClient.this.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, announce failed");
                        }
                        RtspClient.this.writer.write(RtspClient.this.commandsManager.createSetup(RtspClient.this.commandsManager.getTrackAudio()));
                        RtspClient.this.writer.flush();
                        RtspClient.this.commandsManager.getResponse(RtspClient.this.reader, RtspClient.this.connectCheckerRtsp, true, true);
                        RtspClient.this.writer.write(RtspClient.this.commandsManager.createSetup(RtspClient.this.commandsManager.getTrackVideo()));
                        RtspClient.this.writer.flush();
                        RtspClient.this.commandsManager.getResponse(RtspClient.this.reader, RtspClient.this.connectCheckerRtsp, false, true);
                        RtspClient.this.writer.write(RtspClient.this.commandsManager.createRecord());
                        RtspClient.this.writer.flush();
                        RtspClient.this.commandsManager.getResponse(RtspClient.this.reader, RtspClient.this.connectCheckerRtsp, false, true);
                        RtspClient.this.rtspSender.setDataStream(RtspClient.this.outputStream, RtspClient.this.commandsManager.getHost());
                        int[] videoPorts = RtspClient.this.commandsManager.getVideoServerPorts();
                        int[] audioPorts = RtspClient.this.commandsManager.getAudioServerPorts();
                        RtspClient.this.rtspSender.setVideoPorts(videoPorts[0], videoPorts[1]);
                        RtspClient.this.rtspSender.setAudioPorts(audioPorts[0], audioPorts[1]);
                        RtspClient.this.rtspSender.start();
                        RtspClient.this.streaming = true;
                        RtspClient.this.reTries = RtspClient.this.numRetry;
                        RtspClient.this.connectCheckerRtsp.onConnectionSuccessRtsp();
                    }
                    catch (IOException | NullPointerException e) {
                        Log.e((String)"RtspClient", (String)"connection error", (Throwable)e);
                        RtspClient.this.connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, " + e.getMessage());
                        RtspClient.this.streaming = false;
                    }
                }
            });
            this.thread.start();
        }
    }

    public void disconnect() {
        this.handler.removeCallbacks(this.runnable);
        this.disconnect(true);
    }

    private void disconnect(final boolean clear) {
        if (this.streaming) {
            this.rtspSender.stop();
        }
        this.streaming = false;
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (RtspClient.this.writer != null) {
                        RtspClient.this.writer.write(RtspClient.this.commandsManager.createTeardown());
                        RtspClient.this.writer.flush();
                        if (clear) {
                            RtspClient.this.commandsManager.clear();
                        }
                    }
                    if (RtspClient.this.connectionSocket != null) {
                        RtspClient.this.connectionSocket.close();
                    }
                    RtspClient.this.writer = null;
                    RtspClient.this.connectionSocket = null;
                }
                catch (IOException e) {
                    Log.e((String)"RtspClient", (String)"disconnect error", (Throwable)e);
                }
            }
        });
        this.thread.start();
        if (clear) {
            this.reTries = 0;
            this.connectCheckerRtsp.onDisconnectRtsp();
        }
    }

    public void sendVideo(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        if (this.isStreaming()) {
            this.rtspSender.sendVideoFrame(h264Buffer, info);
        }
    }

    public void sendAudio(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        if (this.isStreaming()) {
            this.rtspSender.sendAudioFrame(aacBuffer, info);
        }
    }

    public void reConnect(long delay) {
        --this.reTries;
        this.disconnect(false);
        this.runnable = new Runnable(){

            @Override
            public void run() {
                RtspClient.this.connect();
            }
        };
        this.handler.postDelayed(this.runnable, delay);
    }

    public long getDroppedAudioFrames() {
        return this.rtspSender.getDroppedAudioFrames();
    }

    public long getDroppedVideoFrames() {
        return this.rtspSender.getDroppedVideoFrames();
    }

    public void resetSentAudioFrames() {
        this.rtspSender.resetSentAudioFrames();
    }

    public void resetSentVideoFrames() {
        this.rtspSender.resetSentVideoFrames();
    }

    public void resetDroppedAudioFrames() {
        this.rtspSender.resetDroppedAudioFrames();
    }

    public void resetDroppedVideoFrames() {
        this.rtspSender.resetDroppedVideoFrames();
    }

    public void resizeCache(int newSize) throws RuntimeException {
        this.rtspSender.resizeCache(newSize);
    }

    public int getCacheSize() {
        return this.rtspSender.getCacheSize();
    }

    public long getSentAudioFrames() {
        return this.rtspSender.getSentAudioFrames();
    }

    public long getSentVideoFrames() {
        return this.rtspSender.getSentVideoFrames();
    }
}

