/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.network;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.SystemClock;
import com.pedro.rtplibrary.network.ConnectionClassManager;
import com.pedro.rtplibrary.network.QTagTxParser;
import java.util.concurrent.atomic.AtomicInteger;

@Deprecated
public class UploadBandwidthSampler {
    static final long SAMPLE_TIME = 1000L;
    private final ConnectionClassManager mConnectionClassManager;
    private AtomicInteger mSamplingCounter;
    private Handler mHandler;
    private HandlerThread mThread;
    private long mLastTimeReading;

    public static UploadBandwidthSampler getInstance() {
        return UploadBandwidthSamplerHolder.instance;
    }

    private UploadBandwidthSampler(ConnectionClassManager connectionClassManager) {
        this.mConnectionClassManager = connectionClassManager;
        this.mSamplingCounter = new AtomicInteger();
        this.mThread = new HandlerThread("ParseThread");
        this.mThread.start();
        this.mHandler = new SamplingHandler(this.mThread.getLooper());
    }

    public void startSampling() {
        if (this.mSamplingCounter.getAndIncrement() == 0) {
            this.mHandler.sendEmptyMessage(1);
            this.mLastTimeReading = SystemClock.elapsedRealtime();
        }
    }

    public void stopSampling() {
        if (this.mSamplingCounter.decrementAndGet() == 0) {
            this.mHandler.sendEmptyMessage(2);
        }
    }

    public boolean isSampling() {
        return this.mSamplingCounter.get() != 0;
    }

    private static class UploadBandwidthSamplerHolder {
        public static final UploadBandwidthSampler instance = new UploadBandwidthSampler(ConnectionClassManager.getInstance());

        private UploadBandwidthSamplerHolder() {
        }
    }

    private class SamplingHandler
    extends Handler {
        static final int MSG_START = 1;
        static final int MSG_STOP = 2;

        public SamplingHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.addSample();
                    this.sendEmptyMessageDelayed(1, 1000L);
                    break;
                }
                case 2: {
                    this.addSample();
                    this.removeMessages(1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown what=" + msg.what);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSample() {
            long byteDiff = QTagTxParser.getInstance().parseDataUsageForUidAndTag(Process.myUid());
            SamplingHandler samplingHandler = this;
            synchronized (samplingHandler) {
                long curTimeReading = SystemClock.elapsedRealtime();
                if (byteDiff != -1L) {
                    UploadBandwidthSampler.this.mConnectionClassManager.addBandwidth(byteDiff, curTimeReading - UploadBandwidthSampler.this.mLastTimeReading);
                }
                UploadBandwidthSampler.this.mLastTimeReading = curTimeReading;
            }
        }
    }
}

