/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.render.SimpleCameraRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.rtplibrary.R;
import com.pedro.rtplibrary.view.AspectRatioMode;
import com.pedro.rtplibrary.view.OpenGlViewBase;

@RequiresApi(api=18)
public class LightOpenGlView
extends OpenGlViewBase {
    private SimpleCameraRender simpleCameraRender = null;
    private boolean keepAspectRatio = false;
    private AspectRatioMode aspectRatioMode = AspectRatioMode.Adjust;
    private boolean isFlipHorizontal = false;
    private boolean isFlipVertical = false;

    public LightOpenGlView(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightOpenGlView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LightOpenGlView);
        try {
            this.keepAspectRatio = typedArray.getBoolean(R.styleable.LightOpenGlView_keepAspectRatio, false);
            this.aspectRatioMode = AspectRatioMode.fromId(typedArray.getInt(R.styleable.OpenGlView_aspectRatioMode, 0));
            this.isFlipHorizontal = typedArray.getBoolean(R.styleable.LightOpenGlView_isFlipHorizontal, false);
            this.isFlipVertical = typedArray.getBoolean(R.styleable.LightOpenGlView_isFlipVertical, false);
        }
        finally {
            typedArray.recycle();
        }
    }

    @Override
    public void init() {
        if (!this.initialized) {
            this.simpleCameraRender = new SimpleCameraRender();
        }
        this.simpleCameraRender.setFlip(this.isFlipHorizontal, this.isFlipVertical);
        this.initialized = true;
    }

    public boolean isKeepAspectRatio() {
        return this.keepAspectRatio;
    }

    public void setAspectRatioMode(AspectRatioMode aspectRatioMode) {
        this.aspectRatioMode = aspectRatioMode;
    }

    public void setKeepAspectRatio(boolean keepAspectRatio) {
        this.keepAspectRatio = keepAspectRatio;
    }

    public void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.simpleCameraRender.setFlip(isFlipHorizontal, isFlipVertical);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.i((String)"OpenGlViewBase", (String)("size: " + width + "x" + height));
        this.previewWidth = width;
        this.previewHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.surfaceManager.release();
        this.surfaceManager.eglSetup(this.getHolder().getSurface());
        this.surfaceManager.makeCurrent();
        this.simpleCameraRender.initGl(this.getContext(), this.encoderWidth, this.encoderHeight);
        this.simpleCameraRender.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.surfaceManagerPhoto.release();
        this.surfaceManagerPhoto.eglSetup(this.encoderWidth, this.encoderHeight, this.surfaceManager);
        this.semaphore.release();
        while (this.running) {
            if (!this.frameAvailable && !this.forceRender) continue;
            this.frameAvailable = false;
            this.surfaceManager.makeCurrent();
            this.simpleCameraRender.updateFrame();
            this.simpleCameraRender.drawFrame(this.previewWidth, this.previewHeight, this.keepAspectRatio, this.aspectRatioMode.id, 0, this.isPreviewVerticalFlip, this.isPreviewHorizontalFlip);
            this.surfaceManager.swapBuffer();
            Object object = this.sync;
            synchronized (object) {
                if (this.surfaceManagerEncoder.isReady() && !this.fpsLimiter.limitFPS()) {
                    int w = this.muteVideo ? 0 : this.encoderWidth;
                    int h = this.muteVideo ? 0 : this.encoderHeight;
                    this.surfaceManagerEncoder.makeCurrent();
                    this.simpleCameraRender.drawFrame(w, h, false, this.aspectRatioMode.id, this.streamRotation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
                    this.surfaceManagerEncoder.swapBuffer();
                }
                if (this.takePhotoCallback != null && this.surfaceManagerPhoto.isReady()) {
                    this.surfaceManagerPhoto.makeCurrent();
                    this.simpleCameraRender.drawFrame(this.encoderWidth, this.encoderHeight, false, this.aspectRatioMode.id, this.streamRotation, this.isStreamVerticalFlip, this.isStreamHorizontalFlip);
                    this.takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.encoderWidth, (int)this.encoderHeight));
                    this.takePhotoCallback = null;
                    this.surfaceManagerPhoto.swapBuffer();
                }
            }
        }
        this.simpleCameraRender.release();
        this.surfaceManagerPhoto.release();
        this.surfaceManagerEncoder.release();
        this.surfaceManager.release();
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.simpleCameraRender.getSurfaceTexture();
    }

    @Override
    public Surface getSurface() {
        return this.simpleCameraRender.getSurface();
    }

    @Override
    public void setFilter(int filterPosition, BaseFilterRender baseFilterRender) {
    }

    @Override
    public void addFilter(BaseFilterRender baseFilterRender) {
    }

    @Override
    public void addFilter(int filterPosition, BaseFilterRender baseFilterRender) {
    }

    @Override
    public void clearFilters() {
    }

    @Override
    public void removeFilter(int filterPosition) {
    }

    @Override
    public void removeFilter(BaseFilterRender baseFilterRender) {
    }

    @Override
    public int filtersCount() {
        return 0;
    }

    @Override
    public void setFilter(BaseFilterRender baseFilterRender) {
        this.addFilter(baseFilterRender);
    }

    @Override
    public void enableAA(boolean AAEnabled) {
    }

    @Override
    public void setRotation(int rotation) {
        this.simpleCameraRender.setRotation(rotation);
    }

    @Override
    public boolean isAAEnabled() {
        return false;
    }
}

