/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.decoder.AudioDecoder;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.LoopFileInterface;
import com.pedro.encoder.input.decoder.VideoDecoder;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.rtplibrary.base.recording.BaseRecordController;
import com.pedro.rtplibrary.base.recording.RecordController;
import com.pedro.rtplibrary.util.AndroidMuxerRecordController;
import com.pedro.rtplibrary.util.FpsListener;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OffScreenGlThread;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public abstract class FromFileBase
implements GetVideoData,
GetAacData,
GetMicrophoneData,
LoopFileInterface {
    private static final String TAG = "FromFileBase";
    protected VideoEncoder videoEncoder;
    private AudioEncoder audioEncoder;
    private GlInterface glInterface;
    private boolean streaming = false;
    protected BaseRecordController recordController;
    private final FpsListener fpsListener = new FpsListener();
    private VideoDecoder videoDecoder;
    private AudioDecoder audioDecoder;
    private VideoDecoderInterface videoDecoderInterface;
    private AudioDecoderInterface audioDecoderInterface;
    private String videoPath;
    private String audioPath;
    protected boolean videoEnabled = false;
    private boolean audioEnabled = false;
    private final Object sync = new Object();
    private AudioTrack audioTrackPlayer;

    public FromFileBase(VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    public FromFileBase(Context context, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.glInterface = new OffScreenGlThread(context);
        this.glInterface.init();
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    public FromFileBase(OpenGlView openGlView, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.glInterface = openGlView;
        this.glInterface.init();
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    public FromFileBase(LightOpenGlView lightOpenGlView, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.glInterface = lightOpenGlView;
        this.glInterface.init();
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    private void init(VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.videoDecoderInterface = videoDecoderInterface;
        this.audioDecoderInterface = audioDecoderInterface;
        this.videoEncoder = new VideoEncoder((GetVideoData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.videoDecoder = new VideoDecoder(videoDecoderInterface, (LoopFileInterface)this);
        this.audioDecoder = new AudioDecoder((GetMicrophoneData)this, audioDecoderInterface, (LoopFileInterface)this);
        this.recordController = new AndroidMuxerRecordController();
    }

    public void setFpsListener(FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(String filePath, int bitRate, int rotation, int avcProfile, int avcProfileLevel) throws IOException {
        this.videoPath = filePath;
        if (!this.videoDecoder.initExtractor(filePath)) {
            return false;
        }
        boolean result = this.videoEncoder.prepareVideoEncoder(this.videoDecoder.getWidth(), this.videoDecoder.getHeight(), 30, bitRate, rotation, 2, FormatVideoEncoder.SURFACE, avcProfile, avcProfileLevel);
        if (!result) {
            return false;
        }
        this.videoEnabled = result = this.videoDecoder.prepareVideo(this.videoEncoder.getInputSurface());
        return result;
    }

    public boolean prepareVideo(String filePath, int bitRate, int rotation) throws IOException {
        return this.prepareVideo(filePath, bitRate, rotation, -1, -1);
    }

    public boolean prepareVideo(String filePath) throws IOException {
        return this.prepareVideo(filePath, 1228800, 0);
    }

    public boolean prepareAudio(String filePath, int bitRate) throws IOException {
        this.audioPath = filePath;
        if (!this.audioDecoder.initExtractor(filePath)) {
            return false;
        }
        this.audioDecoder.prepareAudio();
        boolean result = this.audioEncoder.prepareAudioEncoder(bitRate, this.audioDecoder.getSampleRate(), this.audioDecoder.isStereo(), this.audioDecoder.getOutsize());
        this.prepareAudioRtp(this.audioDecoder.isStereo(), this.audioDecoder.getSampleRate());
        this.audioEnabled = result;
        return result;
    }

    public boolean isAudioDeviceEnabled() {
        return this.audioTrackPlayer != null && this.audioTrackPlayer.getPlayState() == 3;
    }

    public void playAudioDevice() {
        if (this.audioEnabled) {
            if (this.isAudioDeviceEnabled()) {
                this.audioTrackPlayer.stop();
            }
            int channel = this.audioDecoder.isStereo() ? 12 : 4;
            int buffSize = AudioTrack.getMinBufferSize((int)this.audioDecoder.getSampleRate(), (int)channel, (int)2);
            this.audioTrackPlayer = new AudioTrack(3, this.audioDecoder.getSampleRate(), channel, 2, buffSize, 1);
            this.audioTrackPlayer.play();
        }
    }

    public void stopAudioDevice() {
        if (this.audioEnabled && this.isAudioDeviceEnabled()) {
            this.audioTrackPlayer.stop();
            this.audioTrackPlayer = null;
        }
    }

    public boolean prepareAudio(String filePath) throws IOException {
        return this.prepareAudio(filePath, 65536);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        if (this.videoEnabled) {
            this.videoEncoder.setForce(forceVideo);
        }
        if (this.audioEnabled) {
            this.audioEncoder.setForce(forceAudio);
        }
    }

    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    public void startRecord(@NonNull String path) throws IOException {
        this.startRecord(path, null);
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(fd, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd) throws IOException {
        this.startRecord(fd, null);
    }

    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        } else if (this.videoEnabled) {
            this.requestKeyFrame();
        }
        this.startStreamRtp(url);
    }

    private void startEncoders() {
        if (this.videoEnabled) {
            this.videoEncoder.start();
        }
        if (this.audioTrackPlayer != null) {
            this.audioTrackPlayer.play();
        }
        if (this.audioEnabled) {
            this.audioEncoder.start();
        }
        if (this.videoEnabled) {
            this.prepareGlView();
        }
        if (this.videoEnabled) {
            this.videoDecoder.start();
        }
        if (this.audioEnabled) {
            this.audioDecoder.start();
        }
    }

    @RequiresApi(api=18)
    public void replaceView(Context context) {
        if (Build.VERSION.SDK_INT >= 18) {
            this.replaceGlInterface(new OffScreenGlThread(context));
        }
    }

    @RequiresApi(api=18)
    public void replaceView(OpenGlView openGlView) {
        this.replaceGlInterface(openGlView);
    }

    @RequiresApi(api=18)
    public void replaceView(LightOpenGlView lightOpenGlView) {
        this.replaceGlInterface(lightOpenGlView);
    }

    @RequiresApi(api=18)
    private void replaceGlInterface(GlInterface glInterface) {
        block7: {
            if (this.glInterface != null && Build.VERSION.SDK_INT >= 18 && this.videoEnabled) {
                if (this.isStreaming() || this.isRecording()) {
                    try {
                        this.glInterface.removeMediaCodecSurface();
                        this.glInterface.stop();
                        this.glInterface = glInterface;
                        this.glInterface.init();
                        this.prepareGlView();
                        if (Build.VERSION.SDK_INT >= 23) {
                            this.videoDecoder.changeOutputSurface(this.glInterface.getSurface());
                            break block7;
                        }
                        double time = this.videoDecoder.getTime();
                        this.videoDecoder.stop();
                        this.videoDecoder = new VideoDecoder(this.videoDecoderInterface, (LoopFileInterface)this);
                        if (!this.videoDecoder.initExtractor(this.videoPath)) {
                            throw new IOException("fail to reset video file");
                        }
                        this.videoDecoder.prepareVideo(this.glInterface.getSurface());
                        this.videoDecoder.start();
                        this.videoDecoder.moveTo(time);
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"Error", (Throwable)e);
                    }
                } else {
                    this.glInterface = glInterface;
                    this.glInterface.init();
                }
            }
        }
    }

    private void prepareGlView() {
        if (this.glInterface != null) {
            this.glInterface.setFps(this.videoEncoder.getFps());
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            this.glInterface.setRotation(0);
            this.glInterface.start();
            if (this.videoEncoder.getInputSurface() != null) {
                this.videoDecoder.changeOutputSurface(this.glInterface.getSurface());
                this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            }
        }
    }

    public void requestKeyFrame() {
        if (this.videoEncoder.isRunning()) {
            if (Build.VERSION.SDK_INT >= 19) {
                this.videoEncoder.requestKeyframe();
            } else {
                if (this.glInterface != null) {
                    this.glInterface.removeMediaCodecSurface();
                }
                this.videoEncoder.reset();
                if (this.glInterface != null) {
                    this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
                } else {
                    this.videoDecoder.reset(this.videoEncoder.getInputSurface());
                }
            }
        }
    }

    protected abstract void stopStreamRtp();

    public boolean reTry(long delay, String reason, @Nullable String backupUrl) {
        boolean result = this.shouldRetry(reason);
        if (result) {
            this.requestKeyFrame();
            this.reConnect(delay, backupUrl);
        }
        return result;
    }

    public boolean reTry(long delay, String reason) {
        return this.reTry(delay, reason, null);
    }

    protected abstract boolean shouldRetry(String var1);

    public abstract void setReTries(int var1);

    protected abstract void reConnect(long var1, @Nullable String var3);

    public abstract boolean hasCongestion();

    public abstract void resizeCache(int var1) throws RuntimeException;

    public abstract int getCacheSize();

    public abstract long getSentAudioFrames();

    public abstract long getSentVideoFrames();

    public abstract long getDroppedAudioFrames();

    public abstract long getDroppedVideoFrames();

    public abstract void resetSentAudioFrames();

    public abstract void resetSentVideoFrames();

    public abstract void resetDroppedAudioFrames();

    public abstract void resetDroppedVideoFrames();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recordController.isRecording()) {
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
            }
            if (this.videoEnabled) {
                this.videoDecoder.stop();
            }
            if (this.audioEnabled) {
                this.audioDecoder.stop();
            }
            if (this.audioEnabled && this.isAudioDeviceEnabled()) {
                this.audioTrackPlayer.stop();
            }
            this.audioTrackPlayer = null;
            if (this.videoEnabled) {
                this.videoEncoder.stop();
            }
            if (this.audioEnabled) {
                this.audioEncoder.stop();
            }
            this.recordController.resetFormats();
            this.videoEnabled = false;
            this.audioEnabled = false;
        }
    }

    public void setLoopMode(boolean loopMode) {
        if (this.videoEnabled) {
            this.videoDecoder.setLoopMode(loopMode);
        }
        if (this.audioEnabled) {
            this.audioDecoder.setLoopMode(loopMode);
        }
    }

    public void reSyncFile() {
        if (this.isStreaming() && this.videoEnabled && this.audioEnabled) {
            this.audioDecoder.moveTo(this.videoDecoder.getTime());
        }
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    @RequiresApi(api=19)
    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void setLimitFPSOnFly(int fps) {
        this.videoEncoder.setFps(fps);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    public double getVideoTime() {
        return this.videoDecoder.getTime();
    }

    public double getAudioTime() {
        return this.audioDecoder.getTime();
    }

    public double getVideoDuration() {
        return this.videoDecoder.getDuration();
    }

    public double getAudioDuration() {
        return this.audioDecoder.getDuration();
    }

    public void moveTo(double time) {
        if (this.videoEnabled) {
            this.videoDecoder.moveTo(time);
        }
        if (this.audioEnabled) {
            this.audioDecoder.moveTo(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReset(boolean isVideo) {
        Object object = this.sync;
        synchronized (object) {
            try {
                if (isVideo) {
                    if (this.glInterface != null) {
                        this.glInterface.removeMediaCodecSurface();
                        this.glInterface.stop();
                    }
                    if (this.videoEnabled) {
                        this.videoDecoder.stop();
                        if (!this.videoDecoder.initExtractor(this.videoPath)) {
                            throw new IOException("fail to reset video file");
                        }
                        this.prepareGlView();
                        this.videoDecoder.start();
                    }
                } else if (this.audioEnabled) {
                    this.audioDecoder.stop();
                    if (!this.audioDecoder.initExtractor(this.audioPath)) {
                        throw new IOException("fail to reset audio file");
                    }
                    this.audioDecoder.prepareAudio();
                    this.audioDecoder.start();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error", (Throwable)e);
                if (isVideo) {
                    this.videoDecoderInterface.onVideoDecoderFinished();
                }
                this.audioDecoderInterface.onAudioDecoderFinished();
            }
        }
    }

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    public void onSpsPpsVps(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.onSpsPpsVpsRtp(sps.duplicate(), pps.duplicate(), vps != null ? vps.duplicate() : null);
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getVideoData(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.fpsListener.calculateFps();
        this.recordController.recordVideo(h264Buffer, info);
        if (this.streaming) {
            this.getH264DataRtp(h264Buffer, info);
        }
    }

    public void onVideoFormat(MediaFormat mediaFormat) {
        this.recordController.setVideoFormat(mediaFormat, !this.audioEnabled);
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.recordController.recordAudio(aacBuffer, info);
        if (this.streaming) {
            this.getAacDataRtp(aacBuffer, info);
        }
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
        this.recordController.setAudioFormat(mediaFormat, !this.videoEnabled);
    }

    public void inputPCMData(Frame frame) {
        if (this.audioTrackPlayer != null) {
            this.audioTrackPlayer.write(frame.getBuffer(), frame.getOffset(), frame.getSize());
        }
        this.audioEncoder.inputPCMData(frame);
    }

    public void setRecordController(BaseRecordController recordController) {
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }

    public abstract void setLogs(boolean var1);

    public abstract void setCheckServerAlive(boolean var1);
}

