/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.util;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

public class RecordController {
    private static final String TAG = "RecordController";
    private Status status = Status.STOPPED;
    private MediaMuxer mediaMuxer;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;
    private int videoTrack = -1;
    private int audioTrack = -1;
    private Listener listener;
    private long pauseMoment = 0L;
    private long pauseTime = 0L;
    private final MediaCodec.BufferInfo videoInfo = new MediaCodec.BufferInfo();
    private final MediaCodec.BufferInfo audioInfo = new MediaCodec.BufferInfo();
    private String videoMime = "video/avc";
    private boolean isOnlyAudio = false;
    private boolean isOnlyVideo = false;

    @RequiresApi(api=18)
    public void startRecord(@NonNull String path, @Nullable Listener listener) throws IOException {
        this.mediaMuxer = new MediaMuxer(path, 0);
        this.listener = listener;
        this.status = Status.STARTED;
        if (listener != null) {
            listener.onStatusChange(this.status);
        }
        if (this.isOnlyAudio && this.audioFormat != null) {
            this.init();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable Listener listener) throws IOException {
        this.mediaMuxer = new MediaMuxer(fd, 0);
        this.listener = listener;
        this.status = Status.STARTED;
        if (listener != null) {
            listener.onStatusChange(this.status);
        }
        if (this.isOnlyAudio && this.audioFormat != null) {
            this.init();
        }
    }

    @RequiresApi(api=18)
    public void stopRecord() {
        this.status = Status.STOPPED;
        if (this.mediaMuxer != null) {
            try {
                this.mediaMuxer.stop();
                this.mediaMuxer.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mediaMuxer = null;
        this.videoTrack = -1;
        this.audioTrack = -1;
        this.pauseMoment = 0L;
        this.pauseTime = 0L;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    public void setVideoMime(String videoMime) {
        this.videoMime = videoMime;
    }

    public boolean isRunning() {
        return this.status == Status.STARTED || this.status == Status.RECORDING || this.status == Status.RESUMED || this.status == Status.PAUSED;
    }

    public boolean isRecording() {
        return this.status == Status.RECORDING;
    }

    public Status getStatus() {
        return this.status;
    }

    public void resetFormats() {
        this.videoFormat = null;
        this.audioFormat = null;
    }

    public void pauseRecord() {
        if (this.status == Status.RECORDING) {
            this.pauseMoment = System.nanoTime() / 1000L;
            this.status = Status.PAUSED;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
    }

    public void resumeRecord() {
        if (this.status == Status.PAUSED) {
            this.pauseTime += System.nanoTime() / 1000L - this.pauseMoment;
            this.status = Status.RESUMED;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
    }

    private boolean isKeyFrame(ByteBuffer videoBuffer) {
        byte[] header = new byte[5];
        videoBuffer.duplicate().get(header, 0, header.length);
        if (this.videoMime.equals("video/avc") && (header[4] & 0x1F) == 5) {
            return true;
        }
        return this.videoMime.equals("video/hevc") && (header[4] >> 1 & 0x3F) == 19 || (header[4] >> 1 & 0x3F) == 20;
    }

    @RequiresApi(api=18)
    private void write(int track, ByteBuffer byteBuffer, MediaCodec.BufferInfo info) {
        try {
            this.mediaMuxer.writeSampleData(track, byteBuffer, info);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            Log.i((String)TAG, (String)"Write error", (Throwable)e);
        }
    }

    @RequiresApi(api=18)
    private void init() {
        if (!this.isOnlyVideo) {
            this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
        }
        this.mediaMuxer.start();
        this.status = Status.RECORDING;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    @RequiresApi(api=18)
    public void recordVideo(ByteBuffer videoBuffer, MediaCodec.BufferInfo videoInfo) {
        if (this.status == Status.STARTED && this.videoFormat != null && (this.audioFormat != null || this.isOnlyVideo)) {
            if (videoInfo.flags == 1 || this.isKeyFrame(videoBuffer)) {
                this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
                this.init();
            }
        } else if (this.status == Status.RESUMED && (videoInfo.flags == 1 || this.isKeyFrame(videoBuffer))) {
            this.status = Status.RECORDING;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
        if (this.status == Status.RECORDING) {
            this.updateFormat(this.videoInfo, videoInfo);
            this.write(this.videoTrack, videoBuffer, this.videoInfo);
        }
    }

    @RequiresApi(api=18)
    public void recordAudio(ByteBuffer audioBuffer, MediaCodec.BufferInfo audioInfo) {
        if (this.status == Status.RECORDING) {
            this.updateFormat(this.audioInfo, audioInfo);
            this.write(this.audioTrack, audioBuffer, this.audioInfo);
        }
    }

    public void setVideoFormat(MediaFormat videoFormat, boolean isOnlyVideo) {
        this.videoFormat = videoFormat;
        this.isOnlyVideo = isOnlyVideo;
    }

    public void setAudioFormat(MediaFormat audioFormat, boolean isOnlyAudio) {
        this.audioFormat = audioFormat;
        this.isOnlyAudio = isOnlyAudio;
        if (isOnlyAudio && this.status == Status.STARTED && Build.VERSION.SDK_INT >= 18) {
            this.init();
        }
    }

    public void setVideoFormat(MediaFormat videoFormat) {
        this.setVideoFormat(videoFormat, false);
    }

    public void setAudioFormat(MediaFormat audioFormat) {
        this.setAudioFormat(audioFormat, false);
    }

    private void updateFormat(MediaCodec.BufferInfo newInfo, MediaCodec.BufferInfo oldInfo) {
        newInfo.flags = oldInfo.flags;
        newInfo.offset = oldInfo.offset;
        newInfo.size = oldInfo.size;
        newInfo.presentationTimeUs = oldInfo.presentationTimeUs - this.pauseTime;
    }

    public static interface Listener {
        public void onStatusChange(Status var1);
    }

    public static enum Status {
        STARTED,
        STOPPED,
        RECORDING,
        PAUSED,
        RESUMED;

    }
}

