/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.view.Surface;
import android.view.SurfaceView;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.rtplibrary.util.FpsListener;
import com.pedro.rtplibrary.util.RecordController;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.OffScreenGlThread;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public abstract class DisplayBase
implements GetAacData,
GetVideoData,
GetMicrophoneData {
    private OffScreenGlThread glInterface;
    protected Context context;
    private MediaProjection mediaProjection;
    private MediaProjectionManager mediaProjectionManager;
    protected VideoEncoder videoEncoder;
    private MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private boolean streaming = false;
    protected SurfaceView surfaceView;
    private boolean videoEnabled = true;
    private int dpi = 320;
    private VirtualDisplay virtualDisplay;
    private int resultCode = -1;
    private Intent data;
    private RecordController recordController;
    private FpsListener fpsListener = new FpsListener();

    public DisplayBase(Context context, boolean useOpengl) {
        this.context = context;
        if (useOpengl) {
            this.glInterface = new OffScreenGlThread(context);
            this.glInterface.init();
        }
        this.mediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
        this.surfaceView = null;
        this.videoEncoder = new VideoEncoder((GetVideoData)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
        this.recordController = new RecordController();
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.microphoneManager.setCustomAudioEffect(customAudioEffect);
    }

    public void setFpsListener(FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation, int dpi, int avcProfile, int avcProfileLevel, int iFrameInterval) {
        this.dpi = dpi;
        boolean result = this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, this.glInterface == null, iFrameInterval, FormatVideoEncoder.SURFACE, avcProfile, avcProfileLevel);
        if (this.glInterface != null) {
            this.glInterface = new OffScreenGlThread(this.context);
            this.glInterface.init();
            if (rotation == 90 || rotation == 270) {
                this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
        }
        return result;
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation, int dpi) {
        return this.prepareVideo(width, height, fps, bitrate, rotation, dpi, -1, -1, 2);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        this.microphoneManager.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        this.prepareAudioRtp(isStereo, sampleRate);
        return this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo, this.microphoneManager.getMaxInputSize());
    }

    @RequiresApi(api=29)
    public boolean prepareInternalAudio(int bitrate, int sampleRate, boolean isStereo) {
        if (this.mediaProjection == null) {
            this.mediaProjection = this.mediaProjectionManager.getMediaProjection(this.resultCode, this.data);
        }
        AudioPlaybackCaptureConfiguration config = new AudioPlaybackCaptureConfiguration.Builder(this.mediaProjection).addMatchingUsage(1).addMatchingUsage(14).addMatchingUsage(0).build();
        this.microphoneManager.createInternalMicrophone(config, sampleRate, isStereo);
        this.prepareAudioRtp(isStereo, sampleRate);
        return this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo, this.microphoneManager.getMaxInputSize());
    }

    public boolean prepareVideo() {
        return this.prepareVideo(640, 480, 30, 1228800, 0, 320);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    public void startRecord(String path, RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders(this.resultCode, this.data);
        } else if (this.videoEncoder.isRunning()) {
            this.resetVideoEncoder();
        }
    }

    public void startRecord(String path) throws IOException {
        this.startRecord(path, null);
    }

    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    protected abstract void startStreamRtp(String var1);

    public Intent sendIntent() {
        return this.mediaProjectionManager.createScreenCaptureIntent();
    }

    public void setIntentResult(int resultCode, Intent data) {
        this.resultCode = resultCode;
        this.data = data;
    }

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders(this.resultCode, this.data);
        } else {
            this.resetVideoEncoder();
        }
        this.startStreamRtp(url);
    }

    private void startEncoders(int resultCode, Intent data) {
        Surface surface;
        if (data == null) {
            throw new RuntimeException("You need send intent data before startRecord or startStream");
        }
        this.videoEncoder.start();
        this.audioEncoder.start();
        if (this.glInterface != null) {
            this.glInterface.setFps(this.videoEncoder.getFps());
            this.glInterface.start();
            this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
        }
        Surface surface2 = surface = this.glInterface != null ? this.glInterface.getSurface() : this.videoEncoder.getInputSurface();
        if (this.mediaProjection == null) {
            this.mediaProjection = this.mediaProjectionManager.getMediaProjection(resultCode, data);
        }
        this.virtualDisplay = this.glInterface != null && this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270 ? this.mediaProjection.createVirtualDisplay("Stream Display", this.videoEncoder.getHeight(), this.videoEncoder.getWidth(), this.dpi, 0, surface, null, null) : this.mediaProjection.createVirtualDisplay("Stream Display", this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.dpi, 0, surface, null, null);
        this.microphoneManager.start();
    }

    private void resetVideoEncoder() {
        this.virtualDisplay.setSurface(null);
        if (this.glInterface != null) {
            this.glInterface.removeMediaCodecSurface();
        }
        this.videoEncoder.reset();
        if (this.glInterface != null) {
            this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
        }
        this.virtualDisplay.setSurface(this.glInterface != null ? this.glInterface.getSurface() : this.videoEncoder.getInputSurface());
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recordController.isRecording()) {
            this.microphoneManager.stop();
            if (this.mediaProjection != null) {
                this.mediaProjection.stop();
            }
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
            }
            this.videoEncoder.stop();
            this.audioEncoder.stop();
            this.data = null;
            this.recordController.resetFormats();
        }
    }

    public boolean reTry(long delay, String reason) {
        boolean result = this.shouldRetry(reason);
        if (result) {
            this.reTry(delay);
        }
        return result;
    }

    @Deprecated
    public void reTry(long delay) {
        this.resetVideoEncoder();
        this.reConnect(delay);
    }

    @Deprecated
    public abstract boolean shouldRetry(String var1);

    public abstract void setReTries(int var1);

    protected abstract void reConnect(long var1);

    public abstract void resizeCache(int var1) throws RuntimeException;

    public abstract int getCacheSize();

    public abstract long getSentAudioFrames();

    public abstract long getSentVideoFrames();

    public abstract long getDroppedAudioFrames();

    public abstract long getDroppedVideoFrames();

    public abstract void resetSentAudioFrames();

    public abstract void resetSentVideoFrames();

    public abstract void resetDroppedAudioFrames();

    public abstract void resetDroppedVideoFrames();

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void setLimitFPSOnFly(int fps) {
        this.videoEncoder.setFps(fps);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.recordController.recordAudio(aacBuffer, info);
        if (this.streaming) {
            this.getAacDataRtp(aacBuffer, info);
        }
    }

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    public void onSpsPps(ByteBuffer sps, ByteBuffer pps) {
        if (this.streaming) {
            this.onSpsPpsVpsRtp(sps, pps, null);
        }
    }

    public void onSpsPpsVps(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        if (this.streaming) {
            this.onSpsPpsVpsRtp(sps, pps, vps);
        }
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getVideoData(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.fpsListener.calculateFps();
        this.recordController.recordVideo(h264Buffer, info);
        if (this.streaming) {
            this.getH264DataRtp(h264Buffer, info);
        }
    }

    public void inputPCMData(Frame frame) {
        this.audioEncoder.inputPCMData(frame);
    }

    public void onVideoFormat(MediaFormat mediaFormat) {
        this.recordController.setVideoFormat(mediaFormat);
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
        this.recordController.setAudioFormat(mediaFormat);
    }
}

