/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.SimpleCameraRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GlUtil;
import com.pedro.rtplibrary.R;
import com.pedro.rtplibrary.view.OpenGlViewBase;

@RequiresApi(api=18)
public class LightOpenGlView
extends OpenGlViewBase {
    private SimpleCameraRender simpleCameraRender = null;
    private boolean keepAspectRatio = false;
    private boolean isFlipHorizontal = false;
    private boolean isFlipVertical = false;

    public LightOpenGlView(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightOpenGlView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LightOpenGlView);
        try {
            this.keepAspectRatio = typedArray.getBoolean(R.styleable.LightOpenGlView_keepAspectRatio, false);
            this.isFlipHorizontal = typedArray.getBoolean(R.styleable.LightOpenGlView_isFlipHorizontal, false);
            this.isFlipVertical = typedArray.getBoolean(R.styleable.LightOpenGlView_isFlipVertical, false);
        }
        finally {
            typedArray.recycle();
        }
    }

    @Override
    public void init() {
        if (!this.initialized) {
            this.simpleCameraRender = new SimpleCameraRender();
        }
        this.simpleCameraRender.setFlip(this.isFlipHorizontal, this.isFlipVertical);
        this.initialized = true;
    }

    public boolean isKeepAspectRatio() {
        return this.keepAspectRatio;
    }

    public void setKeepAspectRatio(boolean keepAspectRatio) {
        this.keepAspectRatio = keepAspectRatio;
    }

    public void setCameraFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        this.simpleCameraRender.setFlip(isFlipHorizontal, isFlipVertical);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.i((String)"OpenGlViewBase", (String)("size: " + width + "x" + height));
        this.previewWidth = width;
        this.previewHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.releaseSurfaceManager();
        this.surfaceManager = new SurfaceManager(this.getHolder().getSurface());
        this.surfaceManager.makeCurrent();
        this.simpleCameraRender.initGl(this.getContext(), this.encoderWidth, this.encoderHeight);
        this.simpleCameraRender.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.semaphore.release();
        while (this.running) {
            if (!this.frameAvailable) continue;
            this.frameAvailable = false;
            this.surfaceManager.makeCurrent();
            this.simpleCameraRender.updateFrame();
            this.simpleCameraRender.drawFrame(this.previewWidth, this.previewHeight, this.keepAspectRatio);
            this.surfaceManager.swapBuffer();
            if (this.takePhotoCallback != null) {
                this.takePhotoCallback.onTakePhoto(GlUtil.getBitmap((int)this.previewWidth, (int)this.previewHeight, (int)this.encoderWidth, (int)this.encoderHeight));
                this.takePhotoCallback = null;
            }
            Object object = this.sync;
            synchronized (object) {
                if (this.surfaceManagerEncoder != null && !this.fpsLimiter.limitFPS()) {
                    this.surfaceManagerEncoder.makeCurrent();
                    this.simpleCameraRender.drawFrame(this.encoderWidth, this.encoderHeight, false);
                    this.surfaceManagerEncoder.swapBuffer();
                }
            }
        }
        this.simpleCameraRender.release();
        this.releaseSurfaceManager();
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.simpleCameraRender.getSurfaceTexture();
    }

    @Override
    public Surface getSurface() {
        return this.simpleCameraRender.getSurface();
    }

    @Override
    public void setFilter(int filterPosition, BaseFilterRender baseFilterRender) {
    }

    @Override
    public void setFilter(BaseFilterRender baseFilterRender) {
        this.setFilter(0, baseFilterRender);
    }

    @Override
    public void enableAA(boolean AAEnabled) {
    }

    @Override
    public void setRotation(int rotation) {
        this.simpleCameraRender.setRotation(rotation);
    }

    @Override
    public boolean isAAEnabled() {
        return false;
    }
}

