/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.util;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import androidx.annotation.RequiresApi;
import java.io.IOException;
import java.nio.ByteBuffer;

public class RecordController {
    private Status status = Status.STOPPED;
    private MediaMuxer mediaMuxer;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;
    private int videoTrack = -1;
    private int audioTrack = -1;
    private Listener listener;
    private long pauseMoment = 0L;
    private long pauseTime = 0L;
    private MediaCodec.BufferInfo videoInfo = new MediaCodec.BufferInfo();
    private MediaCodec.BufferInfo audioInfo = new MediaCodec.BufferInfo();

    @RequiresApi(api=18)
    public void startRecord(String path, Listener listener) throws IOException {
        this.mediaMuxer = new MediaMuxer(path, 0);
        this.listener = listener;
        this.status = Status.STARTED;
        if (listener != null) {
            listener.onStatusChange(this.status);
        }
    }

    @RequiresApi(api=18)
    public void stopRecord() {
        this.status = Status.STOPPED;
        if (this.mediaMuxer != null) {
            try {
                this.mediaMuxer.stop();
                this.mediaMuxer.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mediaMuxer = null;
        this.videoTrack = -1;
        this.audioTrack = -1;
        this.pauseMoment = 0L;
        this.pauseTime = 0L;
        if (this.listener != null) {
            this.listener.onStatusChange(this.status);
        }
    }

    public boolean isRunning() {
        return this.status == Status.STARTED || this.status == Status.RECORDING || this.status == Status.RESUMED || this.status == Status.PAUSED;
    }

    public boolean isRecording() {
        return this.status == Status.RECORDING;
    }

    public Status getStatus() {
        return this.status;
    }

    public void resetFormats() {
        this.videoFormat = null;
        this.audioFormat = null;
    }

    public void pauseRecord() {
        if (this.status == Status.RECORDING) {
            this.pauseMoment = System.nanoTime() / 1000L;
            this.status = Status.PAUSED;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
    }

    public void resumeRecord() {
        if (this.status == Status.PAUSED) {
            this.pauseTime += System.nanoTime() / 1000L - this.pauseMoment;
            this.status = Status.RESUMED;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
    }

    @RequiresApi(api=18)
    public void recordVideo(ByteBuffer videoBuffer, MediaCodec.BufferInfo videoInfo) {
        if (this.status == Status.STARTED && videoInfo.flags == 1 && this.videoFormat != null && this.audioFormat != null) {
            this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
            this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
            this.mediaMuxer.start();
            this.status = Status.RECORDING;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        } else if (this.status == Status.RESUMED && videoInfo.flags == 1) {
            this.status = Status.RECORDING;
            if (this.listener != null) {
                this.listener.onStatusChange(this.status);
            }
        }
        if (this.status == Status.RECORDING) {
            this.updateFormat(this.videoInfo, videoInfo);
            this.mediaMuxer.writeSampleData(this.videoTrack, videoBuffer, this.videoInfo);
        }
    }

    @RequiresApi(api=18)
    public void recordAudio(ByteBuffer audioBuffer, MediaCodec.BufferInfo audioInfo) {
        if (this.status == Status.RECORDING) {
            this.updateFormat(this.audioInfo, audioInfo);
            this.mediaMuxer.writeSampleData(this.audioTrack, audioBuffer, this.audioInfo);
        }
    }

    public void setVideoFormat(MediaFormat videoFormat) {
        this.videoFormat = videoFormat;
    }

    public void setAudioFormat(MediaFormat audioFormat) {
        this.audioFormat = audioFormat;
    }

    private void updateFormat(MediaCodec.BufferInfo newInfo, MediaCodec.BufferInfo oldInfo) {
        newInfo.flags = oldInfo.flags;
        newInfo.offset = oldInfo.offset;
        newInfo.size = oldInfo.size;
        newInfo.presentationTimeUs = oldInfo.presentationTimeUs - this.pauseTime;
    }

    public static interface Listener {
        public void onStatusChange(Status var1);
    }

    public static enum Status {
        STARTED,
        STOPPED,
        RECORDING,
        PAUSED,
        RESUMED;

    }
}

