/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.rtmp;

import android.content.Context;
import android.media.MediaCodec;
import android.support.annotation.RequiresApi;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.rtplibrary.base.FromFileBase;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OpenGlView;
import java.nio.ByteBuffer;
import net.ossrs.rtmp.ConnectCheckerRtmp;
import net.ossrs.rtmp.SrsFlvMuxer;

@RequiresApi(api=18)
public class RtmpFromFile
extends FromFileBase {
    private SrsFlvMuxer srsFlvMuxer;

    public RtmpFromFile(ConnectCheckerRtmp connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(videoDecoderInterface, audioDecoderInterface);
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    public RtmpFromFile(Context context, ConnectCheckerRtmp connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(context, videoDecoderInterface, audioDecoderInterface);
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    public RtmpFromFile(OpenGlView openGlView, ConnectCheckerRtmp connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(openGlView, videoDecoderInterface, audioDecoderInterface);
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    public RtmpFromFile(LightOpenGlView lightOpenGlView, ConnectCheckerRtmp connectChecker, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(lightOpenGlView, videoDecoderInterface, audioDecoderInterface);
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    public void setProfileIop(byte profileIop) {
        this.srsFlvMuxer.setProfileIop(profileIop);
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.srsFlvMuxer.setAuthorization(user, password);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.srsFlvMuxer.setIsStereo(isStereo);
        this.srsFlvMuxer.setSampleRate(sampleRate);
    }

    @Override
    protected void startStreamRtp(String url) {
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            this.srsFlvMuxer.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            this.srsFlvMuxer.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        this.srsFlvMuxer.start(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.srsFlvMuxer.stop();
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.srsFlvMuxer.setSpsPPs(sps, pps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.srsFlvMuxer.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.srsFlvMuxer.sendAudio(aacBuffer, info);
    }
}

