/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.rtmp;

import android.content.Context;
import android.media.MediaCodec;
import android.support.annotation.RequiresApi;
import android.view.SurfaceView;
import android.view.TextureView;
import com.pedro.rtplibrary.base.Camera1Base;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OpenGlView;
import java.nio.ByteBuffer;
import net.ossrs.rtmp.ConnectCheckerRtmp;
import net.ossrs.rtmp.SrsFlvMuxer;

public class RtmpCamera1
extends Camera1Base {
    private SrsFlvMuxer srsFlvMuxer;

    public RtmpCamera1(SurfaceView surfaceView, ConnectCheckerRtmp connectChecker) {
        super(surfaceView);
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    public RtmpCamera1(TextureView textureView, ConnectCheckerRtmp connectChecker) {
        super(textureView);
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    @RequiresApi(api=18)
    public RtmpCamera1(OpenGlView openGlView, ConnectCheckerRtmp connectChecker) {
        super(openGlView);
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    @RequiresApi(api=18)
    public RtmpCamera1(LightOpenGlView lightOpenGlView, ConnectCheckerRtmp connectChecker) {
        super(lightOpenGlView);
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    @RequiresApi(api=18)
    public RtmpCamera1(Context context, ConnectCheckerRtmp connectChecker) {
        super(context);
        this.srsFlvMuxer = new SrsFlvMuxer(connectChecker);
    }

    public void setProfileIop(byte profileIop) {
        this.srsFlvMuxer.setProfileIop(profileIop);
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.srsFlvMuxer.setAuthorization(user, password);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.srsFlvMuxer.setIsStereo(isStereo);
        this.srsFlvMuxer.setSampleRate(sampleRate);
    }

    @Override
    protected void startStreamRtp(String url) {
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            this.srsFlvMuxer.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            this.srsFlvMuxer.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        this.srsFlvMuxer.start(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.srsFlvMuxer.stop();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.srsFlvMuxer.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.srsFlvMuxer.setSpsPPs(sps, pps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.srsFlvMuxer.sendVideo(h264Buffer, info);
    }
}

