/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.support.annotation.RequiresApi;
import android.util.Size;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.video.Camera2ApiManager;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.LightOpenGlView;
import com.pedro.rtplibrary.view.OffScreenGlThread;
import com.pedro.rtplibrary.view.OpenGlView;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

@RequiresApi(api=21)
public abstract class Camera2Base
implements GetAacData,
GetVideoData,
GetMicrophoneData {
    protected Context context;
    private Camera2ApiManager cameraManager;
    protected VideoEncoder videoEncoder;
    private MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private boolean streaming = false;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private GlInterface glInterface;
    private boolean videoEnabled = false;
    private MediaMuxer mediaMuxer;
    private int videoTrack = -1;
    private int audioTrack = -1;
    private boolean recording = false;
    private boolean canRecord = false;
    private boolean onPreview = false;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;
    private boolean isBackground = false;

    public Camera2Base(SurfaceView surfaceView) {
        this.surfaceView = surfaceView;
        this.context = surfaceView.getContext();
        this.init(this.context);
    }

    public Camera2Base(TextureView textureView) {
        this.textureView = textureView;
        this.context = textureView.getContext();
        this.init(this.context);
    }

    public Camera2Base(OpenGlView openGlView) {
        this.context = openGlView.getContext();
        this.glInterface = openGlView;
        this.glInterface.init();
        this.init(this.context);
    }

    public Camera2Base(LightOpenGlView lightOpenGlView) {
        this.context = lightOpenGlView.getContext();
        this.glInterface = lightOpenGlView;
        this.glInterface.init();
        this.init(this.context);
    }

    public Camera2Base(Context context, boolean useOpengl) {
        this.context = context;
        if (useOpengl) {
            this.glInterface = new OffScreenGlThread(context);
            this.glInterface.init();
        }
        this.isBackground = true;
        this.init(context);
    }

    private void init(Context context) {
        this.cameraManager = new Camera2ApiManager(context);
        this.videoEncoder = new VideoEncoder((GetVideoData)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
    }

    public void enableFaceDetection(Camera2ApiManager.FaceDetectorCallback faceDetectorCallback) {
        this.cameraManager.enableFaceDetection(faceDetectorCallback);
    }

    public void disableFaceDetection() {
        this.cameraManager.disableFaceDetection();
    }

    public boolean isFaceDetectionEnabled() {
        return this.cameraManager.isFaceDetectionEnabled();
    }

    public boolean isFrontCamera() {
        return this.cameraManager.isFrontCamera();
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(int width, int height, int fps, int bitrate, boolean hardwareRotation, int iFrameInterval, int rotation) {
        if (this.onPreview) {
            this.stopPreview();
            this.onPreview = true;
        }
        boolean result = this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, hardwareRotation, iFrameInterval, FormatVideoEncoder.SURFACE);
        this.prepareCameraManager();
        return result;
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, boolean hardwareRotation, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, hardwareRotation, 2, rotation);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        this.microphoneManager.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        this.prepareAudioRtp(isStereo, sampleRate);
        return this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo);
    }

    public boolean prepareVideo() {
        boolean isHardwareRotation = this.glInterface == null;
        int rotation = CameraHelper.getCameraOrientation((Context)this.context);
        return this.prepareVideo(640, 480, 30, 1228800, isHardwareRotation, rotation);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    public void startRecord(String path) throws IOException {
        this.mediaMuxer = new MediaMuxer(path, 0);
        this.recording = true;
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.resetVideoEncoder();
        }
    }

    public void stopRecord() {
        this.recording = false;
        if (this.mediaMuxer != null) {
            if (this.canRecord) {
                this.mediaMuxer.stop();
                this.mediaMuxer.release();
                this.canRecord = false;
            }
            this.mediaMuxer = null;
        }
        this.videoTrack = -1;
        this.audioTrack = -1;
        if (!this.streaming) {
            this.stopStream();
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int rotation) {
        if (!(this.isStreaming() || this.onPreview || this.isBackground)) {
            if (this.surfaceView != null) {
                this.cameraManager.prepareCamera(this.surfaceView.getHolder().getSurface());
            } else if (this.textureView != null) {
                this.cameraManager.prepareCamera(new Surface(this.textureView.getSurfaceTexture()));
            } else if (this.glInterface != null) {
                boolean isCamera2Landscape;
                boolean bl = isCamera2Landscape = this.context.getResources().getConfiguration().orientation != 1;
                if (isCamera2Landscape) {
                    this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
                } else {
                    this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
                }
                this.glInterface.setRotation(rotation == 0 ? 270 : rotation - 90);
                this.glInterface.start();
                this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            this.cameraManager.openCameraFacing(cameraFacing);
            this.onPreview = true;
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing) {
        this.startPreview(cameraFacing, CameraHelper.getCameraOrientation((Context)this.context));
    }

    public void startPreview() {
        this.startPreview(CameraHelper.Facing.BACK);
    }

    public void stopPreview() {
        if (!this.isStreaming() && this.onPreview && !this.isBackground) {
            if (this.glInterface != null) {
                this.glInterface.stop();
            }
            this.cameraManager.closeCamera(false);
            this.onPreview = false;
        }
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recording) {
            this.startEncoders();
        } else {
            this.resetVideoEncoder();
        }
        this.startStreamRtp(url);
        this.onPreview = true;
    }

    private void startEncoders() {
        this.videoEncoder.start();
        this.audioEncoder.start();
        this.prepareGlView();
        this.microphoneManager.start();
        if (this.onPreview) {
            this.cameraManager.openLastCamera();
        } else {
            this.cameraManager.openCameraBack();
        }
        this.onPreview = true;
    }

    private void resetVideoEncoder() {
        if (this.glInterface != null) {
            this.glInterface.removeMediaCodecSurface();
        }
        this.videoEncoder.reset();
        if (this.glInterface != null) {
            this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
        } else {
            this.cameraManager.closeCamera(false);
            this.cameraManager.prepareCamera(this.videoEncoder.getInputSurface());
            this.cameraManager.openLastCamera();
        }
    }

    private void prepareGlView() {
        if (this.glInterface != null && this.videoEnabled) {
            if (this.glInterface instanceof OffScreenGlThread) {
                this.glInterface = new OffScreenGlThread(this.context);
                this.glInterface.init();
                ((OffScreenGlThread)this.glInterface).setFps(this.videoEncoder.getFps());
            }
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            int rotation = this.videoEncoder.getRotation();
            this.glInterface.setRotation(rotation == 0 ? 270 : rotation - 90);
            this.glInterface.start();
            if (this.videoEncoder.getInputSurface() != null) {
                this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            }
            this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recording) {
            this.cameraManager.closeCamera(!this.isBackground);
            this.onPreview = !this.isBackground;
            this.microphoneManager.stop();
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                if (this.glInterface instanceof OffScreenGlThread) {
                    this.glInterface.removeMediaCodecSurface();
                    this.glInterface.stop();
                }
            }
            this.videoEncoder.stop();
            this.audioEncoder.stop();
            this.videoFormat = null;
            this.audioFormat = null;
        }
    }

    public List<Size> getResolutionsBack() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsBack());
    }

    public List<Size> getResolutionsFront() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsFront());
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public void disableVideo() {
        this.videoEncoder.startSendBlackImage();
        this.videoEnabled = false;
    }

    public void enableVideo() {
        this.videoEncoder.stopSendBlackImage();
        this.videoEnabled = true;
    }

    public void setZoom(MotionEvent event) {
        this.cameraManager.setZoom(event);
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    public void switchCamera() throws CameraOpenException {
        if (this.isStreaming() || this.onPreview) {
            this.cameraManager.switchCamera();
        }
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    private void prepareCameraManager() {
        if (this.textureView != null) {
            this.cameraManager.prepareCamera(this.textureView, this.videoEncoder.getInputSurface());
        } else if (this.surfaceView != null) {
            this.cameraManager.prepareCamera(this.surfaceView, this.videoEncoder.getInputSurface());
        } else if (this.glInterface == null) {
            this.cameraManager.prepareCamera(this.videoEncoder.getInputSurface());
        }
        this.videoEnabled = true;
    }

    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void setLimitFPSOnFly(int fps) {
        this.videoEncoder.setFps(fps);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isOnPreview() {
        return this.onPreview;
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        if (this.canRecord && this.recording) {
            this.mediaMuxer.writeSampleData(this.audioTrack, aacBuffer, info);
        }
        if (this.streaming) {
            this.getAacDataRtp(aacBuffer, info);
        }
    }

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    public void onSpsPps(ByteBuffer sps, ByteBuffer pps) {
        if (this.streaming) {
            this.onSpsPpsVpsRtp(sps, pps, null);
        }
    }

    public void onSpsPpsVps(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        if (this.streaming) {
            this.onSpsPpsVpsRtp(sps, pps, vps);
        }
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getVideoData(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        if (this.recording) {
            if (info.flags == 1 && !this.canRecord && this.videoFormat != null && this.audioFormat != null) {
                this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
                this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
                this.mediaMuxer.start();
                this.canRecord = true;
            }
            if (this.canRecord) {
                this.mediaMuxer.writeSampleData(this.videoTrack, h264Buffer, info);
            }
        }
        if (this.streaming) {
            this.getH264DataRtp(h264Buffer, info);
        }
    }

    public void inputPCMData(byte[] buffer, int size) {
        this.audioEncoder.inputPCMData(buffer, size);
    }

    public void onVideoFormat(MediaFormat mediaFormat) {
        this.videoFormat = mediaFormat;
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
        this.audioFormat = mediaFormat;
    }
}

