/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.network;

import android.os.StrictMode;
import android.util.Log;
import com.pedro.rtplibrary.network.ByteArrayScanner;
import com.pedro.rtplibrary.network.LineBufferReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;

class QTagTxParser {
    private static final String TAG = "QTagParser";
    private static final String QTAGUID_UID_STATS = "/proc/net/xt_qtaguid/stats";
    private static final ThreadLocal<byte[]> sLineBuffer = new ThreadLocal<byte[]>(){

        @Override
        public byte[] initialValue() {
            return new byte[512];
        }
    };
    private static long sPreviousBytes = -1L;
    private static LineBufferReader sStatsReader = new LineBufferReader();
    private static ByteArrayScanner sScanner = new ByteArrayScanner();
    public static QTagTxParser sInstance;
    private String mPath;

    public static synchronized QTagTxParser getInstance() {
        if (sInstance == null) {
            sInstance = new QTagTxParser(QTAGUID_UID_STATS);
        }
        return sInstance;
    }

    public QTagTxParser(String path) {
        this.mPath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long parseDataUsageForUidAndTag(int uid) {
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        try {
            long tagTxBytes = 0L;
            FileInputStream fis = new FileInputStream(this.mPath);
            sStatsReader.setFileStream(fis);
            byte[] buffer = sLineBuffer.get();
            try {
                int length;
                sStatsReader.skipLine();
                int line = 2;
                while ((length = sStatsReader.readLine(buffer)) != -1) {
                    try {
                        sScanner.reset(buffer, length);
                        sScanner.useDelimiter(' ');
                        sScanner.skip();
                        if (sScanner.nextStringEquals("lo")) continue;
                        sScanner.skip();
                        if (sScanner.nextInt() != uid) continue;
                        sScanner.skip();
                        sScanner.skip();
                        sScanner.skip();
                        int txBytes = sScanner.nextInt();
                        tagTxBytes += (long)txBytes;
                        ++line;
                    }
                    catch (NumberFormatException e) {
                        Log.e((String)TAG, (String)("Cannot parse byte count at line" + line + "."));
                    }
                    catch (NoSuchElementException e) {
                        Log.e((String)TAG, (String)("Invalid number of tokens on line " + line + "."));
                    }
                }
            }
            finally {
                fis.close();
            }
            if (sPreviousBytes == -1L) {
                sPreviousBytes = tagTxBytes;
                long length = -1L;
                return length;
            }
            long diff = tagTxBytes - sPreviousBytes;
            sPreviousBytes = tagTxBytes;
            long l = diff;
            return l;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error reading from /proc/net/xt_qtaguid/stats. Please check if this file exists.");
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)savedPolicy);
        }
        return -1L;
    }
}

