/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.view;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.SimpleCameraRender;
import java.util.concurrent.Semaphore;

@RequiresApi(api=18)
public class LightOpenGlView
extends SurfaceView
implements Runnable,
SurfaceTexture.OnFrameAvailableListener,
SurfaceHolder.Callback {
    public static final String TAG = "OpenGlView";
    private Thread thread = null;
    private boolean frameAvailable = false;
    private boolean running = false;
    private boolean initialized = false;
    private SurfaceManager surfaceManager = null;
    private SurfaceManager surfaceManagerEncoder = null;
    private SimpleCameraRender simpleCameraRender = null;
    private final Semaphore semaphore = new Semaphore(0);
    private final Object sync = new Object();
    private int previewWidth;
    private int previewHeight;
    private int encoderWidth;
    private int encoderHeight;
    private boolean isCamera2Landscape = false;
    private int waitTime = 200;

    public LightOpenGlView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void init() {
        if (!this.initialized) {
            this.simpleCameraRender = new SimpleCameraRender();
        }
        this.initialized = true;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.simpleCameraRender.getSurfaceTexture();
    }

    public Surface getSurface() {
        return this.simpleCameraRender.getSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaCodecSurface(Surface surface) {
        Object object = this.sync;
        synchronized (object) {
            this.surfaceManagerEncoder = new SurfaceManager(surface, this.surfaceManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaCodecSurface() {
        Object object = this.sync;
        synchronized (object) {
            if (this.surfaceManagerEncoder != null) {
                this.surfaceManagerEncoder.release();
                this.surfaceManagerEncoder = null;
            }
        }
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    public void startGLThread(boolean isCamera2Landscape) {
        this.isCamera2Landscape = isCamera2Landscape;
        Log.i((String)TAG, (String)"Thread started.");
        this.thread = new Thread(this);
        this.running = true;
        this.thread.start();
        this.semaphore.acquireUninterruptibly();
    }

    public void stopGlThread() {
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.surfaceManager = new SurfaceManager(this.getHolder().getSurface());
        this.surfaceManager.makeCurrent();
        this.simpleCameraRender.isCamera2LandScape(this.isCamera2Landscape);
        this.simpleCameraRender.initGl(this.getContext());
        this.simpleCameraRender.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.semaphore.release();
        try {
            while (this.running) {
                Object object = this.sync;
                synchronized (object) {
                    this.sync.wait(this.waitTime);
                    if (this.frameAvailable) {
                        this.frameAvailable = false;
                        this.surfaceManager.makeCurrent();
                        this.simpleCameraRender.updateFrame();
                        this.simpleCameraRender.drawFrame(this.previewWidth, this.previewHeight);
                        this.surfaceManager.swapBuffer();
                        Object object2 = this.sync;
                        synchronized (object2) {
                            if (this.surfaceManagerEncoder != null) {
                                this.surfaceManagerEncoder.makeCurrent();
                                this.simpleCameraRender.drawFrame(this.encoderWidth, this.encoderHeight);
                                long ts = this.simpleCameraRender.getSurfaceTexture().getTimestamp();
                                this.surfaceManagerEncoder.setPresentationTime(ts);
                                this.surfaceManagerEncoder.swapBuffer();
                            }
                        }
                    }
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        finally {
            this.surfaceManager.release();
            this.simpleCameraRender.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        Object object = this.sync;
        synchronized (object) {
            this.frameAvailable = true;
            this.sync.notifyAll();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.i((String)TAG, (String)("size: " + width + "x" + height));
        this.previewWidth = width;
        this.previewHeight = height;
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.stopGlThread();
    }
}

