/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.rtsp;

import android.media.MediaCodec;
import android.support.annotation.RequiresApi;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.rtplibrary.base.FromFileBase;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public class RtspFromFile
extends FromFileBase {
    private RtspClient rtspClient;

    public RtspFromFile(ConnectCheckerRtsp connectCheckerRtsp, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        super(videoDecoderInterface, audioDecoderInterface);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
    }

    public void setProtocol(Protocol protocol) {
        this.rtspClient.setProtocol(protocol);
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.rtspClient.setAuthorization(user, password);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtspClient.setUrl(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void onSPSandPPSRtp(ByteBuffer sps, ByteBuffer pps) {
        ByteBuffer newSps = sps.duplicate();
        ByteBuffer newPps = pps.duplicate();
        this.rtspClient.setSPSandPPS(newSps, newPps);
        this.rtspClient.connect();
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendAudio(aacBuffer, info);
    }
}

