/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.rtsp;

import android.media.MediaCodec;
import android.support.annotation.RequiresApi;
import android.view.SurfaceView;
import android.view.TextureView;
import com.pedro.rtplibrary.base.Camera1Base;
import com.pedro.rtplibrary.view.OpenGlView;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.nio.ByteBuffer;

public class RtspCamera1
extends Camera1Base {
    private RtspClient rtspClient;

    public RtspCamera1(SurfaceView surfaceView, ConnectCheckerRtsp connectCheckerRtsp) {
        super(surfaceView);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
    }

    public RtspCamera1(TextureView textureView, ConnectCheckerRtsp connectCheckerRtsp) {
        super(textureView);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
    }

    @RequiresApi(api=18)
    public RtspCamera1(OpenGlView openGlView, ConnectCheckerRtsp connectCheckerRtsp) {
        super(openGlView);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
    }

    public void setProtocol(Protocol protocol) {
        this.rtspClient.setProtocol(protocol);
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.rtspClient.setAuthorization(user, password);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtspClient.setIsStereo(isStereo);
        this.rtspClient.setSampleRate(sampleRate);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtspClient.setUrl(url);
        if (!this.cameraManager.isPrepared()) {
            this.rtspClient.connect();
        }
    }

    @Override
    protected void stopStreamRtp() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSPSandPPSRtp(ByteBuffer sps, ByteBuffer pps) {
        ByteBuffer newSps = sps.duplicate();
        ByteBuffer newPps = pps.duplicate();
        this.rtspClient.setSPSandPPS(newSps, newPps);
        this.rtspClient.connect();
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendVideo(h264Buffer, info);
    }
}

